% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify.R
\name{specify_TJ}
\alias{specify_TJ}
\title{Converts units from EJ to TJ}
\usage{
specify_TJ(
  .df,
  energy_col = MWTools::mw_cols$e_dot,
  units_col = MWTools::mw_cols$unit
)
}
\arguments{
\item{.df}{A data frame with \code{units_col} and \code{energy_col} columns.}

\item{energy_col, units_col}{See \code{MWTools::mw_constants}.}
}
\value{
\code{.df} with \code{energy} column converted from EJ to TJ.
}
\description{
Primary-final-useful (PFU) data from \code{calc_hmw_pfu()} and \code{calc_amw_pfu()}
are in EJ.
This function converts entries in the \code{energy_col} from EJ (exajoules) to TJ (terajoules) and
changes the \code{units_col} from "EJ" to "TJ".
}
\details{
Prior to converting the \code{energy_col} from EJ to TJ,
the \code{units_col} is verified to contain only "EJ".
An error is thrown if any \code{units_col} entry is not in EJ.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_data \%>\%
  calc_hmw_pfu() \%>\%
  specify_TJ()
}
