% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{prepareRawILOData}
\alias{prepareRawILOData}
\title{Prepare a unified ILO dataframe from raw employment and working hours data}
\usage{
prepareRawILOData(ilo_working_hours_data, ilo_employment_data)
}
\arguments{
\item{ilo_working_hours_data}{A dataframe containing raw ILO working hours data.}

\item{ilo_employment_data}{A dataframe containing raw ILO employment data.}
}
\description{
Prepare a unified ILO dataframe from raw employment and working hours data,
usually obtained using the {Rilostat} R package.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                  ilo_employment_data = ilo_employment_data)
}
