% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psut.R
\name{prep_psut}
\alias{prep_psut}
\title{A convenience function to create PSUT matrices in a data frame}
\usage{
prep_psut(
  .hmw_df,
  .amw_df,
  matrix_class = c("matrix", "Matrix"),
  output_unit = c("TJ", "ktoe"),
  unit = IEATools::iea_cols$unit,
  R = IEATools::psut_cols$R,
  U = IEATools::psut_cols$U,
  V = IEATools::psut_cols$V,
  Y = IEATools::psut_cols$Y,
  s_units = IEATools::psut_cols$s_units,
  U_feed = IEATools::psut_cols$U_feed,
  U_eiou = IEATools::psut_cols$U_eiou,
  r_eiou = IEATools::psut_cols$r_eiou
)
}
\arguments{
\item{.hmw_df}{A data frame produced by \code{calc_hmw_pfu()}.}

\item{.amw_df}{A data frame produced by \code{calc_amw_pfu()}.}

\item{matrix_class}{The type of matrix to be created, one of "matrix" or "Matrix".
Default is "matrix".}

\item{output_unit}{A string of length one that specifies the output unit.
One of "TJ" or "ktoe" for terajoules or kilotons of oil equivalent.}

\item{unit, R, U, V, Y, s_units, U_feed, U_eiou, r_eiou}{Column names. See \code{IEATools::psut_cols}.}
}
\value{
A data frame of musle work PSUT matrices.
}
\description{
Starting from human and animal muscle work data frames,
this function bundles several functions to create a
data frame of PSUT matrices.
The bundled functions are:
\itemize{
\item \code{specify_energy_type_method()},
\item \code{specify_product()},
\item \code{specify_ktoe()} or \code{specify_TJ()}, depending on the value of \code{output_unit},
\item \code{MWTools::specify_primary_production()},
\item \code{specify_useful_products()},
\item \code{specify_fu_machines()},
\item \code{specify_last_stages()},
\item \code{MWTools::add_row_col_meta()},
\item \code{MWTools::collapse_to_psut()},
\item \code{calc_S_units()}, and
\item \code{calc_U_feed_U_eiou_r_eiou()}.
}
}
\details{
Default values are assumed for function arguments.

The "Unit" column is deleted after the "S_units" column is created.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu() \%>\%
  # Keep only a few years for speed.
  dplyr::filter(Year \%in\% 2000:2002)
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu() \%>\%
  # Keep only a few years for speed.
  dplyr::filter(Year \%in\% 2000:2002)
prep_psut(hmw_df, amw_df)
}
