% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_to_exergy.R
\name{phi_vec_mw}
\alias{phi_vec_mw}
\title{Create a phi vector for muscle work energy conversion chains}
\usage{
phi_vec_mw(
  .phi_table = MWTools::phi_constants_mw,
  matrix_class = c("matrix", "Matrix"),
  mw_energy_carriers = MWTools::mw_products,
  product = MWTools::mw_cols$product,
  product_type = MWTools::row_col_types$product,
  phi = "phi"
)
}
\arguments{
\item{.phi_table}{A table of phi (exergy-to-energy ratio) values.}

\item{matrix_class}{The type of matrix to be created, one of "matrix" or "Matrix".
Default is "matrix".}

\item{mw_energy_carriers}{A vector of string energy carriers
relevant to muscle work calculations.
Default is \code{MWTools::mw_products}.}

\item{product}{See \code{MWTools::mw_cols}.}

\item{product_type}{See \code{MWTools::row_col_types}.}

\item{phi}{The name of the phi column in the outgoing vector.
Default is "phi".}
}
\value{
A column vector of phi values.
}
\description{
To move from an energy to an exergy description of an energy conversion chain,
a vector of phi (exergy-to-energy ratio) values is needed.
Entries in the vector are for each type of muscle work energy carrier.
}
\examples{
phi_vec_mw()
phi_vec_mw(mw_energy_carriers = c("Food", "Feed"))
}
