% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hmw_analysis_constants}
\alias{hmw_analysis_constants}
\title{Human muscle work (hmw) analysis data constants}
\format{
A string list with 19 entries.
\describe{
\item{total_wk_hrs_ilo_col}{The data column "Total.hours [hours/year]" containing the number of hours worked yearly by all humans for a given country, sex, sector, and year.}
\item{col_1960}{The column for 1960. Default is "1960".}
\item{col_2020}{The column for 2020. Default is "2020".}
\item{labor_type_col}{The data column "Labor.Type" containing information on the human labor type (Primary, Secondary, or Sedentary) of human workers.}
\item{labor_split_col}{The data column "Labor.Type.Split" containing information on the proportion of human labor type by sector.}
\item{hmw_power_sheet}{The excel sheet name "hmw_power", which contains information on the power output of humans performing muscle work.}
\item{hmw_food_sheet}{The excel sheet name "hmw_food", which contains information on the food consumption of humans.}
\item{hmw_labor_map_sheet}{The excel sheet name "hmw_sector_labor_map", which contains data on the split of labor type by ILO broad sector.}
\item{hmw_sector_map_sheet}{The excel sheet name "hmw_sector_map", which contains information on the mapping the sector names used in the hmw analysis data excel file bundled with this package with the sector names in the ILO data.}
\item{hmw_plate_waste_sheet}{The excel sheet name "hmw_plate_waste", which contains information on proportion of food waste by region.}
\item{hmw_harvest_waste_sheet}{The excel sheet name "hmw_harvest_waste", which contains information on the proportion of phytomass lost at the harvest stage by region.}
\item{food_consumption_col}{The data column "Food consumption [kcal/day per person]", which contains information on the daily food consumption of humans in kilocalories (kcal).}
\item{energy_pppa_col}{The data column "Energy consumption [MJ/year per person]", which contains information on the yearly food consumption per working person in megajoules (MJ).}
\item{final_energy_col}{The data column "Final energy [MJ/year]", which contains data on the yearly food consumption of all working persons in megajoules (MJ).}
\item{primary_energy_col}{The data column "Primary energy [MJ/year]", which contains data on the yearly quantity of biomass required to meet the food requirements of all working persons in megajoules (MJ).}
\item{useful_energy_hmw_col}{The data column "Useful energy [MJ/year]", which contains data on the yearly useful work performed by all working persons in megajoules (MJ).}
\item{power_col}{The data column "Power [W]", which contains data on the power output of humans performing muscle work.}
\item{plate_waste_col}{The data column "Plate waste [-]", which contains data on the proportion of food waste by region.}
\item{hmw_harvest_waste_col}{The data column "arvest waste [-]", which contains data on the proportion of phytomass lost at the harvest stage by region.}
}
}
\usage{
hmw_analysis_constants
}
\description{
A string list containing a selection of hmw analysis constants.
}
\examples{
hmw_analysis_constants
}
\keyword{datasets}
