% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_amw_functions.R
\name{get_working_species}
\alias{get_working_species}
\title{Create a data frame containing the total number of animals of working species}
\usage{
get_working_species(
  .df,
  species = MWTools::mw_constants$species,
  country_code_col = MWTools::conc_cols$country_code_col,
  amw_region_code_col = MWTools::conc_cols$amw_region_code_col,
  year = MWTools::mw_cols$year,
  value = MWTools::mw_constants$value,
  asses = MWTools::mw_species$asses,
  camels = MWTools::mw_species$camels,
  cattle = MWTools::mw_species$cattle,
  horses = MWTools::mw_species$horses,
  mules = MWTools::mw_species$mules,
  buffaloes = MWTools::mw_species$buffaloes,
  camelids_other = MWTools::mw_species$camelids_other,
  camelids = MWTools::mw_species$camelids,
  live_animals_col = MWTools::amw_analysis_constants$live_animals_col
)
}
\arguments{
\item{.df}{A tidy data frame containing the number of live animals by
country over time. Usually produced by calling the
\code{tidy_fao_live_animals},
\code{add_concordance_codes}, and
\code{trim_fao_data} functions in sequence on the raw FAO data.}

\item{species, value, year}{See \code{MWTools::mw_constants}.}

\item{country_code_col, amw_region_code_col}{See \code{MWtools::conc_cols}.}

\item{asses, camels, cattle, horses, mules, buffaloes, camelids_other, camelids}{See \code{MWTools::mw_species}.}

\item{live_animals_col}{See \code{MWtools::amw_analysis_constants}.}
}
\description{
Using a tidy dataframe containing the number of live animals, this function
restricts the species of animals to: Asses, Camels, Cattle, Horses, Mules,
Buffaloes, and Camelids, other; then combines Camels and Camlelids, other
into a combined "Camelids" species group.
}
\examples{
live_animals_data <- read.csv(file = MWTools::amw_test_data_path()) \%>\%
  tidy_fao_live_animals() \%>\%
  add_concordance_codes() \%>\%
  trim_fao_data() \%>\%
  get_working_species()

}
