% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{get_broad.sector_data}
\alias{get_broad.sector_data}
\title{Retrieve data with sectors organised by "Broad sector"}
\usage{
get_broad.sector_data(
  .df,
  sex_ilo_col = MWTools::ilo_cols$sex_ilo_col,
  sector_col = MWTools::mw_constants$sector_col
)
}
\arguments{
\item{.df}{A data frame containing the number of hours worked.
Usually produced by calling the
\code{add_hmw_region_codes},
\code{fill_ilo_data}, and
\code{calc_total_hours_worked} functions in sequence on the raw FAO data.}

\item{sex_ilo_col}{See \code{MWTools::ilo_cols}.}

\item{sector_col}{See \code{mWTools::mw_constants}.}
}
\description{
Retrieve data with sectors organised by "Broad sector"
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
working_hours_sector_data <- hmw_data |>
  add_hmw_region_codes() |>
  fill_ilo_data() |>
  calc_total_hours_worked() |>
  get_broad.sector_data()
}
