% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psut.R
\name{collapse_to_psut}
\alias{collapse_to_psut}
\title{Convert a tidy data frame to PSUT matrices}
\usage{
collapse_to_psut(
  .df,
  matrix_class = c("matrix", "Matrix"),
  country = MWTools::mw_cols$country,
  year = MWTools::mw_cols$year,
  method = MWTools::mw_cols$method,
  energy_type = MWTools::mw_cols$energy_type,
  last_stage = MWTools::mw_cols$last_stage,
  unit = MWTools::mw_cols$unit,
  e_dot = MWTools::mw_cols$e_dot,
  matnames = MWTools::mat_meta_cols$matnames,
  matvals = MWTools::mat_meta_cols$matvals,
  rownames = MWTools::mat_meta_cols$rownames,
  colnames = MWTools::mat_meta_cols$colnames,
  rowtypes = MWTools::mat_meta_cols$rowtypes,
  coltypes = MWTools::mat_meta_cols$coltypes
)
}
\arguments{
\item{.df}{A data frame created by \code{add_row_col_meta()} so that it contains
metadata columns for creating PSUT matrices.}

\item{matrix_class}{The type of matrix to be created, one of "matrix" or "Matrix".
Default is "matrix".}

\item{country, year, method, energy_type, last_stage, unit, e_dot}{See \code{MWTools::mw_cols}.}

\item{matnames, matvals, rownames, colnames, rowtypes, coltypes}{See \code{MWTools::mat_meta_cols}.}
}
\value{
A \code{matsindf}-style, wide-by-matrices data frame of muscle work matrices.
}
\description{
A tidy data frame of muscle work information can be converted to
a \code{matsindf} data frame via this function.
}
\details{
Prior to forming matrices, this function deletes unneeded columns
(columns that are neither metadata nor energy values).
It also aggregates data frame rows that will end up at the same
row, column location in the matrices.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu() \%>\%
  # Keep only a few years for speed.
  dplyr::filter(Year \%in\% 2000:2002)
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu() \%>\%
  # Keep only a few years for speed.
  dplyr::filter(Year \%in\% 2000:2002)
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product() \%>\%
  specify_TJ() \%>\%
  MWTools::specify_primary_production() \%>\%
  specify_useful_products() \%>\%
  specify_fu_machines() \%>\%
  specify_last_stages() \%>\%
  MWTools::add_row_col_meta() \%>\%
  MWTools::collapse_to_psut()
}
