% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_amw_functions.R
\name{calc_useful_energy}
\alias{calc_useful_energy}
\title{Calculate the useful energy produced by working animals performing muscle work}
\usage{
calc_useful_energy(
  .df,
  amw_analysis_data_path = MWTools::amw_analysis_data_path(),
  species = MWTools::mw_constants$species,
  method_source = MWTools::mw_constants$method_source,
  wa_power_sheet = MWTools::amw_analysis_constants$wa_power_sheet,
  wa_days_hours_sheet = MWTools::amw_analysis_constants$wa_days_hours_sheet,
  working_days_col = MWTools::amw_analysis_constants$working_days_col,
  working_hours_col = MWTools::amw_analysis_constants$working_hours_col,
  working_seconds_col = MWTools::amw_analysis_constants$working_seconds_col,
  amw_region_code_col = MWTools::conc_cols$amw_region_code_col,
  power_per_animal = MWTools::amw_analysis_constants$power_per_animal,
  useful_energy_total = MWTools::amw_analysis_constants$useful_energy_total,
  useful_energy_ag = MWTools::amw_analysis_constants$useful_energy_ag,
  useful_energy_tr = MWTools::amw_analysis_constants$useful_energy_tr,
  working_animals_total_col = MWTools::amw_analysis_constants$working_animals_total_col,
  working_animals_ag_col = MWTools::amw_analysis_constants$working_animals_ag_col,
  working_animals_tr_col = MWTools::amw_analysis_constants$working_animals_tr_col
)
}
\arguments{
\item{.df}{A data frame containing the primary and final energy consumed by
working animals. Usually produced by calling the
\code{tidy_fao_live_animals},
\code{add_concordance_codes},
\code{trim_fao_data},
\code{get_working_species},
\code{calc_working_animals},
\code{calc_sector_split},
\code{calc_yearly_feed},
\code{calc_final_energy}, and
\code{calc_primary_energy} functions in sequence on the raw FAO data.}

\item{amw_analysis_data_path}{The path to the animal muscle work analysis data,
containing data for the number of working hours and
power outputs of working animals. Set to the function
\code{MWTools::amw_analysis_data_path()} by default,
which returns the path the analysis data bundled with
the \code{MWTools} package.}

\item{species, method_source}{See \code{MWTools::mw_constants}.}

\item{wa_power_sheet, wa_days_hours_sheet}{See \code{MWTools::amw_analysis_constants}.}

\item{working_hours_col, working_seconds_col}{See \code{MWTools::amw_analysis_constants}.}

\item{amw_region_code_col, power_per_animal}{See \code{MWTools::amw_analysis_constants}.}

\item{useful_energy_total, useful_energy_ag, useful_energy_tr}{See \code{MWTools::amw_analysis_constants}.}

\item{working_animals_total_col, working_animals_ag_col, working_animals_tr_col, working_days_col}{See \code{MWTools::amw_analysis_constants}.}
}
\description{
Calculate the useful energy produced by working animals performing muscle work
}
\examples{
MWTools::amw_test_data_path() \%>\%
  read.csv() \%>\%
  tidy_fao_live_animals() \%>\%
  add_concordance_codes() \%>\%
  trim_fao_data() \%>\%
  get_working_species() \%>\%
  calc_working_animals() \%>\%
  calc_sector_split() \%>\%
  calc_yearly_feed() \%>\%
  calc_final_energy() \%>\%
  calc_primary_energy() \%>\%
  calc_useful_energy()
}
