% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{calc_total_hours_worked}
\alias{calc_total_hours_worked}
\title{Calculate the total number of hours worked each year}
\usage{
calc_total_hours_worked(
  .df,
  yearly_working_hours_ilo_col = MWTools::ilo_cols$yearly_working_hours_ilo_col,
  employed_persons_ilo_col = MWTools::ilo_cols$employed_persons_ilo_col,
  total_wk_hrs_ilo_col = MWTools::hmw_analysis_constants$total_wk_hrs_ilo_col
)
}
\arguments{
\item{.df}{The ILO labor data filled (held constant back to 1960 from the
earliest year of data).
Usually produced by calling the
\code{add_hmw_region_codes}, and
\code{fill_ilo_data} functions in sequence on the raw FAO data.}

\item{yearly_working_hours_ilo_col, employed_persons_ilo_col}{See \code{MWTools::ilo_cols}.}

\item{total_wk_hrs_ilo_col}{See \code{MWTools::hmw_analysis_constants}}
}
\description{
Calc...
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
working_hours_data <- hmw_data |>
  add_hmw_region_codes() |>
  fill_ilo_data() |>
  calc_total_hours_worked()
}
