% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_amw_functions.R
\name{calc_primary_energy}
\alias{calc_primary_energy}
\title{Calculate the primary energy embodied in the feed supplied to working animals}
\usage{
calc_primary_energy(
  .df,
  harvest_waste = 0.45,
  final_energy_total = MWTools::amw_analysis_constants$final_energy_total,
  final_energy_ag = MWTools::amw_analysis_constants$final_energy_ag,
  final_energy_tr = MWTools::amw_analysis_constants$final_energy_tr,
  primary_energy_total = MWTools::amw_analysis_constants$primary_energy_total,
  primary_energy_ag = MWTools::amw_analysis_constants$primary_energy_ag,
  primary_energy_tr = MWTools::amw_analysis_constants$primary_energy_tr
)
}
\arguments{
\item{.df}{A data frame containing the final energy consumption of working
animals. Usually produced by calling the
\code{tidy_fao_live_animals},
\code{add_concordance_codes},
\code{trim_fao_data},
\code{get_working_species},
\code{calc_working_animals},
\code{calc_sector_split},
\code{calc_yearly_feed}, and
\code{calc_final_energy} functions in sequence on the raw FAO data.}

\item{harvest_waste}{The proportion of energy embodied in biomass wasted when
animal feed is harvested.}

\item{final_energy_total, final_energy_ag, final_energy_tr, primary_energy_total, primary_energy_ag, primary_energy_tr}{See \code{MWTools::amw_analysis_constants}.}
}
\description{
Calculate the primary energy embodied in the feed supplied to working animals
}
\examples{
working_animals_data <- read.csv(file = MWTools::amw_test_data_path()) \%>\%
  tidy_fao_live_animals() \%>\%
  add_concordance_codes() \%>\%
  trim_fao_data() \%>\%
  get_working_species() \%>\%
  calc_working_animals() \%>\%
  calc_sector_split() \%>\%
  calc_yearly_feed() \%>\%
  calc_final_energy() \%>\%
  calc_primary_energy()

}
