% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{calc_hmw_useful_energy}
\alias{calc_hmw_useful_energy}
\title{Calculate the useful energy produced by human workers}
\usage{
calc_hmw_useful_energy(
  .df,
  sector_col = MWTools::mw_constants$sector_col,
  year = MWTools::mw_cols$year,
  unit = MWTools::mw_cols$unit,
  sex_ilo_col = MWTools::ilo_cols$sex_ilo_col,
  hmw_region_code_col = MWTools::conc_cols$hmw_region_code_col,
  hmw_analysis_data_path = MWTools::hmw_analysis_data_path(),
  hmw_power_sheet = MWTools::hmw_analysis_constants$hmw_power_sheet,
  labor_type_col = MWTools::hmw_analysis_constants$labor_type_col,
  power_col = MWTools::hmw_analysis_constants$power_col,
  total_wk_hrs_ilo_col = MWTools::hmw_analysis_constants$total_wk_hrs_ilo_col,
  useful_energy_hmw_col = MWTools::hmw_analysis_constants$useful_energy_hmw_col,
  hours_to_seconds = MWTools::unit_constants$hours_to_seconds,
  joules_to_megajoules = MWTools::unit_constants$joules_to_megajoules
)
}
\arguments{
\item{.df}{A data frame containing the final and useful energy consumed
by human workers.
Usually produced by calling the
\code{add_hmw_region_codes},
\code{fill_ilo_data},
\code{calc_total_hours_worked},
\code{get_broad.sector_data},
\code{split_labor_by_sector},
\code{calc_hmw_final_energy}, and
\code{calc_hmw_primary_energy} functions in sequence on the raw FAO data.}

\item{sector_col, year, unit}{See \code{MWTools::mw_constants}.}

\item{sex_ilo_col}{See \code{MWTools::ilo_cols}.}

\item{hmw_region_code_col}{See \code{MWTools::conc_cols}.}

\item{hmw_analysis_data_path, hmw_power_sheet, power_col, total_wk_hrs_ilo_col, useful_energy_hmw_col, hours_to_seconds, joules_to_megajoules, labor_type_col}{See \code{MWTools::hmw_analysis_constants}.}
}
\description{
Calculate the useful energy produced by human workers
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
useful_energy_data <- hmw_data |>
  add_hmw_region_codes() |>
  fill_ilo_data() |>
  calc_total_hours_worked() |>
  get_broad.sector_data() |>
  split_labor_by_sector() |>
  calc_hmw_final_energy() |>
  calc_hmw_primary_energy() |>
  calc_hmw_useful_energy()
}
