% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{calc_hmw_primary_energy}
\alias{calc_hmw_primary_energy}
\title{Calculate the primary energy consumed by human workers}
\usage{
calc_hmw_primary_energy(
  .df,
  year = MWTools::mw_cols$year,
  unit = MWTools::mw_cols$unit,
  exemplar_method_col = MWTools::mw_constants$exemplar_method_col,
  hmw_analysis_data_path = MWTools::hmw_analysis_data_path(),
  hmw_harvest_waste_sheet = MWTools::hmw_analysis_constants$hmw_harvest_waste_sheet,
  final_energy_col = MWTools::hmw_analysis_constants$final_energy_col,
  primary_energy_col = MWTools::hmw_analysis_constants$primary_energy_col,
  hmw_harvest_waste_col = MWTools::hmw_analysis_constants$hmw_harvest_waste_col,
  hmw_region_code_col = MWTools::conc_cols$hmw_region_code_col
)
}
\arguments{
\item{.df}{A data frame containing the final energy consumed by human
workers.
Usually produced by calling the
\code{add_hmw_region_codes},
\code{fill_ilo_data},
\code{calc_total_hours_worked},
\code{get_broad.sector_data},
\code{split_labor_by_sector}, and
\code{calc_hmw_final_energy} functions in sequence on the raw FAO data.}

\item{year, unit, exemplar_method_col}{See \code{MWTools::mw_constants}.}

\item{hmw_analysis_data_path, hmw_harvest_waste_sheet, final_energy_col, primary_energy_col, hmw_harvest_waste_col}{See \code{MWTools::hmw_analysis_constants}.}

\item{hmw_region_code_col}{See \code{MWTools::conc_cols}.}
}
\description{
Calculate the primary energy consumed by human workers
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
primary_energy_data <- hmw_data |>
  add_hmw_region_codes() |>
  fill_ilo_data() |>
  calc_total_hours_worked() |>
  get_broad.sector_data() |>
  split_labor_by_sector() |>
  calc_hmw_final_energy() |>
  calc_hmw_primary_energy()
}
