% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{calc_hmw_pfu}
\alias{calc_hmw_pfu}
\title{Calculate primary, final, and useful human muscle work.}
\usage{
calc_hmw_pfu(
  .df,
  concordance_path = MWTools::fao_concordance_path(),
  hmw_analysis_data_path = MWTools::hmw_analysis_data_path()
)
}
\arguments{
\item{.df}{The raw ILO data, retrieved from ILOSTAT.}

\item{concordance_path}{The path to the muscle work concordance information.}

\item{hmw_analysis_data_path}{The path to the human muscle work analysis data.}
}
\description{
Calculate primary, final, and useful human muscle work.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
pfu_energy_data <- hmw_data |>
  calc_hmw_pfu()
}
