% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_amw_functions.R
\name{calc_amw_pfu}
\alias{calc_amw_pfu}
\title{Calculate primary, final, and useful working animal energy}
\usage{
calc_amw_pfu(
  .df,
  concordance_path = MWTools::fao_concordance_path(),
  amw_analysis_data_path = MWTools::amw_analysis_data_path()
)
}
\arguments{
\item{.df}{A data frame containing the raw FAO live animals data,
corresponding to the "QCL" FAO bulk download query.}

\item{concordance_path}{The path to the muscle work concordance information.}

\item{amw_analysis_data_path}{The path to the animal muscle work analysis data.}
}
\description{
Calculate the total number of working animals and primary, final, and useful
working animal energy by country, for six species: Asses, Buffaloes, Camelids,
Cattle, Horses, and Mules, and three sector categories: Total, Agriculture,
and Transport. This function acts as a helper function calling a number of functions
in sequence to convert FAO data for live animals, usually downloaded with the function
\code{down_fao_live_animals}, into a tidy data frame.
}
\examples{
tidy_amw_pfu_data <- read.csv(file = MWTools::amw_test_data_path()) \%>\%
  calc_amw_pfu()

}
