% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psut.R
\name{calc_U_feed_U_eiou_r_eiou}
\alias{calc_U_feed_U_eiou_r_eiou}
\title{Calculate U_feed, U_eiou, and r_eiou columns from a U matrix}
\usage{
calc_U_feed_U_eiou_r_eiou(
  .df = NULL,
  U = MWTools::psut_cols$U,
  U_feed = MWTools::psut_cols$U_feed,
  U_eiou = MWTools::psut_cols$U_eiou,
  r_eiou = MWTools::psut_cols$r_eiou
)
}
\arguments{
\item{.df}{A PSUT data frame containing a column of \code{U} matrices.
Default is \code{NULL}, allowing a single matrix for the \code{U} argument.}

\item{U}{The name of the incoming \code{U} matrix. See \code{MWTools::psut_cols}.}

\item{U_feed, U_eiou, r_eiou}{Names for outgoing matrices. See \code{MWTools::psut_cols}.}
}
\value{
\code{.df} with new columns for \code{U_feed}, \code{U_eiou}, and \code{r_eiou} matrices.
}
\description{
\code{U_feed}, \code{U_eiou}, and \code{r_eiou} matrices are calculated from \code{U}.
All three matrices (\code{U_feed}, \code{U_eiou}, and \code{r_eiou})
have the same structure (row names, column names, row types, and column types)
as \code{U}.
For \code{MWTools}, there is no energy industry own use (EIOU),
so \code{U_feed} is simply a copy of \code{U}, and \code{U_eiou} and \code{r_eiou} are full of \code{0}s.
}
\details{
This function employs \code{matsindf::matsindf_apply()} internally, so
\code{U} can be either a single matrix or the name of the \code{U} column in \code{.df}.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu() \%>\%
  # Keep only a few years for speed.
  dplyr::filter(Year \%in\% 2000:2002)
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu() \%>\%
  # Keep only a few years for speed.
  dplyr::filter(Year \%in\% 2000:2002)
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product() \%>\%
  specify_TJ() \%>\%
  MWTools::specify_primary_production() \%>\%
  specify_useful_products() \%>\%
  specify_fu_machines() \%>\%
  specify_last_stages() \%>\%
  MWTools::add_row_col_meta() \%>\%
  MWTools::collapse_to_psut() \%>\%
  calc_S_units() \%>\%
  calc_U_feed_U_eiou_r_eiou()
}
