% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psut.R
\name{add_row_col_meta}
\alias{add_row_col_meta}
\title{Prep PFU data for conversion to PSUT matrices}
\usage{
add_row_col_meta(
  .df,
  biomass = MWTools::mw_products$biomass,
  food = MWTools::mw_products$food,
  feed = MWTools::mw_products$feed,
  hu_mech = MWTools::mw_products$hu_mech,
  an_mech = MWTools::mw_products$an_mech,
  an_p = MWTools::mw_products$an_p,
  resources = MWTools::mw_sectors$resources_sector,
  farms = MWTools::mw_sectors$farms,
  food_production = MWTools::mw_sectors$food_production,
  feed_production = MWTools::mw_sectors$feed_production,
  transport = MWTools::mw_sectors$transport_sector,
  human_females = MWTools::mw_species$human_females,
  human_males = MWTools::mw_species$human_males,
  final = MWTools::all_stages$final,
  useful = MWTools::all_stages$useful,
  species = MWTools::mw_constants$species,
  sector = MWTools::mw_constants$sector_col,
  stage = MWTools::mw_constants$stage_col,
  product = MWTools::mw_cols$product,
  last_stage = MWTools::mw_cols$last_stage,
  matnames = MWTools::mat_meta_cols$matnames,
  rownames = MWTools::mat_meta_cols$rownames,
  colnames = MWTools::mat_meta_cols$colnames,
  rowtypes = MWTools::mat_meta_cols$rowtypes,
  coltypes = MWTools::mat_meta_cols$coltypes,
  R_name = MWTools::psut_cols$R,
  U_name = MWTools::psut_cols$U,
  V_name = MWTools::psut_cols$V,
  Y_name = MWTools::psut_cols$Y,
  industry_type = MWTools::row_col_types$industry,
  product_type = MWTools::row_col_types$product,
  product_notation = RCLabels::from_notation,
  resource_notation = RCLabels::of_notation,
  species_notation = RCLabels::arrow_notation
)
}
\arguments{
\item{.df}{A data frame containing muscle work data,
likely the output from \code{specify_last_stages()}.}

\item{biomass, food, feed, hu_mech, an_mech, an_p}{See \code{MWTools::mw_products}.}

\item{resources, farms, food_production, feed_production, transport}{See \code{MWTools::mw_sectors}}

\item{human_females, human_males}{See \code{MWTools::mw_species}.}

\item{final, useful}{See \code{MWTools::all_stages}.}

\item{species, sector, stage}{See \code{MWTools::mw_constants}}

\item{product, last_stage}{See \code{MWTools::mw_cols}.}

\item{matnames, rownames, colnames, rowtypes, coltypes}{See \code{MWTools::mat_meta_cols}.}

\item{R_name, U_name, V_name, Y_name}{See \code{MWTools::psut_cols}.}

\item{industry_type, product_type}{See \code{MWTools::row_col_types}.}

\item{product_notation}{The notation for products. Default is \code{RCLabels::from_notation}.}

\item{resource_notation}{The notation for resources. Default is \code{RCLabels::of_notation}.}

\item{species_notation}{The notation for species. Default is \code{RCLabels::arrow_notation}.}
}
\value{
A data frame containing PSUT matrices
representing muscle work energy conversion chains.
}
\description{
Primary-final-useful (PFU) data need to be converted to PSUT matrices.
This function take the output of \code{specify_last_stages()}
and converts to PSUT matrices in a data frame.
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
hmw_df <- hmw_data \%>\%
  calc_hmw_pfu()
amw_df <- amw_test_data_path() \%>\%
  read.csv() \%>\%
  calc_amw_pfu()
specify_energy_type_method(hmw_df, amw_df) \%>\%
  specify_product() \%>\%
  specify_TJ() \%>\%
  MWTools::specify_primary_production() \%>\%
  specify_useful_products() \%>\%
  specify_fu_machines() \%>\%
  specify_last_stages() \%>\%
  MWTools::add_row_col_meta()
}
