% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hmw_functions.R
\name{add_hmw_region_codes}
\alias{add_hmw_region_codes}
\title{Add the regional codes used on analysis of human muscle work.}
\usage{
add_hmw_region_codes(
  .df,
  concordance_path = MWTools::fao_concordance_path(),
  mapping_sheet = MWTools::conc_cols$mapping_sheet,
  country_col = MWTools::conc_cols$country_col,
  country_code_col = MWTools::conc_cols$country_code_col,
  country_incl_col = MWTools::conc_cols$country_incl_col,
  hmw_region_code_col = MWTools::conc_cols$hmw_region_code_col,
  sex_ilo_col = MWTools::ilo_cols$sex_ilo_col,
  sector_col = MWTools::mw_constants$sector_col,
  year = MWTools::mw_cols$year,
  yearly_working_hours_ilo_col = MWTools::ilo_cols$yearly_working_hours_ilo_col,
  employed_persons_ilo_col = MWTools::ilo_cols$employed_persons_ilo_col,
  yes_const = MWTools::amw_analysis_constants$yes_const
)
}
\arguments{
\item{.df}{The raw ILO data, retrieved from ILOSTAT.}

\item{concordance_path}{The path to the country code concordance information.
Set to the bundled information by default,
retrieved using the \code{fao_concordance_path} function.}

\item{country_col, country_code_col, country_incl_col, hmw_region_code_col, mapping_sheet}{See \code{MWTools::conc_cols}.}

\item{sex_ilo_col, yearly_working_hours_ilo_col, employed_persons_ilo_col}{See \code{MWTools::ilo_cols}.}

\item{sector_col, year}{See \code{MWTools::mw_constants}.}

\item{yes_const}{See \code{MWTools::amw_analysis_constants}.}
}
\description{
...
}
\examples{
ilo_working_hours_data <- read.csv(file = MWTools::ilo_working_hours_test_data_path())
ilo_employment_data <- read.csv(file = MWTools::ilo_employment_test_data_path())
hmw_data <- prepareRawILOData(ilo_working_hours_data = ilo_working_hours_data,
                              ilo_employment_data = ilo_employment_data)
working_humans_data <- hmw_data |>
  add_hmw_region_codes()
}
