#ifndef T_BUILD_ARRAY_H
#define T_BUILD_ARRAY_H

template <class T>
class build_array_item {
private:
  build_array_item<T> *d_next;
  T d_obj;
public:
  build_array_item(build_array_item<T> *next,T obj) :
    d_next(next), d_obj(obj)
  { 
  };

  inline build_array_item<T>* next()
  { return(d_next);
  }

  inline T val()
  { return(d_obj);
  }
};

template <class T>
class build_array  {
private:
  build_array_item<T> *d_first;

public:
  build_array() : d_first(0)
  { 
  }

  ~build_array() 
  { destroy();
  }

  /* Destroy the list */
  void destroy()
  { build_array_item<T> *p,*n;
    p = d_first;
    while(p)
    { n = p->next();
      delete p;
      p = n;
    }
    d_first = 0;
  }

  /* Add an item to the list */
  void add(T obj)
  { d_first = new build_array_item<T>(d_first,obj);
  }

  /* Create array from the list  */
  /* Reset the list to 0         */
  /* Return an array of object   */
  /* Array size copied into size */
  T * makeArray(int & size)
  { T *arr;
    build_array_item<T> *ip;
    int s,i;

    i = 0;
    ip = d_first;
    while(ip)
    { i++;
      ip = ip->next();
    }
    s = i;

    arr = new T [i+1];
    arr[i--] = 0;
    ip = d_first;
    while(i >= 0)
    { arr[i--] = ip->val();
      ip = ip->next();
    }

    destroy();

    size = s;   
    return(arr);
  }
};

#endif
