#ifndef P_CAGES_BI_SP_H
#define P_CAGES_BI_SP_H

#include <string>
#include <sstream>
#include <p_cage_bi.h>

const int SP_NX1 = 0;
const int SP_NY1 = 1;
const int SP_NZ1 = 2;
const int SP_NX2 = 3;
const int SP_NY2 = 4;
const int SP_NZ2 = 5;
const int SP_N1T = 6;
const int SP_N2T = 7;
const int SP_N3T = 8;
const int SP_N4T = 9;
const int SP_N5T = 10;
const int SP_N6T = 11;
const int SP_NA  = 12;


class p_cage_bi_sp : public p_cage_bi
{ public:
  
public:
  p_cage_bi_sp(int P1, int P2, int q1, int q2, int q3, int Q1, int Q2, int Q3,
	       double cl, double ca, double cc, double cpc,
	       double *v0, double *dv,
	       int n_sweep, int n_monitor, double dvcoef=0.1);
  
  virtual ~p_cage_bi_sp();
  virtual  std::string name() { return("sp"); }
  double *init_pcage(int q1, int q2, int q3, int Q1, int Q2, int Q3,
		     int P1, int P2, int &size,
		     double S1, double S2, double ts);

  virtual void reset_geometry();
  void use_cage_weights();
  
  //virtual std::string filename_prefix();

  // not used
  virtual double Ei(int i, double *v) { return(0); };
  
  virtual void set_x_y(double *v); 
  
  //virtual double E(double *v);

  /* Impose constraints */
  virtual void check(double *v, int i);

  //void deformations(double *v);
 
  //void show_details();
  
  virtual void write(const char *ofname);
};


#endif
