#ifndef P_CAGES_BI_DART_H
#define P_CAGES_BI_DART_H

#include <string>
#include <sstream>
#include <p_cage_bi.h>

const int DART_N1T = 0;
const int DART_N2T = 1;
const int DART_NS1 = 2;
const int DART_NS2 = 3;
const int DART_NA  = 4;


class p_cage_bi_DArt : public p_cage_bi
{ public:
  vec3 gp_;
  vec3 gt_;
  vec3 g6_;
  vec3 gz_;
  mat33 Rgp2piof_,Rgtm2piot_, Rgt2piot_, PoV_, PoW_;
  
public:
  p_cage_bi_DArt(int P1, int P2, int q1, int q2, int q3, int Q1,
		 int Q2, int Q3, int Q4, int Q5,
	         double cl, double ca, double cc, double cpc,
		 double *v0, double *dv,
	         int n_sweep, int n_monitor, double dvcoef=0.1);
  
  virtual ~p_cage_bi_DArt();
  virtual  std::string name() { return("DArt"); }
  double *init_pcage(int q1, int q2, int q3, int Q1, int Q2, int Q3, int Q4,
		     int Q5, int P1, int P2, int &size,
		     double S1, double S2, double ts);

  virtual void reset_geometry();
  void use_cage_weights();
  
  //virtual std::string filename_prefix();
  virtual double Epc() { return(0);} 

  // not used
  virtual double Ei(int i, double *v) { return(0); };
  
  virtual void set_x_y(double *v); 
  
  //virtual double E(double *v);

  /* Impose constraints */
  virtual void check(double *v, int i);

  //void deformations(double *v);
 
  //void show_details();
  
  virtual void write(const char *ofname);
};


#endif
