#include <m_except.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <cstdlib>
#include "p_cages_bi_DArt.h"

using namespace std;


p_cage_bi_DArt::p_cage_bi_DArt(int P1, int P2, int q1, int q2, int q3,
			       int Q1, int Q2, int Q3, int Q4, int Q5,
			       double cl, double ca, double cc,  double cpc,
			       double *v0, double *dv,
			       int n_sweep, int n_monitor, double dvcoef) : 
  p_cage_bi(DART_NA+(q1+q2+q3-3+Q1+Q2+Q3+Q4+Q5-5)*2, P1, P2, q1,q2,q3,0,0,
	    Q1,Q2,Q3,Q4,Q5,cl,ca,cc,cpc,v0,0,n_sweep,n_monitor,dvcoef)
{ //cout<<"p_cage_bi_DArt\n"<<flush;
  
  gp_.set((1+PHI_G*PHI_G)*0.2, 0, (2*PHI_G+PHI_G*PHI_G)*0.2);
  gt_.set(0, PHI_G/3, (PHI_G+PHI_G*PHI_G)/3);
  g1_.set(0.5, PHI_G*0.5, PHI_G*PHI_G*0.5);
  g6_.set(-0.5, PHI_G*0.5, PHI_G*PHI_G*0.5);

  Rgp2piof_  = rot_v(gp_, 2*M_PI/5);
  Rgt2piot_  = rot_v(gt_, 2*M_PI/3);
  Rgtm2piot_ = rot_v(gt_, -2*M_PI/3);

  PoV_.proj_ortho(gp_);
  PoW_.proj_ortho(gt_);
    
  S1_ = S2_ = 3;
  Nhv1_ = (q1-1)*2;
  
  i_n1_ = 1;         // index of n1
  i_n2_ = 2;         // index of n2
  i_n3_ = i_n2_+q1_; // index of n3
  i_n4_ = i_n3_+1;   // index of n4
  i_n5_ = i_n4_+q2_; // index of n5
  i_n6_ = i_n5_+1;   // index of n6
  i_a1_ = i_n2_+1;   // index of a1
  i_b1_ = i_n4_+1;   // index of b1
  i_c1_ = i_n6_+1;   // index of c1

  j_n1_ = 1;         // index of n1
  j_n2_ = 2;         // index of n2
  j_n3_ = j_n2_+Q1_; // index of n3
  j_n4_ = j_n3_+1;   // index of n4
  j_n5_ = j_n4_+Q2_; // index of n5
  j_n6_ = j_n5_+1;   // index of n6
  j_n7_ = j_n6_+Q3_; // index of n7
  j_n8_ = j_n7_+1;   // index of n8
  j_n9_ = j_n8_+Q4_; // index of n9
  j_n10_ = j_n9_+1;  // index of n10
  j_A1_ = j_n2_+1;   // index of A1
  j_B1_ = j_n4_+1;   // index of B1
  j_C1_ = j_n6_+1;   // index of C1
  j_D1_ = j_n8_+1;   // index of D1
  j_E1_ = j_n10_+1;  // index of E1

  reset_geometry();
};

p_cage_bi_DArt::~p_cage_bi_DArt()
{   
};

/***************************************/
/* Recomputes the geomtry for the face */
/***************************************/
void p_cage_bi_DArt::reset_geometry()
{ // normal to the face
  //cout<<"reset_geometry()\n"<<flush;
  
  // Pyramid
  V_ = gp_*S1_;
  W1_ = gt_*S2_;

  v1_= PoV_*ey_;	     
  v1_.normalise();
  v2_ = V_.cross(v1_);
  v2_.normalise();

  w11_ = (PoW_*ex_)*-1;
  w11_.normalise();
  w12_ = W1_.cross(w11_);
  w12_.normalise();
  
  nf1_ = W1_*-1; // because face 1 and 2 are swapped over
  nf1_.normalise();
  nf2_ = V_*-1;
  nf2_.normalise();
  nf3_ = nf2_;
  nf4_ = nf2_;

  plane_crossing(V_, v1_, v2_, W1_, w11_, w12_, vU1_, vu1_);
  //cout<<"vU1="<<vU1_.str()<<" "<<vu1_.str()<<"\n";
  //cout<<"End reset_geometry()\n"<< flush;
}

void p_cage_bi_DArt::use_cage_weights()
{ weights1_[2] = 0.5; // n2
  weights1_[q1_+3] = 0.5; // n4
  weights1_[q1_+q2_+4] = 0.5; // n6
  weights2_[2] = 0.5; // n2
  weights2_[Q1_+3] = 0.5; // n4
  weights2_[Q1_+Q2_+4] = 0.5; // n6
  weights2_[Q1_+Q2_+Q3_+5] = 0.5; // n8
  weights2_[Q1_+Q2_+Q3_+Q4_+6] = 0.5; // n10
}

/* Coordinates
   v[0] : A
   v[1] : cos(theta)
   v[2] : psi
   v[3] : n_1 t
   v[4] : n_2 t
   v[5] : n_5 t
   v[6+2i] , i in [0, q1-2] coordinate for a_i 
   v[6+2(q1-1)+2i] , i in [0, q2-2] coordinate for b_i 
   v[6+2(q1+q2-2)+2i] , i in [0, q3-2] coordinate for c_i 
*/ 
void p_cage_bi_DArt::set_x_y(double *v) 
{ 
  //cout<<"q="<<q1_<<" "<<q2_<<" "<<q3_<<"\n";
  //cout<<"Q="<<Q1_<<" "<<Q2_<<" "<<Q3_<<" "<<Q4_<<" "<<Q5_<<"\n";
  //cout<<"set_x_y\n"<<flush;
  S1_ = v[DART_NS1];
  S2_ = v[DART_NS2];
  //cout<<v[DART_N1T]<<" "<<v[DART_N2T]<<" "<<v[DART_NS]<<"\n";
    
  if (new_geometry_)
  { reset_geometry();
  }
 
  //int nf1 = (q1_-1)*2;
  // We must set face of type 2 first
  // Face 2
  l2_[j_n1_] = vU1_+vu1_*v[DART_N1T];
  l2_[j_n2_] = vU1_+vu1_*v[DART_N2T];
  l2_[j_n3_] = Rgp2piof_*l2_[j_n1_];
  l2_[j_n4_] = Rgp2piof_*l2_[j_n2_];
  l2_[j_n5_] = Rgp2piof_*l2_[j_n3_];
  l2_[j_n6_] = Rgp2piof_*l2_[j_n4_];
  l2_[j_n7_] = Rgp2piof_*l2_[j_n5_];
  l2_[j_n8_] = Rgp2piof_*l2_[j_n6_];
  l2_[j_n9_] = Rgp2piof_*l2_[j_n7_];
  l2_[j_n10_] = Rgp2piof_*l2_[j_n8_];
  f_center_2_ = (l1_[j_n1_]+l1_[j_n2_]+l1_[j_n3_]+l1_[j_n4_]+l1_[j_n5_]+l1_[j_n6_]+l1_[j_n7_]+l1_[j_n8_]+l1_[j_n9_]+l1_[j_n10_])/10;
 
  // A_j
  for(int j=0; j< Q1_-1; j++)
  { l2_[j_A1_+j] = V_+v1_*v[DART_NA+Nhv1_+2*j]+v2_*v[DART_NA+Nhv1_+2*j+1];
    l2_[j_B1_+j] = Rgp2piof_*l2_[j_A1_+j];
    l2_[j_C1_+j] = Rgp2piof_*l2_[j_B1_+j];
    l2_[j_D1_+j] = Rgp2piof_*l2_[j_C1_+j];
    l2_[j_E1_+j] = Rgp2piof_*l2_[j_D1_+j];
    //cout<<"a"<<j<<"="<<v[DART_NA+Nhv1_+2*j]<<" "<<v[DART_NA+Nhv1_+2*j+1]<<"\n";
  }
  // circular chain
  l2_[0] = l2_[P2_];
  l2_[P2_+1] = l2_[1];

  // Face 1
  l1_[i_n1_] = l2_[j_n1_];
  l1_[i_n2_] = l2_[j_n2_];
  l1_[i_n3_] = Rgtm2piot_*l1_[i_n1_];
  l1_[i_n4_] = Rgtm2piot_*l1_[i_n2_];
  l1_[i_n5_] = Rgt2piot_*l1_[i_n1_];
  l1_[i_n6_] = Rgt2piot_*l1_[i_n2_];

  f_center_1_ = (l1_[i_n1_]+l1_[i_n2_]+l1_[i_n3_]+l1_[i_n4_]+l1_[i_n5_]+l1_[i_n6_])/6;
  f_center_3_ = f_center_2_;
  f_center_4_ = f_center_2_;
  
  for(int i=0; i< q1_-1; i++)
  { l1_[i_a1_+i] = W1_+w11_*v[DART_NA+2*i]+w12_*v[DART_NA+2*i+1];
    l1_[i_b1_+i] = Rgtm2piot_*l1_[i_a1_+i];
    l1_[i_c1_+i] = Rgt2piot_*l1_[i_a1_+i];
   //cout<<"a"<<i<<"="<<v[DART_NA+Nhv1_+2*i]<<" "<<v[DART_NA+2*i+1]<<"\n";
  }

  // circular chain
  l1_[0] = l1_[P1_];
  l1_[P1_+1] = l1_[1];

  //new_geometry_ =  true;
}

/* Impose constraints */
void p_cage_bi_DArt::check(double *v, int i)
{ new_geometry_ = true;
  if (relax_method_==METHOD_MC ||(i==DART_NS1)||(i==DART_NS2))
    { new_geometry_ = last_rejected_ ||(i==DART_NS1)||(i==DART_NS2);
  }
  if (i==DART_NS1)
  { if (v[DART_NS1] < 0.01) { v[DART_NS1] = 0.01; }
  }
  if (i==DART_NS2)
  { if (v[DART_NS2] < 0.01) { v[DART_NS2] = 0.01; }
  }


}
  
/* FORMAT       */
/* DArt        */
/* P1 P2 q1 q2 q3 Q1 Q2 Q3 Q4 Q5 */
/* x1 y1 z2 x2 y2 z2 */
/* cl ca cc     */
/* err_l_max err_a_max err_l_av_max err_l_av err_a_av  */
/* err_l_max_1 err_a_max_1 err_l_av_max_1 err_l_av_1 err_a_av_1 */
/* err_l_max_2 err_a_max_2 err_l_av_max_2 err_l_av_2 err_a_av_2 */
/* E_ Efc_ Epc_ */
/* V  */
/* v1 v2  */
/* W1 */
/* w11 w12  */
/* w11 w12 */
/* x11 y11 z11 */
/* x12 y12 z12 */
/* ...     */
/* x1P1 y1P1 z1P1 */
/* x21 y21 z21 */
/* x22 y22 z22 */
/* ...     */
/* x1P2 y1P2 z1P2 */
void p_cage_bi_DArt::write(const char *ofname)
{ ofstream ofs;
  ofs.open(ofname, ios::out);

  deformations(X_, true);

   //cout<<"cos_theta_="<<cos_theta_<<"\n";
  ofs <<"DArt\n";
  ofs <<P1_<<" "<<P2_<<" "<<q1_<<" "<<q2_<<" "<<q3_<<" "<<Q1_<<" "<<Q2_
      <<" "<<Q3_<<" "<<Q4_<<" "<<Q5_<<"\n";
  ofs <<x1_<<" "<<y1_<<" "<<z1_<<" "<<x2_<<" "<<y2_<<" "<<z2_<<"\n";
  ofs <<cl_<<" "<<ca_<<" "<<cc_<<"\n";
  ofs <<err_l_max_<<" "<< err_a_max_<<" "<< err_l_av_max_<<" "
      <<err_l_av_<<" "<< err_a_av_<<"\n";
  ofs <<err_l_max_1_<<" "<< err_a_max_1_ <<" "<< err_l_av_max_1_<<" "
      <<err_l_av_1_<<" "<< err_a_av_1_<<"\n";
  ofs <<err_l_max_2_<<" "<< err_a_max_2_ <<" "<< err_l_av_max_2_<<" "
      <<err_l_av_2_<<" "<< err_a_av_2_<<"\n";
  ofs <<E_<<" "<<Efc_<<" "<<Epc_<<"\n";
  
  ofs <<W1_.str2()<<"\n";
  ofs <<w11_.str2()<<" "<<w12_.str2()<<"\n";

  ofs <<V_.str2()<<"\n";
  ofs <<v1_.str2()<<" "<<v2_.str2()<<"\n";


  for (int i=1; i <= P1_; i++)
  { ofs << l1_[i].str2()<<"\n";
    //cout<<"l1="<<l1_[i].str2()<<"\n";
  }
  for (int i=1; i <= P2_; i++)
  { ofs << l2_[i].str2()<<"\n";
    //cout<<"l1="<<l2_[i].str2()<<"\n";
  }
}


/* Function to initialise the prims p-cage               */
/* Return allocated vector with initial parameter values */
/* Return size of vector in size                         */
double *p_cage_bi_DArt::init_pcage(int q1, int q2, int q3, int Q1, int Q2,
				   int Q3, int Q4, int Q5,  
				   int P1, int P2, int &size,
				   double S1, double S2, double ts) 
{ size = DART_NA+(q1+Q1-2)*2;
  double *V0 = new double [size];
  //cout<<"init_pcage size="<<size<<"\n"<<flush;
  
  // Initialise the vector
  V0[DART_N1T] = 0.5*ts;
  V0[DART_N2T] = -0.5*ts;
  V0[DART_NS1] = 3*sqrt(P1/6);
  V0[DART_NS2] = 3*sqrt(P1/6);
  set_x_y(V0);
  reset_geometry();
  
  //int nf1 = (q1_-1)*2;

  vec3 n1 = vU1_+vu1_*V0[DART_N1T];
  vec3 n2 = vU1_+vu1_*V0[DART_N2T];
  vec3 n3 = Rgp2piof_*n1;
  vec3 n4 = Rgp2piof_*n2;
  vec3 n5 = Rgp2piof_*n3;
  vec3 n6 = Rgp2piof_*n4;
  vec3 n7 = Rgp2piof_*n5;
  vec3 n8 = Rgp2piof_*n6;
  vec3 n9 = Rgp2piof_*n7;
  vec3 n10 = Rgp2piof_*n8;
  
  vec3 f_center = (n1+n2+n3+n4+n5+n6+n7+n8+n9+n10)/10;
  vec3 ev;
  // A_j
  vec3 dv = n3-n2;
  for(int j=0; j< Q1_-1; j++)
  { ev = f_center +(n2+dv*(j+1)/Q1_ -f_center)*1.1;
    V0[DART_NA+Nhv1_+2*j] = ev*v1_;
    V0[DART_NA+Nhv1_+2*j+1] = ev*v2_;
  }
  //cout<<" index1="<<DART_NA+(q1_+q2_-2)*2<<"\n";
  //cout<<"OK1\n"<<flush;
  
  vec3 m1 = n1;
  vec3 m2 = n2;
  vec3 m3 = Rgtm2piot_*n1;
  vec3 m4 = Rgtm2piot_*n2;
  vec3 m5 = Rgt2piot_*n1;
  vec3 m6 = Rgt2piot_*n2;

  f_center = (m1+m2+m3+m4+m5+m6)/6;
  // a_i
  dv = m3-m2;
  for(int i=0; i< q1_-1; i++)
  { ev = f_center +(m2+dv*(i+1)/q1_ -f_center)*1.1;
    ev = ev + W1_-f_center; // W1_ must be the origin of the face coordinates
    V0[DART_NA+2*i] = ev*w11_;
    V0[DART_NA+2*i+1] = ev*w12_;
    //cout<<"A\n";
  }


  //cout<<" index2="<<DART_NA+Nhv1_+(Q1_+Q2_-2)*2<<" Nhv1_="<<Nhv1_<<"\n";
  //cout<<"OK2\n"<<flush;

  return(V0);
}
