#ifndef P_CAGES_BI_ATO_H
#define P_CAGES_BI_ATO_H

#include <string>
#include <sstream>
#include <p_cage_bi.h>

const int ATO_NX1 = 0;
const int ATO_NY1 = 1;
const int ATO_NZ1 = 2;
const int ATO_NX2 = 3;
const int ATO_NY2 = 4;
const int ATO_NZ2 = 5;
const int ATO_N1T = 6;
const int ATO_N2T = 7;
const int ATO_N3T = 8;
const int ATO_N4T = 9;
const int ATO_N5T = 10;
const int ATO_N6T = 11;
const int ATO_NA  = 12;


class p_cage_bi_Ato : public p_cage_bi
{
public:
  vec3 Wx1_,Wx2_,Wy1_;
  vec3 wx11_,wx12_,wx21_,wx22_,wy11_,wy12_;

public:
  p_cage_bi_Ato(int P1, int P2, int q1, int q2, int q3, int Q1, int Q2, int Q3,
		double cl, double ca, double cc, double cpc,
		double *v0, double *dv,
	        int n_sweep, int n_monitor, double dvcoef=0.1);
  
  virtual ~p_cage_bi_Ato();
  virtual  std::string name() { return("Ato"); }
  double *init_pcage(int q1, int q2, int q3, int Q1, int Q2, int Q3,
		     int P1, int P2, int &size,
		     double S1, double S2, double ts);

  virtual void reset_geometry();
  void use_cage_weights();
  
  //virtual std::string filename_prefix();

  // not used
  virtual double Ei(int i, double *v) { return(0); };
  
  virtual void set_x_y(double *v); 
  
  //virtual double E(double *v);

  /* Impose constraints */
  virtual void check(double *v, int i);

  //void deformations(double *v);
 
  //void show_details();
  
  virtual void write(const char *ofname);
};


#endif
