#ifndef P_CAGES_BI_ATID_H
#define P_CAGES_BI_ATID_H

#include <string>
#include <sstream>
#include <p_cage_bi.h>

const int ATID_NX1 = 0;
const int ATID_NY1 = 1;
const int ATID_NZ1 = 2;
const int ATID_NX2 = 3;
const int ATID_NY2 = 4;
const int ATID_NZ2 = 5;
const int ATID_N1T = 6;
const int ATID_N2T = 7;
const int ATID_N3T = 8;
const int ATID_N4T = 9;
const int ATID_N5T = 10;
const int ATID_N6T = 11;
const int ATID_NA  = 12;


class p_cage_bi_Atid : public p_cage_bi
{
public:
  mat33 Rg_, Rx2po5_, Rxm2po5_;
  
public:
  p_cage_bi_Atid(int P1, int P2, int q1, int q2, int q3, int Q1, int Q2, int Q3,
		 double cl, double ca, double cc, double cpc,
		 double *v0, double *dv,
	         int n_sweep, int n_monitor, double dvcoef=0.1);
  
  virtual ~p_cage_bi_Atid();
  virtual  std::string name() { return("Atid"); }
  double *init_pcage(int q1, int q2, int q3, int Q1, int Q2, int Q3,
		     int P1, int P2, int &size,
		     double S1, double S2, double ts);

  virtual void reset_geometry();
  void use_cage_weights();
  
  //virtual std::string filename_prefix();

  // not used
  virtual double Ei(int i, double *v) { return(0); };
  
  virtual void set_x_y(double *v); 
  
  //virtual double E(double *v);

  /* Impose constraints */
  virtual void check(double *v, int i);

  //void deformations(double *v);
 
  //void show_details();
  
  virtual void write(const char *ofname);
};


#endif
