#ifndef P_CAGES_BI_ATCO_H
#define P_CAGES_BI_ATCO_H

#include <string>
#include <sstream>
#include <p_cage_bi.h>

const int ATCO_NX1 = 0;
const int ATCO_NY1 = 1;
const int ATCO_NZ1 = 2;
const int ATCO_NX2 = 3;
const int ATCO_NY2 = 4;
const int ATCO_NZ2 = 5;
const int ATCO_N1T = 6;
const int ATCO_N2T = 7;
const int ATCO_N3T = 8;
const int ATCO_N4T = 9;
const int ATCO_N5T = 10;
const int ATCO_N6T = 11;
const int ATCO_NA  = 12;


class p_cage_bi_Atco : public p_cage_bi
{
public:
  vec3 Wx1_,Wx2_,Wy4_;
  vec3 wx11_,wx12_,wx21_,wx22_,wz41_,wz42_;
  mat33 Rx3pio4_, R7_;
  
public:
  p_cage_bi_Atco(int P1, int P2, int q1, int q2, int q3, int Q1, int Q2, int Q3,
		 double cl, double ca, double cc, double cpc,
		 double *v0, double *dv,
	         int n_sweep, int n_monitor, double dvcoef=0.1);
  
  virtual ~p_cage_bi_Atco();
  virtual  std::string name() { return("Atco"); }
  double *init_pcage(int q1, int q2, int q3, int Q1, int Q2, int Q3,
		     int P1, int P2, int &size,
		     double S1, double S2, double ts);

  virtual void reset_geometry();
  void use_cage_weights();
  
  //virtual std::string filename_prefix();

  // not used
  virtual double Ei(int i, double *v) { return(0); };
  
  virtual void set_x_y(double *v); 
  
  //virtual double E(double *v);

  /* Impose constraints */
  virtual void check(double *v, int i);

  //void deformations(double *v);
 
  //void show_details();
  
  virtual void write(const char *ofname);
};


#endif
