#include <m_except.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <cstdlib>
#include "p_cages_bi_Atco.h"

using namespace std;


p_cage_bi_Atco::p_cage_bi_Atco(int P1, int P2, int q1, int q2, int q3,
			       int Q1, int Q2, int Q3, double cl,
			       double ca, double cc, double cpc,
			       double *v0, double *dv,
			       int n_sweep, int n_monitor, double dvcoef) : 
  p_cage_bi(ATCO_NA+(q1+q2+q3-3+Q1+Q2+Q3-3)*2, P1, P2, q1,q2,q3,0,0,Q1,Q2,Q3,0,0,
	    cl,ca,cc,cpc,v0,0,n_sweep,n_monitor,dvcoef)
{ //cout<<"p_cage_bi_Atco\n"<<flush;
  v1_.set(ex_);
  Rx3pio4_ = rot_v(ex_, 0.75*M_PI);
  R7_ = Rympiot_*Rxmpiot_ ;

  i_n1_ = 1;         // index of n1
  i_n2_ = 2;         // index of n2
  i_n3_ = i_n2_+q1_; // index of n3
  i_n4_ = i_n3_+1;   // index of n4
  i_n5_ = i_n4_+q2_; // index of n5
  i_n6_ = i_n5_+1;   // index of n6
  i_a1_ = i_n2_+1;   // index of a1
  i_b1_ = i_n4_+1;   // index of b1
  i_c1_ = i_n6_+1;   // index of c1

  j_n1_ = 1;         // index of n1
  j_n2_ = 2;         // index of n2
  j_n3_ = j_n2_+Q1_; // index of n3
  j_n4_ = j_n3_+1;   // index of n4
  j_n5_ = j_n4_+Q2_; // index of n5
  j_n6_ = j_n5_+1;   // index of n6
  j_A1_ = j_n2_+1;   // index of A1
  j_B1_ = j_n4_+1;   // index of B1
  j_C1_ = j_n6_+1;   // index of C1
  
  reset_geometry();
};

p_cage_bi_Atco::~p_cage_bi_Atco()
{
};

/***************************************/
/* Recomputes the geomtry for the face */
/***************************************/
void p_cage_bi_Atco::reset_geometry()
{ // normal to the face
  //cout<<"reset_geometry()\n"<<flush;
  mat33 PoV, PoW;
  
  // 
  V_.set(x1_, y1_, z1_);
  Wx1_.set(x2_, y2_, z2_);
  Wx2_ = Rxmpiot_*Wx1_;
  Wy4_ = Rzpiot_*Rxpiot_*Wx1_;
  //cout<<"Rxpi="<<Rxpi_.str()<<"\n";
  //cout<<"Rypi="<<Rypi_.str()<<"\n";
  //cout<<"Rzpi="<<Rzpi_.str()<<"\n";
  //cout<<"W="<<Wx1_.str()<<" "<<W2_.str()<<" "<<W3_.str()<<"\n";

  PoV.proj_ortho(V_);
  PoW.proj_ortho(Wx1_);

  v1_ = PoV*ey_;
  v1_.normalise();
  v2_ = V_.cross(v1_);
  v2_.normalise();

  wx11_ = PoW*ey_;
  wx11_.normalise();
  wx12_ = wx11_.cross(Wx1_);
  wx12_.normalise();
  wx21_ = Rxmpiot_*wx11_;
  wx22_ = Rxmpiot_*wx12_;
  wz41_ = Rzpiot_*Rxpiot_*wx11_;
  wz42_ = Rzpiot_*Rxpiot_*wx12_;

  //cout<<"w11="<<wx11_.str()<<" "<<wx12_.str()<<"\n";
  //cout<<"w21="<<wx21_.str()<<" "<<wx22_.str()<<"\n";
  //cout<<"w31="<<wy11_.str()<<" "<<wy12_.str()<<"\n";
  
  nf1_ = V_;
  nf1_.normalise();
  nf2_ = Wx1_;
  nf2_.normalise();
  nf3_ = Rxmpiot_*nf2_;
  nf4_ = Rzpiot_*Rxpiot_*nf2_;

 
  plane_crossing(V_, v1_, v2_, Wx1_, wx11_, wx12_, vU1_, vu1_);
  //if (vu1_*v2_ > 0)
  //{ vu1_ *= -1;
  //}
  plane_crossing(V_, v1_, v2_, Wx2_, wx21_, wx22_, vU2_, vu2_);
  plane_crossing(V_, v1_, v2_, Wy4_, wz41_, wz42_, vU3_, vu3_);

  //cout<<"vU1="<<vU1_.str()<<" "<<vu1_.str()<<"\n";
  //cout<<"vU2="<<vU2_.str()<<" "<<vu2_.str()<<"\n";
  //cout<<"vU3="<<vU3_.str()<<" "<<vu3_.str()<<"\n";
  //cout<<"Dist to plane 1 U2 ="<<vU2_.dist_to_plane(V_,v1_,v2_)<<"\n";
  //cout<<"Dist to plane 2 U2 ="<<vU2_.dist_to_plane(W_,w1_,w2_)<<"\n";
  //cout<<"End reset_geometry()\n"<< flush;
}

void p_cage_bi_Atco::use_cage_weights()
{ weights1_[2] = 0.5; // n2
  weights1_[q1_+3] = 0.5; // n4
  weights1_[q1_+q2_+4] = 0.5; // n6
  weights2_[2] = 0.5; // n2
  weights2_[Q1_+3] = 0.5; // n4
  weights2_[Q1_+Q2_+4] = 0.5; // n6
}

/* Coordinates
   v[0] : A
   v[1] : cos(theta)
   v[2] : psi
   v[3] : n_1 t
   v[4] : n_2 t
   v[5] : n_5 t
   v[6+2i] , i in [0, q1-2] coordinate for a_i 
   v[6+2(q1-1)+2i] , i in [0, q2-2] coordinate for b_i 
   v[6+2(q1+q2-2)+2i] , i in [0, q3-2] coordinate for c_i 
*/ 
void p_cage_bi_Atco::set_x_y(double *v) 
{ 
  //cout<<"set q1="<<q1_<<" q2="<<q2_<<" q3="<<q3_<<" v="<<v<<"\n"<<std::flush;
  vec3 dv, ev;

  //cout<<"set_x_y\n"<<flush;
  
  x1_ = v[ATCO_NX1];
  y1_ = v[ATCO_NY1];
  z1_ = v[ATCO_NZ1];
  x2_ = v[ATCO_NX2];
  y2_ = v[ATCO_NY2];
  z2_ = v[ATCO_NZ2];

  if (new_geometry_)
  { reset_geometry();
  }
 
  // Face 1
  l1_[i_n1_] = vU1_+vu1_*v[ATCO_N1T];
  l1_[i_n2_] = vU1_+vu1_*v[ATCO_N2T];
  l1_[i_n3_] = vU2_+vu2_*v[ATCO_N3T]; 
  l1_[i_n4_] = vU2_+vu2_*v[ATCO_N4T]; 
  l1_[i_n5_] = vU3_+vu3_*v[ATCO_N5T]; 
  l1_[i_n6_] = vU3_+vu3_*v[ATCO_N6T];
  f_center_1_ = (l1_[i_n1_]+l1_[i_n2_]+l1_[i_n3_]+l1_[i_n4_]+l1_[i_n5_]+l1_[i_n6_])/6;

  // a_i
  for(int i=0; i< q1_-1; i++)
  { l1_[i_a1_+i] = V_+v1_*v[ATCO_NA+2*i]+v2_*v[ATCO_NA+2*i+1];
    //cout<<"a"<<i<<"="<<v[ATCO_NA+2*i]<<" "<<v[ATCO_NA+2*i+1]<<"\n";
  }
  // b_i
  for(int i=0; i< q2_-1; i++)
  { l1_[i_b1_+i] = V_+v1_*v[ATCO_NA+(q1_-1+i)*2]+v2_*v[ATCO_NA+(q1_-1+i)*2+1];
    //cout<<"b"<<i<<"="<<v[ATCO_NA+(q1_-1+i)*2]<<" "<<v[ATCO_NA+(q1_-1+i)*2+1]<<"\n";
  }
  // c_i
  for(int i=0; i< q3_-1; i++)
  { l1_[i_c1_+i] = V_+v1_*v[ATCO_NA+(q1_+q2_-2+i)*2]+v2_*v[ATCO_NA+(q1_+q2_-2+i)*2+1];
    //cout<<"c"<<i<<"="<<v[ATCO_NA+(q1_+q2_-2+i)*2]<<" "<<v[ATCO_NA+(q1_+q2_-2+i)*2+1]<<"\n";
  }
  // circular chain
  l1_[0] = l1_[P1_];
  l1_[P1_+1] = l1_[1];

  // Face 2
  //int nf1 = (q1_+q2_+q3_-3)*2;
  
  l2_[j_n1_] = l1_[q_index(1)];
  l2_[j_n2_] = l1_[q_index(2)];
  l2_[j_n3_] = Rxpiot_*l1_[q_index(3)]; 
  l2_[j_n4_] = Rxpiot_*l1_[q_index(4)];
  l2_[j_n5_] = R7_*l1_[q_index(5)]; 
  l2_[j_n6_] = R7_*l1_[q_index(6)];
  f_center_2_ = (l2_[j_n1_]+l2_[j_n2_]+l2_[j_n3_]+l2_[j_n4_]+l2_[j_n5_]+l2_[j_n6_])/6;
  f_center_3_ = Rxmpiot_*f_center_2_;
  f_center_4_ = Rzpiot_*Rxpiot_*f_center_2_;

  
  // A_j
  for(int j=0; j< Q1_-1; j++)
  { l2_[j_A1_+j] = Wx1_+wx11_*v[ATCO_NA+Nhv1_+2*j]+wx12_*v[ATCO_NA+Nhv1_+2*j+1];
    //cout<<"A"<<v[ATCO_NA+Nhv1_+2*j] <<" "<<v[ATCO_NA+Nhv1_+2*j+1] <<"\n";
  }
  // B_j
  for(int j=0; j< Q2_-1; j++)
  { l2_[j_B1_+j] = Wx1_+wx11_*v[ATCO_NA+Nhv1_+(Q1_-1+j)*2]
                       +wx12_*v[ATCO_NA+Nhv1_+(Q1_-1+j)*2+1];
    //cout<<"B"<<v[ATCO_NA+Nhv1_+(Q1_-1+j)*2]<<" "<<v[ATCO_NA+Nhv1_+(Q1_-1+j)*2+1]<<"\n";
  }
  // C_j
  for(int j=0; j< Q3_-1; j++)
  { l2_[j_C1_+j] = Wx1_+wx11_*v[ATCO_NA+Nhv1_+(Q1_+Q2_-2+j)*2]
                       +wx12_*v[ATCO_NA+Nhv1_+(Q1_+Q2_-2+j)*2+1];
  }
  // circular chain
  l2_[0] = l2_[P2_];
  l2_[P2_+1] = l2_[1];

  //new_geometry_ =  true;
}

/* Impose constraints */
void p_cage_bi_Atco::check(double *v, int i)
{ new_geometry_ = true;
  if ((relax_method_==METHOD_MC)||
                    (i==ATCO_NX1) || (i==ATCO_NY1) || (i==ATCO_NZ1)||
                    (i==ATCO_NX2) || (i==ATCO_NY2) || (i==ATCO_NZ2))
  { new_geometry_ = last_rejected_||
                    (i==ATCO_NX1) || (i==ATCO_NY1) || (i==ATCO_NZ1)||
                    (i==ATCO_NX2) || (i==ATCO_NY2) || (i==ATCO_NZ2);
  }
  // y1
  if (i==ATCO_NY1)
  { if (v[ATCO_NY1] < 0) { v[ATCO_NY1] = 0; }
  }
  // x2
  if (i==ATCO_NZ2)
  { if (v[ATCO_NZ2] < 0) { v[ATCO_NZ2] = 0; }
  }
  
}
  
/* FORMAT       */
/* Atco        */
/* P1 P2 q1 q2 q3 Q1 Q2 Q3 */
/* x1 y1 z2 x2 y2 z2 */
/* cl ca cc     */
/* err_l_max err_a_max err_l_av_max err_l_av err_a_av  */
/* err_l_max_1 err_a_max_1 err_l_av_max_1 err_l_av_1 err_a_av_1 */
/* err_l_max_2 err_a_max_2 err_l_av_max_2 err_l_av_2 err_a_av_2 */
/* E_ Efc_ Epc_ */
/* V  */
/* v1 v2  */
/* W1 */
/* w11 w12  */
/* w11 w12 */
/* x11 y11 z11 */
/* x12 y12 z12 */
/* ...     */
/* x1P1 y1P1 z1P1 */
/* x21 y21 z21 */
/* x22 y22 z22 */
/* ...     */
/* x1P2 y1P2 z1P2 */
void p_cage_bi_Atco::write(const char *ofname)
{ ofstream ofs;
  ofs.open(ofname, ios::out);

  deformations(X_, true);

   //cout<<"cos_theta_="<<cos_theta_<<"\n";
  ofs <<"Atco\n";
  ofs <<P1_<<" "<<P2_<<" "<<q1_<<" "<<q2_<<" "<<q3_<<" "<<Q1_<<" "<<Q2_<<" "<<Q3_<<"\n";
  ofs <<x1_<<" "<<y1_<<" "<<z1_<<" "<<x2_<<" "<<y2_<<" "<<z2_<<"\n";
  ofs <<cl_<<" "<<ca_<<" "<<cc_<<"\n";
  ofs <<err_l_max_<<" "<< err_a_max_<<" "<< err_l_av_max_<<" "
      <<err_l_av_<<" "<< err_a_av_<<"\n";
  ofs <<err_l_max_1_<<" "<< err_a_max_1_ <<" "<< err_l_av_max_1_<<" "
      <<err_l_av_1_<<" "<< err_a_av_1_<<"\n";
  ofs <<err_l_max_2_<<" "<< err_a_max_2_ <<" "<< err_l_av_max_2_<<" "
      <<err_l_av_2_<<" "<< err_a_av_2_<<"\n";
  ofs <<E_<<" "<<Efc_<<" "<<Epc_<<"\n";
  
  ofs <<V_.str2()<<"\n";
  ofs <<v1_.str2()<<" "<<v2_.str2()<<"\n";

  ofs <<Wx1_.str2()<<"\n";
  ofs <<wx11_.str2()<<" "<<wx12_.str2()<<"\n";

  for (int i=1; i <= P1_; i++)
  { ofs << l1_[i].str2()<<"\n"; 
  }
  for (int i=1; i <= P2_; i++)
  { ofs << l2_[i].str2()<<"\n"; 
  }
}


/* Function to initialise the prims p-cage               */
/* Return allocated vector with initial parameter values */
/* Return size of vector in size                         */
double *p_cage_bi_Atco::init_pcage(int q1, int q2, int q3, int Q1, int Q2,
				  int Q3, int P1, int P2, int &size,
				  double S1, double S2, double ts) 
{ size = ATCO_NA+(q1+q2+q3-3+Q1+Q2+Q3-3)*2;
  double *V0 = new double [size];
  mat33 Rz4;
  mat33 Rx2;
  //cout<<"init_pcage size="<<size<<"\n"<<flush;
  
  // Initialise the vector
  V0[ATCO_NX1] = 1.2*S1*2;
  V0[ATCO_NY1] = 1.2*S1*1.4241;
  V0[ATCO_NZ1] = 1.2*S1*0.5857864;
  V0[ATCO_NX2] = 1.2*S2*2;
  V0[ATCO_NY2] = 1.2*S2*0.5857864;
  V0[ATCO_NZ2] = 1.2*S2*1.4241;
  V0[ATCO_N1T] = -0.1*ts*0.8;
  V0[ATCO_N2T] = 1*ts*0.8;
  V0[ATCO_N3T] = -1*ts*0.8;
  V0[ATCO_N4T] = 0.1*ts*0.8;
  V0[ATCO_N5T] = -0.5*ts*0.8;
  V0[ATCO_N6T] = 0.5*ts*0.8;
  set_x_y(V0);
  reset_geometry();
  
  vec3 n1 = vU1_+vu1_*V0[ATCO_N1T];
  vec3 n2 = vU1_+vu1_*V0[ATCO_N2T];
  vec3 n3 = vU2_+vu2_*V0[ATCO_N3T];
  vec3 n4 = vU2_+vu2_*V0[ATCO_N4T];
  vec3 n5 = vU3_+vu3_*V0[ATCO_N5T];
  vec3 n6 = vU3_+vu3_*V0[ATCO_N6T];

  vec3 f_center = (n1+n2+n3+n4+n5+n6)/6;
  vec3 ev;
  // a_i
  vec3 dv = n3-n2;
  for(int i=0; i< q1_-1; i++)
  { ev = f_center +(n2+dv*(i+1)/q1_ -f_center)*1.1;
    ev = ev + V_-f_center; // V_ must be the origin of the face coordinates
    V0[ATCO_NA+2*i] = ev*v1_;
    V0[ATCO_NA+2*i+1] = ev*v2_;
  }
  // b_i
  dv = n5-n4;
  for(int i=0; i< q2_-1; i++)
  { ev = f_center +(n4+dv*(i+1)/q2_ -f_center)*1.1;
    ev = ev + V_-f_center;
    V0[ATCO_NA+(q1_-1+i)*2]   = ev*v1_;
    V0[ATCO_NA+(q1_-1+i)*2+1] = ev*v2_;
  }
  // c_i
  dv = n1-n6;
  for(int i=0; i< q3_-1; i++)
  { ev = f_center +(n6+dv*(i+1)/q3_ -f_center)*1.1;
    ev = ev + V_-f_center;
    V0[ATCO_NA+(q1_+q2_-2+i)*2]   = ev*v1_;
    V0[ATCO_NA+(q1_+q2_-2+i)*2+1] = ev*v2_;
  }
  //cout<<" index1="<<ATCO_NA+(q1_+q2_-2)*2<<"\n";
  //cout<<"OK1\n"<<flush;

  Rz4 = Rympiot_*Rxmpiot_;
  //int nf1 = (q1_+q2_+q3_-3)*2;
  vec3 m1 = n1;
  vec3 m2 = n2;
  vec3 m3 = Rxpiot_*n3;
  vec3 m4 = Rxpiot_*n4;
  vec3 m5 = R7_*n5;
  vec3 m6 = R7_*n6;

  f_center = (m1+m2+m3+m4+m5+m6)/6;
  // A_j
  dv = m3-m2;
  for(int j=0; j< Q1_-1; j++)
  { ev = f_center + (m2+dv*(j+1)/Q1_ -f_center)*1.1;
    ev = ev + Wx1_-f_center; // W1_ must be the origin of the face coordinates
    V0[ATCO_NA+Nhv1_+2*j] = ev*wx11_;
    V0[ATCO_NA+Nhv1_+2*j+1] = ev*wx12_;
    cout<<"A"<<V0[ATCO_NA+Nhv1_+2*j]<<" "<< V0[ATCO_NA+Nhv1_+2*j+1]<<"\n";
  }
  // B_j
  dv = m5-m4;
  for(int j=0; j< Q2_-1; j++)
  { ev = f_center +(m4+dv*(j+1)/Q2_ -f_center)*1.1;
    ev = ev+ Wx1_-f_center;
    V0[ATCO_NA+Nhv1_+(Q1_-1+j)*2]   = ev*wx11_;
    V0[ATCO_NA+Nhv1_+(Q1_-1+j)*2+1] = ev*wx12_;
    //cout<<"init B"<<ev*wx11_<<" "<< ev*wx12_<<"\n";
  }
  // C_j
  dv = m1-m6;
  for(int j=0; j< Q3_-1; j++)
  { ev = f_center +(m6+dv*(j+1)/Q3_ -f_center)*1.1;
    ev = ev + Wx1_-f_center;
    V0[ATCO_NA+Nhv1_+(Q1_+Q2_-2+j)*2]   = ev*wx11_;
    V0[ATCO_NA+Nhv1_+(Q1_+Q2_-2+j)*2+1] = ev*wx12_;
    cout<<"C\n";
  }

  //cout<<" index2="<<ATCO_NA+Nhv1_+(Q1_+Q2_-2)*2<<" Nhv1_="<<Nhv1_<<"\n";
  //cout<<"OK2\n"<<flush;

  return(V0);
}
