#ifndef P_CAGE_H
#define P_CAGE_H

#include <string>
#include <sstream>
#include <m_MC_quasi_newton.h>
#include <m_mat33.h>

const int TYPE_SP = 0;
const int TYPE_Ato = 1;
const int TYPE_Atco = 2;
const int TYPE_Atid = 3;
const int TYPE_DArd = 4;
const int TYPE_DArt = 5;


const double L0 = 1.0;
const double PHI_G = 1.618033988749895; // Gold number (1+sqrt(5)/2

inline double Sq(double x) { return(x*x); }

inline double max_d(double a, double b) { return a>b? a : b; }

class p_cage_bi : public m_mc_qn
{ public:
  bool new_geometry_;
  int relax_method_;
  int P1_;
  int P2_;
  int q1_;
  int q2_;
  int q3_;
  int q4_;
  int q5_;
  int Q1_;
  int Q2_;
  int Q3_;
  int Q4_;
  int Q5_;
  int nqs_;
  int nQs_;
  double cl_;
  double ca_;
  double cc_;
  double cpc_;
  vec3 *l1_; // coordinates of reference face type 1
  vec3 *l2_; // coordinates of reference face type 2
  double *weights1_;
  double *weights2_;
  int relax_type_;

  // Energies
  double Efc_; // face convexity energy
  double Epc_; // p-cage convexity energy
  
  // Max error
  double err_l_max_;
  double err_l_av_max_; // use l_av instead of L0
  double err_a_max_;
  double err_l_av_;
  double err_a_av_;

  // Error face 1
  double err_l_max_1_;
  double err_l_av_max_1_; // use l_av instead of L0
  double err_a_max_1_;
  double err_l_av_1_;
  double err_a_av_1_;
  double alpha_target_1_;

  // Error face 2
  double err_l_max_2_;
  double err_l_av_max_2_; // use l_av instead of L0
  double err_a_max_2_;
  double err_l_av_2_;
  double err_a_av_2_;
  double alpha_target_2_;

  double x1_;
  double y1_;
  double z1_;
  double x2_;
  double y2_;
  double z2_;
  double S1_;
  double S2_;

  
  vec3 ex_;  // (1,0,0)
  vec3 ey_;  // (0,1,0)
  vec3 ez_;  // (0,0,1)
  vec3 e1_;  // edge1
  vec3 e2_;  // edge2
  vec3 e3_;  // edge3
  vec3 e4_;  // edge4
  vec3 g1_;  // rotation axis 
  vec3 g2_;  // roration axis
 
  vec3 nf1_;  // normal to 1st reference face
  vec3 nf2_;  // normal to 2nd reference face
  vec3 nf3_;  // normal to 2nd type 2 face
  vec3 nf4_;  // normal to 3rd type 2 face
  vec3 f_center_1_; // Center of 1st reference face 
  vec3 f_center_2_; // Center of 2nd reference face
  vec3 f_center_3_; // Center of to 2nd type 2 face
  vec3 f_center_4_; // Center of to 3rd type 2 face
  
  vec3 V0_;   // root vector
  vec3 V_;   // centre of the face plane
  vec3 v1_;  // 1st basis vector in face
  vec3 v2_;  // 2nd basis vector in face
  vec3 W1_;   // centre of adjacent face plane
  vec3 w11_;  // 1st basis vector in other face
  vec3 w12_;  // 2nd basis vector in other face
  vec3 W2_;   // centre of adjacent face plane
  vec3 w21_;  // 1st basis vector in other face
  vec3 w22_;  // 2nd basis vector in other face
  vec3 W3_;   // centre of adjacent face plane
  vec3 w31_;  // 1st basis vector in other face
  vec3 w32_;  // 2nd basis vector in other face
  vec3 vp_;
  vec3 vq_;
  vec3 vU1_; // Origin of 1st plane intersection
  vec3 vu1_; // Direction of 1st plane intersection
  vec3 vU2_; // Origin of 2nd plane intersection
  vec3 vu2_; // Direction of 2nd plane intersection
  vec3 vU3_; // Origin of 3rd plane intersection
  vec3 vu3_; // Direction of 3rd plane intersection
  vec3 vU4_; // Origin of 4th plane intersection
  vec3 vu4_; // Direction of 4th plane intersection
  vec3 vU5_; // Origin of 5th plane intersection
  vec3 vu5_; // Direction of 5th plane intersection
  mat33 Ref_x_; // Reflection along x axis
  mat33 Ref_xy_; // Reflection along xy axis
  mat33 Rz_pi_; // Pi rotations around z axis

  mat33 Rxpi_; // Rotation pi around x
  mat33 Rypi_; // Rotation pi around y
  mat33 Rzpi_; // Rotation pi around z
  mat33 Rxpiot_; // Rotation pi/2 around x
  mat33 Rypiot_; // Rotation pi/2 around y
  mat33 Rzpiot_; // Rotation pi/2 around z
  mat33 Rxmpiot_; // Rotation -pi/2 around x
  mat33 Rympiot_; // Rotation -pi/2 around y
  mat33 Rzmpiot_; // Rotation -pi/2 around z

  mat33 R1_; // Rotation matrix
  mat33 R1_inv_;
  mat33 R2_;
  mat33 R2_inv_;
  mat33 R3_;
  mat33 R3_inv_;
  mat33 R4_;
  mat33 R5_;
  mat33 R6_;
 
  int i_n1_;  // index of n1
  int i_n2_;  // index of n2
  int i_n3_;  // index of n3
  int i_n4_;  // index of n4
  int i_n5_;  // index of n5
  int i_n6_;  // index of n6
  int i_a1_;  // index of a1
  int i_b1_;  // index of b1
  int i_c1_;  // index of c1

  int j_n1_;  // index of n1
  int j_n2_;  // index of n2
  int j_n3_;  // index of n3
  int j_n4_;  // index of n4
  int j_n5_;  // index of n5
  int j_n6_;  // index of n6
  int j_n7_;  // index of n5
  int j_n8_;  // index of n6
  int j_n9_;  // index of n5
  int j_n10_;  // index of n6
  int j_A1_;  // index of A1
  int j_B1_;  // index of B1
  int j_C1_;  // index of C1 
  int j_D1_;  // index of D1
  int j_E1_;  // index of E1

  int Nhv1_; // Number of hole vertices for face 1
  
 p_cage_bi(int size, int P1, int P2, int q1, int q2, int q3, int q4, int q5,
	    int Q1, int Q2, int Q3, int Q4, int Q5,
	    double cl, double ca, double cc, double cpc,
	    double *v0, double *dv, int n_sweep, int n_monitor,
	    double dvcoef=0.1);
  
  virtual ~p_cage_bi();

  void set_relax_type(int type) { relax_type_ = type; };
  void new_geometry(bool val = true) { new_geometry_ = val; }
  void pre_relax(int method) { relax_method_ = method; }
  virtual void reset_geometry() {};
  
  virtual void use_cage_weights() {};

  virtual  std::string name() { return std::string(""); }
  virtual  std::string filename_prefix();
  std::string number_to_letter(int N);

  virtual double Ei(int i, double *v) { return(0); };

  virtual int q_index(int n);
  
  virtual void set_x_y(double *v) { std::cout<<"wrong set_x_y("<<v<<")\n";}; 
  
  virtual double Epc();
  virtual double E(double *v);
  virtual double extra_E(double *v) { return(0);};

  /* Impose constraints */
  virtual void check(double *v, int i){};

  virtual void deformations(double *v, bool eval_err_l_av=false);
 
  virtual void show_details();

  virtual void write(const char *ofname){};

  double angle(vec3 &n, double xc=0, double yc=0)
  { return(atan2(n*v2_-yc,n*v1_-xc)); }

};

#endif
