#include <m_except.h>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <cstdlib>
#include "p_cage_bi.h"
#include "m_mat33.h"

using namespace std;

p_cage_bi::p_cage_bi(int size, int P1, int P2, int q1, int q2, int q3, int q4, int q5,
	             int Q1, int Q2, int Q3, int Q4, int Q5,
		     double cl, double ca, double cc, double cpc,
		     double *v0, double *dv,
	       int n_sweep, int n_monitor, double dvcoef) : 
  m_mc_qn(size, v0, 0, n_sweep, n_monitor, dvcoef), new_geometry_(true),
  P1_(P1), P2_(P2), q1_(q1), q2_(q2), q3_(q3), q4_(q4), q5_(q5),
  Q1_(Q1), Q2_(Q2), Q3_(Q3), Q4_(Q4), Q5_(Q5),
  nqs_(q1+q2+q3+q4+q5), nQs_(Q1+Q2+Q3+Q4+Q5),
  cl_(cl), ca_(ca), cc_(cc), cpc_(cpc), relax_type_(USE_GR)
{ cout<<"p_cage_bi size="<<size<<"\n"<<flush;
  ex_.set(1,0,0);
  ey_.set(0,1,0);
  ez_.set(0,0,1);

  Rxpi_ = rot_v(ex_, M_PI); // Rotation pi around x
  Rypi_ = rot_v(ey_, M_PI); // Rotation pi around y
  Rzpi_ = rot_v(ez_, M_PI); // Rotation pi around x
  Rxpiot_ = rot_v(ex_, M_PI_2); // Rotation pi/2 around x
  Rypiot_ = rot_v(ey_, M_PI_2); // Rotation pi/2 around y
  Rzpiot_ = rot_v(ez_, M_PI_2); // Rotation pi/2 around z
  Rxmpiot_ = rot_v(ex_, -M_PI_2); // Rotation pi/2 around x
  Rympiot_ = rot_v(ey_, -M_PI_2); // Rotation pi/2 around x
  Rzmpiot_ = rot_v(ez_, -M_PI_2); // Rotation pi/2 around x
  //Ref_x_.set(-1,0,0, 0,1,0, 0,0,1);
  //Ref_xy_.set(0,1,0, 1,0,0, 0,0,1);
  //Rz_pi_.set(-1,0,0, 0,-1,0, 0,0,1);

  Nhv1_ = (q1_+q2_+q3_-3)*2;
  
  int MP = max(P1_,P2_);
  l1_ = new vec3[MP+2];
  l2_ = new vec3[MP+2];
  weights1_ = new double[MP+2];
  weights2_ = new double[MP+2];
  alpha_target_1_ = M_PI*(1-2.0/P1_);
  alpha_target_2_ = M_PI*(1-2.0/P2_);
  cout<<"alpha_target_1_ ="<<alpha_target_1_*180/M_PI<<"\n";
  cout<<"alpha_target_2_ ="<<alpha_target_2_*180/M_PI<<"\n";

  for(int i=0; i < MP+2; i++)
  { weights1_[i] = 1.0;
  }
  for(int i=0; i < MP+2; i++)
  { weights2_[i] = 1.0;
  }
};

p_cage_bi::~p_cage_bi()
{ delete[] l1_;
  delete[] l2_;
  delete weights1_;
  delete weights2_;
};

std::string p_cage_bi::filename_prefix()
{ std::stringstream ss;

  ss << name() <<"_P"<<P1_<<"_P"<<P2_<<"_"<<q1_<<"_"<<q2_<<"_"<<q3_;
  if (q4_>0)
  { ss<<"_"<<q4_;
  }
  if (q5_>0)
  { ss<<"_"<<q5_;
  }
  ss<<"-"<<Q1_<<"_"<<Q2_<<"_"<<Q3_;
  if (Q4_>0)
  { ss<<"_"<<Q4_;
  }
  if (Q5_>0)
  { ss<<"_"<<Q5_;
  }
  return(ss.str());
}

int p_cage_bi::q_index(int n)
{ if (n < 3) { return n; }
  if (n < 5) { return n+q1_-1; }
  if (n < 7) { return n+q1_+q2_-2; }
  if (n < 9) { return n+q1_+q2_+q3_-3; }
  return n+q1_+q2_+q3_+q4_-4; 
}

// P-cage convexity energy
double p_cage_bi::Epc()
{ double Epc = 0, diff;
  vec3 fcd  = f_center_1_-f_center_2_;

  diff = fcd.norms() - (fcd + nf1_-nf2_).norms();
  Epc += diff > 0 ? diff : 0;
  
  fcd  = f_center_1_-f_center_3_;
  diff = fcd.norms() - (fcd + nf1_-nf3_).norms();
  Epc += diff > 0 ? diff : 0;
  
  fcd  = f_center_1_-f_center_4_;
  diff = fcd.norms() - (fcd + nf1_-nf4_).norms();
  Epc += diff > 0 ? diff : 0;

  return(Epc);
}
  
double p_cage_bi::E(double *v) 
{ double E=0, Efc, beta, rot=0;

  set_x_y(v);

  // Face 1
  vec3 dv_prev = l1_[1]-l1_[0];
  double L_prev = dv_prev.norm();
  double delta_a, delta_l,delta_loop;
  Efc_=0;
  
  for (int i=1; i <= P1_; i++)
  { vec3 dv = l1_[i+1]-l1_[i];
    double L = dv.norm();
    delta_l = (L-L0)*(L-L0)/(L0*L0);
    
    vec3 vxdv = dv_prev.cross(dv);
    double vxdv_nf = vxdv*nf1_;
    double pdv_dv = dv_prev*dv/(L*L_prev);
    if (pdv_dv > 1.0) pdv_dv = 1.0;
    if (pdv_dv < -1.0) pdv_dv = -1.0;
    rot += acos(pdv_dv);
 		    
    beta = vxdv*nf1_ > 0 ? M_PI-acos(pdv_dv): M_PI+acos(pdv_dv);
    //beta = vxdv*nf_ < 0 ? M_PI-acos(pdv_dv): M_PI+acos(pdv_dv);
    //cout<<"vxdv = "<<vxdv.str()<<"  nf_ = "<<nf_.str()<<"\n";
    //cout<<"pdv_dv = "<<pdv_dv<<" acos(pdv_dv) = "<<acos(pdv_dv)<<"\n";
    //cout<<"beta = "<<beta*180/M_PI<<"\n";
    delta_a = (alpha_target_1_-beta)/alpha_target_1_;
    delta_a = delta_a*delta_a;
    delta_loop = (2*beta-M_PI)/M_PI; // to avoid loop: no angle < 90degrees
    delta_loop = delta_loop < 0 ? delta_loop : 0;

    //cout <<"i="<<i<<" beta="<<beta*180/M_PI<<" vxdv_nf="<<vxdv_nf<<" delta_l="<<delta_l <<" delta_a="<<delta_a<<"\n";
    //cout<<"nf="<<nf_.str()<<" vxdv="<<vxdv.str()<<"\n";
    //cout<<"i="<<i<<" "<<lx_[i]<<" "<<ly_[i]<<" vx="<<vx<<" vy="<<vy<<" vxv="<<vxv<<" vdv="<<vdv<<"\n";

    //cout<<"i="<<i<<" dl="<<delta_l<<" da="<<delta_a<<"  vxdv_nf="<<(vxdv_nf<0? -vxdv_nf : 0)<<"\n";
    Efc = (vxdv_nf<0? -vxdv_nf : 0);
    Efc_ += Efc;
    //E += cl_*weights1_[i]*delta_l+ca_*delta_a+ cc_*T_*Efc;
    E += cl_*weights1_[i]*delta_l+ca_*delta_a+ cc_*(T_*Efc+delta_loop*delta_loop);
    dv_prev = dv;
    L_prev = L;
  }
  if (rot > 2*M_PI)
  { //cout<<"rot="<<tot_rot<<"\n";
    E += cc_*(rot-2*M_PI);
  }

  
  // p-cage convexity
  Epc_ = Epc();
  E += cpc_*Epc_;
  
  rot = 0;
  
  // Face 2 
  dv_prev = l2_[1]-l2_[0];
  L_prev = dv_prev.norm(); 
  
  for (int i=1; i <= P2_; i++)
  { vec3 dv = l2_[i+1]-l2_[i];
    double L = dv.norm(); 
    delta_l = (L-L0)*(L-L0)/(L0*L0);
    
    vec3 vxdv = -1*dv_prev.cross(dv); // rotations are clockwise
    double vxdv_nf = vxdv*nf2_;
    double pdv_dv = dv_prev*dv/(L*L_prev);
    if (pdv_dv > 1.0) pdv_dv = 1.0;
    if (pdv_dv < -1.0) pdv_dv = -1.0;
    rot += acos(pdv_dv);
 		    
    beta = vxdv*nf2_ > 0 ? M_PI-acos(pdv_dv): M_PI+acos(pdv_dv);
    //beta = vxdv*nf_ < 0 ? M_PI-acos(pdv_dv): M_PI+acos(pdv_dv);
    //cout<<"vxdv = "<<vxdv.str()<<"  nf_ = "<<nf_.str()<<"\n";
    //cout<<"pdv_dv = "<<pdv_dv<<" acos(pdv_dv) = "<<acos(pdv_dv)<<"\n";
    //cout<<"beta = "<<beta*180/M_PI<<"\n";
    delta_a = (alpha_target_2_-beta)/alpha_target_2_;
    delta_a = delta_a*delta_a;
    //cout <<"i="<<i<<" beta="<<beta*180/M_PI<<" vxdv_nf="<<vxdv_nf<<" delta_l="<<delta_l <<" delta_a="<<delta_a<<"\n";
    //cout<<"nf="<<nf_.str()<<" vxdv="<<vxdv.str()<<"\n";
    //cout<<"i="<<i<<" "<<lx_[i]<<" "<<ly_[i]<<" vx="<<vx<<" vy="<<vy<<" vxv="<<vxv<<" vdv="<<vdv<<"\n";
    
    E += cl_*weights2_[i]*delta_l+ca_*delta_a+ cc_*T_*(vxdv_nf<0? -vxdv_nf : 0);
    dv_prev = dv;
    L_prev = L;
  }
  
  E += cc_*extra_E(v);
  
  if (rot > 2*M_PI)
  { E += cc_*(rot-2*M_PI);
  }
  return(E/(P1_+P2_)); 
};

void p_cage_bi::deformations(double *v, bool eval_err_l_av)
{ double beta;
  double av_length1 = 0, av_length2 = 0;

  //cout<<"deformation("<<v<<")\n";
  if(v)
  { new_geometry();
    set_x_y(v);
  }
  
  err_l_max_1_ = -1;
  err_a_max_1_ = -1;
  err_l_av_1_ = 0;
  err_a_av_1_ = 0;

  vec3 dv_prev = l1_[1]-l1_[0];
  double L_prev = dv_prev.norm();
  double delta_a, delta_l;

  for (int i=1; i <= P1_; i++)
  { vec3 dv = l1_[i+1]-l1_[i];
    double L = dv.norm();
    av_length1  += L;
    delta_l = fabs((L-L0)/L0);

    vec3 vxdv = dv_prev.cross(dv);
    //double vxdv_nf = vxdv*nf_;
    double pdv_dv = dv_prev*dv/(L*L_prev);
    if (pdv_dv > 1.0) pdv_dv = 1.0;
    if (pdv_dv < -1.0) pdv_dv = -1.0;

    beta = vxdv*nf1_ > 0 ? M_PI-acos(pdv_dv): M_PI+acos(pdv_dv);
    //cout <<"i="<<i<<" beta="<<beta*180/M_PI<<"\n";
    //cout <<"vxdv*nf_="<<vxdv*nf1_<<" "<<(M_PI-acos(pdv_dv))*180/M_PI<<" "<<(M_PI+acos(pdv_dv))*180/M_PI<<"\n";
    delta_a = fabs((alpha_target_1_-beta)/alpha_target_1_);

    if ((err_l_max_1_ < 0) || (delta_l > err_l_max_1_))
    { err_l_max_1_ = delta_l;
    }
    err_l_av_1_ += delta_l;
    
    if ((err_a_max_1_ < 0) || (delta_a > err_a_max_1_))
    { err_a_max_1_ = delta_a;
    }
    err_a_av_1_ += delta_a;
    
    dv_prev = dv;
    L_prev = L;

  }


  if (eval_err_l_av)
  { av_length1 /= P1_;
    // relative length deformation
    err_l_av_max_1_ = -1;
    dv_prev = l1_[1]-l1_[0];
    for (int i=1; i <= P1_; i++)
    { vec3 dv = l1_[i+1]-l1_[i];
      double L = dv.norm();
      //av_length  += L;
      double delta_l = fabs((L-av_length1)/av_length1);
      if ((err_l_av_max_1_ < 0) || (delta_l > err_l_av_max_1_))
      { err_l_av_max_1_ = delta_l;
      }
    }
  }
  err_l_av_1_ = err_l_av_1_/P1_;
  err_a_av_1_ = err_a_av_1_/P1_;

  err_l_max_2_ = -1;
  err_a_max_2_ = -1;
  err_l_av_2_ = 0;
  err_a_av_2_ = 0;
  dv_prev = l2_[1]-l2_[0];
  L_prev = dv_prev.norm();

  for (int i=1; i <= P2_; i++)
  { vec3 dv = l2_[i+1]-l2_[i];
    double L = dv.norm();
    av_length2  += L;
    delta_l = fabs((L-L0)/L0);

    vec3 vxdv = dv_prev.cross(dv);
    //double vxdv_nf = vxdv*nf_;
    double pdv_dv = dv_prev*dv/(L*L_prev);
    if (pdv_dv > 1.0) pdv_dv = 1.0;
    if (pdv_dv < -1.0) pdv_dv = -1.0;

    beta = vxdv*nf2_ < 0 ? M_PI-acos(pdv_dv): M_PI+acos(pdv_dv);
    //cout <<"i="<<i<<" beta="<<beta*180/M_PI<<"\n";
    //cout <<"vxdv*nf_="<<vxdv*nf2_<<" "<<(M_PI-acos(pdv_dv))*180/M_PI<<" "<<(M_PI+acos(pdv_dv))*180/M_PI<<"\n";
    delta_a = fabs((alpha_target_2_-beta)/alpha_target_2_);

    if ((err_l_max_2_ < 0) || (delta_l > err_l_max_2_))
    { err_l_max_2_ = delta_l;
    }
    err_l_av_2_ += delta_l;
    
    if ((err_a_max_2_ < 0) || (delta_a > err_a_max_2_))
    { err_a_max_2_ = delta_a;
    }
    err_a_av_2_ += delta_a;
    
    dv_prev = dv;
    L_prev = L;

  }
  err_l_av_2_ = err_l_av_2_/P2_;
  err_a_av_2_ = err_a_av_2_/P2_;

  if (eval_err_l_av)
  { av_length2 /= P2_;
    // relative length deformation
    err_l_av_max_2_ = -1;
    dv_prev = l2_[1]-l2_[0];
    for (int i=1; i <= P2_; i++)
    { vec3 dv = l2_[i+1]-l2_[i];
      double L = dv.norm();
      //av_length  += L;
      double delta_l = fabs((L-av_length2)/av_length2);
      if ((err_l_av_max_2_ < 0) || (delta_l > err_l_av_max_2_))
      { err_l_av_max_2_ = delta_l;
      }
    }
  }

  err_l_max_ = max(err_l_max_1_, err_l_max_2_);
  err_l_av_max_ = max(err_l_av_max_1_, err_l_av_max_2_); 
  err_a_max_ = max(err_a_max_1_, err_a_max_2_);
  err_l_av_ = max(err_l_av_1_, err_l_av_2_);
  err_a_av_ = max(err_a_av_1_, err_a_av_2_);
}


void p_cage_bi::show_details()
{ deformations(0, true);
  cout <<" average length err_l_max_ ="<<err_l_max_<<"\n";    
  cout <<" average length err_a_max_ ="<<err_a_max_<<"\n";    
  cout <<" average length err_l_max_1_ ="<<err_l_max_1_<<"\n";    
  cout <<" average length err_a_max_1_ ="<<err_a_max_1_<<"\n";    
  cout <<" average length err_l_max_2_ ="<<err_l_max_2_<<"\n";    
  cout <<" average length err_a_max_2_ ="<<err_a_max_2_<<"\n";    
}

