#ifndef MAT33_H
#define MAT33_H
#include <iostream>
#include <string>
#include <sstream>
#include <cmath>

class vec3;

class mat33
{
 public:
  mat33 ()
  { M_[0][0] = M_[1][1] = M_[2][2] = 1;
    M_[0][1] = M_[1][0] = M_[0][2] = M_[2][0] = M_[1][2] = M_[2][1]= 0;
  }

  mat33 (double v)
  { M_[0][0] = M_[1][1] = M_[2][2] = 
    M_[0][1] = M_[1][0] = M_[0][2] = M_[2][0] = M_[1][2] = M_[2][1]= v;
  }
  
  mat33 (vec3 &col1, vec3 &col2, vec3 &col3 );
 
  //mat33 (vec3 a, vec3 b); // Rotation a -> b

  void set_to_unit()
  { M_[0][0] = M_[1][1] = M_[2][2] = 1;
    M_[0][1] = M_[1][0] = M_[0][2] = M_[2][0] = M_[1][2] = M_[2][1]= 0;
  }
  
  void set(double d)
  { M_[0][0] = M_[0][1] = M_[0][2] = M_[1][0] = M_[1][1] = M_[1][2] =
    M_[2][0] = M_[2][1] = M_[2][2]= d;
  }
  
  void set(double m11,double m12,double m13, double m21,double m22,double m23,
	   double m31,double m32,double m33)
  { M_[0][0] = m11; M_[0][1] = m12; M_[0][2] = m13;
    M_[1][0] = m21; M_[1][1] = m22; M_[1][2] = m23;
    M_[2][0] = m31; M_[2][1] = m32; M_[2][2] = m33;
  }
  
  mat33 unit()
  { mat33 M;
    M.set_to_unit();
    return(M);
  }

  
  double &item(int i, int j) { return(M_[i][j]); }

  // vres = M v
  double *mult(double *v, double *vres);
  
  // this = this * M
  // return this
  mat33 &multR(mat33 &M);
 
  // this = M * this
  // return this
  mat33 &multL(mat33 &M);

  // add to this matrix
  mat33 &operator +=(mat33 &m);
  mat33 &operator -=(mat33 &m);
    
  mat33 operator +(const mat33 &M2) const;
  mat33 operator +(double d) const;
  friend mat33 operator +(double d, const mat33 &M1) { return M1+d; }
  
  mat33 operator -(const mat33 &M2) const;
  mat33 operator -(double d) const;
  friend mat33 operator -(double d, const mat33 &M1)
  { return M1-d;
  }
 
  //product
  mat33 operator *(const mat33 &M2) const;
  mat33 operator *(double d) const;
  friend mat33 operator *(double d, const mat33 &M1)
  { return M1*d;
  }
  friend vec3 operator *(const mat33 &M, vec3 &v);

  // Multiply with this matrix
  mat33 &operator *=(mat33 &M)
  { return multR(M);
  }
  // Multiply with this double
  mat33 &operator *=(double &d);
  mat33 &operator /=(double &d);
   
  mat33 operator /(double d) const;


  mat33 transpose();
  double det();
  mat33 inv();
  
  mat33 &rot_z(double theta);
  mat33 &rot_x(double theta);
  mat33 &rot_y(double theta);

  // set to matrix to rotate v to z axis
  void rot_to_z(double *v);

  // Rz(sigma) Rx(phi) Rz(-sigma)
  mat33 rot_zxz(double sigma, double phi);

 
  /**************************************************/
  /* Rogriges Formula                               */
  /* Matrix rotation of angle theta around vector v */
  /**************************************************/
  mat33 friend rot_v(vec3 &v, double theta);
  
  mat33 friend rot_v(vec3 &v, double sin_theta, double cos_theta);
  mat33 friend rot_v1_v2(vec3 &v1, vec3 &v2);

  mat33 & proj(vec3 &v);
  mat33 & proj_ortho(vec3 &v);
  
  
  std::string str();
  
  void show()
  { std::cout<<str();
  }
protected:
  double M_[3][3];
  
};
mat33 rot_v(vec3 &v, double theta);
mat33 rot_v(vec3 &v, double sin_theta, double cos_theta);
mat33 rot_v1_v2(vec3 &v1, vec3 &v2);

/*******************************************************/
class vec3
{ private:
  double v_[3];  

  public:
  
  vec3() {}
  vec3(double x, double y, double z) { v_[0] = x; v_[1] = y; v_[2] = z; }
  vec3(double *v) { v_[0] = v[0]; v_[1] = v[1]; v_[2] = v[2]; }

  double *v() { return(v_);}
  double & operator [](int i) { return(v_[i]); }
  double norm() const { return(sqrt(v_[0]*v_[0]+v_[1]*v_[1]+v_[2]*v_[2])); }
  double norms() const { return(v_[0]*v_[0]+v_[1]*v_[1]+v_[2]*v_[2]); }
  void normalise()
  { double n= norm();
    v_[0] /= n; v_[1] /= n; v_[2] /= n;
  }
  
  void set_to_zero() { v_[0] = v_[1] = v_[2] = 0; }
  void set(double *v) { v_[0] = v[0]; v_[1] = v[1]; v_[2] = v[2]; }
  void set(vec3 &v) { v_[0] = v[0]; v_[1] = v[1]; v_[2] = v[2]; }
  void set(double v0, double v1, double v2) { v_[0]=v0; v_[1]=v1; v_[2]=v2; }
  
  // scalar product
  friend double operator *(const vec3 &v1, const vec3 &v2)
  { return(v1.v_[0]*v2.v_[0]+v1.v_[1]*v2.v_[1]+v1.v_[2]*v2.v_[2]);
  }
  
  // multiply by scalar on right
  vec3 operator * (double d) const
  { vec3 v;
    v[0] = v_[0]*d;
    v[1] = v_[1]*d;
    v[2] = v_[2]*d;
    return(v);
  }
  // multiply by scalar on left
  friend vec3 operator * (double d, const vec3 &v2) { return(v2*d); }

  // divide by scalar on right
  vec3 operator / (double d) const
  { vec3 v;
    v[0] = v_[0]/d;
    v[1] = v_[1]/d;
    v[2] = v_[2]/d;
    return(v);
  }
  
  // add 2 vectors
  vec3 operator +(const vec3 &v2) const
  { vec3 v;
    v[0] = v_[0] + v2.v_[0];
    v[1] = v_[1] + v2.v_[1];
    v[2] = v_[2] + v2.v_[2];
    return(v);
  }
  // add vectors
  vec3 operator +(const double *v2) const
  { vec3 v;
    v[0] = v_[0] + v2[0];
    v[1] = v_[1] + v2[1];
    v[2] = v_[2] + v2[2];
    return(v);
  }
 
  // subtract 2 vectors
  vec3 operator -( const vec3 &v2) const
  { vec3 v;
    v[0] = v_[0] - v2.v_[0];
    v[1] = v_[1] - v2.v_[1];
    v[2] = v_[2] - v2.v_[2];
    return(v);
  }
  // add vectors
  vec3 operator -(double *v2) const
  { vec3 v;
    v[0] = v_[0] - v2[0];
    v[1] = v_[1] - v2[1];
    v[2] = v_[2] - v2[2];
    return(v);
  }
  
  // Assignment
  vec3 &operator=(const vec3 &v)
  { v_[0] = v.v_[0];
    v_[1] = v.v_[1];
    v_[2] = v.v_[2];
    return(*this);
  }

  // multiply by scalar on right
  vec3 &operator *= (double d)
  { v_[0] *= d;
    v_[1] *= d;
    v_[2] *= d;
    return(*this);
  }

  // add vectors
  vec3 &operator +=(double *v)
  { v_[0] += v[0];
    v_[1] += v[1];
    v_[2] += v[2];
    return(*this);
  }

  // add vectors
  vec3 &operator +=(vec3 &v)
  { v_[0] += v.v_[0];
    v_[1] += v.v_[1];
    v_[2] += v.v_[2];
    return(*this);
  }
 
  // add vectors
  vec3 &operator -=(double *v)
  { v_[0] -= v[0];
    v_[1] -= v[1];
    v_[2] -= v[2];
    return(*this);
  }
  // subtract vector
  vec3 &operator -=(vec3 &v)
  { v_[0] -= v.v_[0];
    v_[1] -= v.v_[1];
    v_[2] -= v.v_[2];
    return(*this);
  }

  // vector cross product
  vec3 cross(const  vec3 &v) const
  { vec3 w;
    w[0] = v_[1]*v.v_[2]-v_[2]*v.v_[1];
    w[1] = v_[2]*v.v_[0]-v_[0]*v.v_[2];
    w[2] = v_[0]*v.v_[1]-v_[1]*v.v_[0];
    return(w);
  }

  // distance between this and v
  double dist(double *v)
  { double d = (v_[0]-v[0])*(v_[0]-v[0])+(v_[1]-v[1])*(v_[1]-v[1])+(v_[2]-v[2])*(v_[2]-v[2]);

    return(sqrt(d));
  }

  double dist_to_plane(const vec3 &V, const vec3 &v1, const vec3 &v2) const;
  friend vec3 plane_normal_V(const vec3 &V, const vec3 &v1, const vec3 &v2);

  friend vec3 refl_ax(vec3 &vec, vec3 &axis, vec3 &V, vec3 &v1, vec3 &v2);

  double angle(vec3 &v2)
  { return(acos(*this*v2/(norm()*v2.norm())));
  }
  
  std::string str();
  std::string str2(); // " " as separator
  
  void show()
  { std::cerr<<" ["<<v_[0]<<","<<v_[1]<<","<<v_[2]<<"]\n";
  }
  
  
};


/*********************************************************************/
/* Detrmine crossing between plane V+a v1 + b v2 and W + c w1 + d w2 */
/* Result line : U + t u                                             */
/*********************************************************************/
void plane_crossing_v1(const vec3 &V, const vec3 &v1, const vec3 &v2,
		    const vec3 &W, const vec3 &w1, const vec3 &w2,
		    vec3 &U, vec3 &u);
void plane_crossing(const vec3 &V, const vec3 &v1, const vec3 &v2,
		    const vec3 &W, const vec3 &w1, const vec3 &w2,
		    vec3 &U, vec3 &u);


#endif
