#include "m_mat33.h"

mat33::mat33 (vec3 &col1, vec3 &col2, vec3 &col3 )
{ for (int i=0; i< 3 ; i++)
  { M_[0][i] = col1[i];
    M_[1][i] = col2[i];
    M_[2][i] = col3[i];
  }
}

 // vres = M v
double *mat33::mult(double *v, double *vres)
{ for (int i=0; i < 3; i++)
  { vres[i] = 0;
    for (int j=0; j < 3; j++)
    { vres[i] += M_[i][j]*v[j]; 
    }
  }
  return(vres);
}

// this = this * M
// return this
mat33 &mat33::multR(mat33 &M)
{ double w[3];
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { w[j] = 0;
      for (int k=0; k < 3; k++)
      { w[j] += M_[i][k]* M.M_[k][j];
	}
    }
    for (int j=0; j < 3; j++)
    { M_[i][j] = w[j];
    }
  }
  return(*this);
}
  
// this = M * this
// return this
mat33 &mat33::multL(mat33 &M)
{ double w[3];
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { w[j] = 0;
      for (int k=0; k < 3; k++)
      { w[j] += M.M_[j][k]* M_[k][i];
	}
    }
    for (int j=0; j < 3; j++)
    { M_[j][i] = w[j];
    }
  }
  return(*this);
}

// add to this matrix
mat33 &mat33::operator +=(mat33 &m)
{ for(int i=0; i < 3; i++)
  { for(int j=0; j < 3; j++)
    { M_[i][j] += m.M_[i][j];
    }
  }
  return(*this);
}

mat33 &mat33::operator -=(mat33 &m)
{ for(int i=0; i < 3; i++)
  { for(int j=0; j < 3; j++)
    { M_[i][j] -= m.M_[i][j];
    }
  }
  return(*this);
}

 mat33 mat33::operator +(const mat33 &M2) const 
 { mat33 M;
   for (int i=0; i < 3; i++)
   { for (int j=0; j < 3; j++)
     { M.M_[j][i] = M_[j][i]+M2.M_[j][i];
     }
   }
   return M;
 }
 
mat33 mat33::operator +(double d) const 
{ mat33 M2(0);
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { M2.M_[i][j] = M_[i][j]+d;
    }
  }
  return M2;
}
 
mat33 mat33::operator -(const mat33 &M2) const
{ mat33 M;
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { M.M_[j][i] = M_[j][i]-M2.M_[j][i];
    }
  }
  return M;
}

mat33 mat33::operator -(double d) const
{ mat33 M2(0);
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { M2.M_[i][j] = M_[i][j] - d;
    }
  }
  return M2;
}

//product
mat33 mat33::operator *(const mat33 &M2) const
{ mat33 M3(0);
  double w[3];
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { w[j] = 0;
      for (int k=0; k < 3; k++)
      { w[j] += M_[j][k]* M2.M_[k][i];
      }
     }
    for (int j=0; j < 3; j++)
    { M3.M_[j][i] = w[j];
    }
  }
  return M3;
}
  
mat33 mat33::operator *(double d) const
{ mat33 M2(0);
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { M2.M_[i][j] = M_[i][j]*d;
    }
  }
  return M2;
}

/* Matrix * Vector */  
vec3 operator *(const mat33 &M, vec3 &v)
{ vec3 vec;

  for(int i=0; i< 3; i++)
  { vec[i] = 0;
    for(int j=0; j< 3; j++)
    { vec[i] += M.M_[i][j]*v[j];
    }
  }
  return(vec);
} 

mat33 &mat33::operator *=(double &d)
{ for(int i=0; i< 3; i++)
  { for(int j=0; j< 3; j++)
    { M_[i][j] *= d;
    }
  }
  return(*this);
}

mat33 &mat33::operator /=(double &d)
{ for(int i=0; i< 3; i++)
  { for(int j=0; j< 3; j++)
    { M_[i][j] /= d;
    }
  }
  return(*this);
}

mat33 mat33::operator /(double d) const
{ mat33 M2(0);
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { M2.M_[i][j] = M_[i][j]/d;
    }
  }
  return M2;
}

mat33 mat33::transpose()
{ mat33 M;
  for (int i=0; i < 3; i++)
  { for (int j=0; j < 3; j++)
    { M.M_[i][j] = M_[j][i];
    }
  }
  return M;
}

double mat33::det()
{ double d=0;
  int i1,i2,si=1;
  for (int i=0; i < 3; i++)
  { i1 = (i+1)%3;
    i2 = (i+2)%3;
    d += M_[i][0]*(M_[i1][1]*M_[i2][2]-M_[i1][2]*M_[i2][1])*si;
    //si = -si;
  }
  return d;
}

mat33 mat33::inv()
{ mat33 Mi(0);
  double d =0,tmp;
  int i1,i2,j1,j2,si=1,sj;
  for (int i=0; i < 3; i++)
  { i1 = (i+1)%3;
    i2 = (i+2)%3;
    sj = 1;
    for (int j=0; j < 3; j++)
    { j1 = (j+1)%3;
      j2 = (j+2)%3;
	tmp = (M_[i1][j1]*M_[i2][j2]-M_[i1][j2]*M_[i2][j1]);
      Mi.M_[j][i] = tmp;
	if (j==0) { d += tmp*M_[i][j]; }
	sj = -sj;
    }
    si = -si;
  }
  return Mi/d;
}

mat33 &mat33::rot_z(double theta)
{ M_[0][0] =  M_[1][1] = cos(theta);
  M_[0][1] = -sin(theta);
  M_[1][0] = sin(theta);
  M_[2][2] = 1;
  M_[0][2] = M_[2][0] = M_[1][2] = M_[2][1]= 0;

  return *this ;
}

mat33 &mat33::rot_x(double theta)
{ M_[1][1] =  M_[2][2] = cos(theta);
  M_[1][2] = -sin(theta);
  M_[2][1] = sin(theta);
  M_[0][0] = 1;
  M_[1][0] = M_[2][0] = M_[0][1] = M_[0][2]= 0;

  return *this;
}

mat33 &mat33::rot_y(double theta)
{ M_[0][0] =  M_[2][2] = cos(theta);
  M_[0][2] = -sin(theta);
  M_[2][0] = sin(theta);
  M_[1][1] = 1;
  M_[0][1] = M_[2][1] = M_[1][0] = M_[1][2]= 0;

  return(*this);
}

// set to matrix to rotate v to z axis
void mat33::rot_to_z(double *v)
{ double phi,theta;
  mat33 r1;
  phi = atan2(v[0],v[1]);
  theta = M_PI*0.5-atan2(v[2],sqrt(v[0]*v[0]+v[1]*v[1]));

  //std::cerr<<" phi="<<phi<<" theta="<<theta<<"\n";
  r1.rot_z(phi);
  rot_x(-theta);
  multR(r1);
}

// Rz(sigma) Rx(phi) Rz(-sigma)
mat33 mat33::rot_zxz(double sigma, double phi)
{ mat33 Rz,Rx;
  Rx.rot_x(phi);
  Rz.rot_z(-sigma);
  Rx.multR(Rz);
  rot_z(sigma);
  multR(Rx);
  
  return(*this);
}

/**************************************************/
/* Rogriges Formula                               */
/* Matrix rotation of angle theta around vector v */
/**************************************************/
mat33 rot_v(vec3 &v, double theta)
{ mat33 W(0), M; // M is unit matrix
  vec3 vc(v);
  
  vc.normalise();
  W.M_[0][1] = -vc[2];
  W.M_[0][2] = vc[1];
  W.M_[1][2] = -vc[0];
  W.M_[1][0] = vc[2];
  W.M_[2][0] = -vc[1];
  W.M_[2][1] = vc[0];

  return M+W*sin(theta)+W*W*(1-cos(theta));
}
  
mat33 rot_v(vec3 &v, double sin_theta, double cos_theta)
{ mat33 W(0), M; // M is unit matrix
  vec3 vc(v);

  vc.normalise();
  W.M_[0][1] = -vc[2];
  W.M_[0][2] = vc[1];
  W.M_[1][2] = -vc[0];
  W.M_[1][0] = vc[2];
  W.M_[2][0] = -vc[1];
  W.M_[2][1] = vc[0];

  return M+W*sin_theta+W*W*(1-cos_theta);
}

/**********************************/
/* Rotation matrice of v1 onto v2 */
/**********************************/
mat33 rot_v1_v2(vec3 &v1, vec3 &v2)
{ vec3 v1n(v1), v2n(v2), v;
  mat33 W(0), WW, R;
  
  v1n.normalise();
  v2n.normalise();
  v = v1n.cross(v2n);
      
  W.M_[0][1] = -v[2];
  W.M_[0][2] = v[1];
  W.M_[1][0] = v[2];
  W.M_[1][2] = -v[0];
  W.M_[2][0] = -v[1];
  W.M_[2][1] = v[0];

  R = R + W+W*W*(1.0/(1+v1n*v2n));
  
  return R;
}

/**********************************/
/* Projector onto v   P = v v^t   */
/**********************************/
mat33 & mat33::proj(vec3 &v)
{ double nvs =  v[0]*v[0]+v[1]*v[1]+v[2]*v[2];
  for(int i=0; i<3; i++)
  { for(int j=0; j<3; j++)
    { M_[i][j] = v[i]*v[j]/nvs;
    }
  }
  return *this;
}

/**********************************/
/* Projector onto v   P = 1- v v^t*/
/**********************************/
mat33 & mat33::proj_ortho(vec3 &v)
{ double nvs =  v[0]*v[0]+v[1]*v[1]+v[2]*v[2];
  for(int i=0; i<3; i++)
  { for(int j=0; j<3; j++)
    { M_[i][j] = -v[i]*v[j]/nvs;
      if (i==j)
      { M_[i][i] += 1;
      }
    }
  }
  return *this;
}

std::string mat33::str()
{ std::stringstream sf;
  sf << "[ ";
  for (int i=0; i<3; i++)
  { sf<<" [";
    for (int j=0; j < 3; j++)
    { if (j > 0) sf << " ,";
	sf<<M_[j][i]<<" ";
    } 
    sf << "]\n";
  }
  sf << "]\n";
  return(sf.str());
}

/*****************************************************************/
/* Return the distance between this and the plane V v1 v2 */
/**********************************************************/
double vec3::dist_to_plane(const vec3 &V, const vec3 &v1, const vec3 &v2) const
{ vec3 p = v1.cross(v2)/(v1.norm()*v2.norm());
  return(fabs((*this-V)*p));
}

/******************************************************/
/* Return the V that is normal for the plane V v1 v2  */
/******************************************************/
vec3 plane_normal_V(const vec3 &V, const vec3 &v1, const vec3 &v2)
{ vec3 p = v1.cross(v2)/(v1.norm()*v2.norm());
  return(p*(V*p));
}

/*  Given vec = V+a v1 + b v2 :                                       */
/* return reflection of vec around the vector axis in the v1 v2 plane */
vec3 refl_ax(vec3 &vec, vec3 &axis, vec3 &V, vec3 &v1, vec3 &v2)
{ vec3 p = vec-V; // vector in the v1 v2 plane 
  double c1 = p*v1;
  double c2 = p*v2;
  double asq = axis[1]*axis[1];
  double bsq = axis[0]*axis[0];
  double ab = axis[0]*axis[1];
  return(V+v1*(c1*(1-2*asq)-2*c2*ab)+v2*(c2*(1-2*bsq)-2*c1*ab));
}

std::string vec3::str()
{ std::stringstream sf;
  sf << "[ ";
  for (int i=0; i<3; i++)
  { if (i > 0) sf << " ,";
    sf << v_[i];
  }
  sf << "]";
  return(sf.str());
}

std::string vec3::str2()
{ std::stringstream sf;
  for (int i=0; i<3; i++)
  { if (i > 0) sf << " ";
    sf << v_[i];
  }
  return(sf.str());
}

/*****************************************************************/

/*********************************************************************/
/* Detrmine crossing between plane V+a v1 + b v2 and W + c w1 + d w2 */
/* Result line : U + t u                                             */
/* U is in the V W plane                                             */
/*********************************************************************/
void plane_crossing_v1(const vec3 &V, const vec3 &v1, const vec3 &v2,
		       const vec3 &W, const vec3 &w1, const vec3 &w2,
		       vec3 &U, vec3 &u)
{ vec3 p,q,Q;
  double Qv1,Qv2,qv1,qv2,qWmV;
  
  p = v1.cross(v2);
  q = w1.cross(w2);
  Q = q.cross(p);
    
  Qv1 = Q*v1;
  Qv2 = Q*v2;
  qv1 = q*v1;
  qv2 = q*v2;
  qWmV = q*(W-V);

  vec3 tmp = (Qv2*v1-Qv1*v2)*qWmV/(Qv2*qv1-Qv1*qv2);
  U = V + tmp;
  u = Q/Q.norm();
}

/*********************************************************************/
/* Detrmine crossing between plane V+a v1 + b v2 and W + c w1 + d w2 */
/* Result line : U + t u                                             */
/* U is perendicular to u                                            */
/*********************************************************************/
void plane_crossing(const vec3 &V, const vec3 &v1, const vec3 &v2,
		    const vec3 &W, const vec3 &w1, const vec3 &w2,
		    vec3 &U, vec3 &u)
{ vec3 p,q;
  double uv1,uv2,uV,qv1,qv2,qWmV;
  
  p = v1.cross(v2);
  q = w1.cross(w2);
  u = q.cross(p);
    
  uV  = u*V;
  uv1 = u*v1;
  uv2 = u*v2;
  qv1 = q*v1;
  qv2 = q*v2;
  qWmV = q*(W-V);

  if (fabs(uv2)<fabs(uv1))
  { double a2 = (qWmV*uv1+uV*qv1)/(qv2*uv1-uv2*qv1);
    U = V+a2*(v2-v1*(uv2/uv1))+v1*(uV/uv1);
  }
  else
  { double a1 = (qWmV*uv2+uV*qv2)/(qv1*uv2-uv1*qv2);
    U = V+a1*(v1-v2*(uv1/uv2))+v2*(uV/uv2);
  }
  u.normalise();
}
