#ifndef GRAPH_PROP_H
#define GRAPH_PROP_H
#include <fstream>
#include <string>

const int MAX_FT = 5;

class graph_prop
{ public:
  bool good_;
  int L1_;
  int L2_;
  int V1_;
  int V2_;
  int nft_; // number of face types
  int N_[MAX_FT];
  int i1_[MAX_FT];
  int i2_[MAX_FT];

  graph_prop() : good_(false), L1_(0), L2_(0), V1_(0), V2_(0), nft_(0)
  {
  }

  /* Reach 1 integer from string p            */
  /* Return p on next char, skiping separator */
  const char *read_number(const char *p, int &val)
  { val = 0;
    while(*p)
    { if ('0'<= *p  && *p <= '9')
      { val = val*10+ *p - '0';
      }
      else
      { return(++p);
      }
      p++;
    }
    return(p);
  }
  
  /* L1 L2 V1 V2 N1 i1 i2 N2 i1 i2 ... */
  /* Return : 1 read line              */
  /*          0 : empty line           */
  int read(const char *p, bool good=false)
  { if(! *p) return(0);

    //std::cerr<<"LINE: "<<p<<"\n";
    
    good_ = good;
    if (*p)  { p = read_number(p, L1_); }
    if (*p)  { p = read_number(p, L2_); }
    if (*p)  { p = read_number(p, V1_); }
    if (*p)  { p = read_number(p, V2_); }

    nft_ = 0;
    while(*p)
    { if (*p)  { p = read_number(p, N_[nft_]); }
      if (*p)  { p = read_number(p, i1_[nft_]); }
      if (*p)  { p = read_number(p, i2_[nft_]); }
      nft_++;
    }
    if(N_[nft_-1] == 0) // The last entry was empty
    { nft_ --;
    }
    //std::cerr<<"READ: "<<L1_<<" "<<L2_<<" "<<V1_<<" "<<V2_<<" "<<N_[0]<<" "<<i1_[0]<<" "<<i2_[0]<<" : "<<nft_<<"\n";
    return(nft_>0 ? 1 : 0);
  }

  void show()
  { int F=0;
    std::cerr<<L1_<<L2_;
    for(int k=0; k < nft_; k++)
    { std::cerr<<"_"<<N_[k]<<"-"<<i1_[k]<<"-"<<i2_[k];
      F += N_[k];
    }
    std::cerr<<"_V"<<V1_<<"-"<<V2_<<"_F"<<F<<"\n";
  }
};

#endif
