#ifndef GETARGS_H
#define GETARGS_H

#define PAR_FLAG_READ      1
#define PAR_FLAG_NOHELP    2
#define PAR_FLAG_NOPARLIST 4
#define PAR_FLAG_QUOTEPSTR 8

#define MAX_PAR_LINE_LENGTH 512

enum PArgsTypes {
  T_NONE   = 0,
  T_INT    = 1,
  T_REAL   = 2,
  T_CHAR   = 3,
  T_BOOL   = 4,
  T_FLAG   = 5,
  T_STRING = 6,
  T_COMMENT= 7
};

enum PArgsRead {
  PA_READ_EOF = 0,
  PA_READ_ONE_WORD = 1,
  PA_READ_TWO_WORD = 2,
  PA_READ_WORD_AND_STRING = 3,
  PA_READ_EMPTY_LINE = 4,
  PA_READ_ERROR = -1
};

typedef int PArgsModes;
#define PA_BADARGOK     (1)
#define PA_BADPAROK     (1<<1)
#define PA_NEGNOOK      (1<<2)
#define PA_MINUSOK      (1<<3)
#define PA_MINUSLAST    (1<<4)
#define PA_H_ALIASHELP    (1<<5)
#define PA_HELP_ALIASHELP (1<<6)
#define PA_V_ALIAVERSION  (1<<7)
#define PA_VERSION_ALIAVERSION (1<<8)
#define PA_MPL_ALIASMPL  (1<<9)
#define PA_L_ALIASMPL    (1<<10)
#define PA_MPLS_ALIASMPL  (1<<11)
#define PA_LS_ALIASMPL    (1<<12)
#define PA_MINUSMINUS_H   (1<<13)
#define PA_HALIASHELP    (PA_H_ALIASHELP|PA_HELP_ALIASHELP)
#define PA_VALIAVERSION  (PA_V_ALIAVERSION|PA_VERSION_ALIAVERSION)
#define PA_MPLALIASMPL   (PA_MPL_ALIASMPL|PA_L_ALIASMPL)
#define PA_MPLSALIASMPL   (PA_MPLS_ALIASMPL|PA_LS_ALIASMPL)
#define PA_MPL           (PA_MPLALIASMPL|PA_MPLSALIASMPL)

#define PA_GETARGS_STD   (PA_BADARGOK|PA_NEGNOOK|PA_HALIASHELP|PA_VALIAVERSION)
#define PA_GETPARS_STD   (PA_HALIASHELP|PA_VALIAVERSION|PA_MPL)

struct Parameter {
  const char *name;
  PArgsTypes type;
  void *p;
  const char *init_val;
  int flag;
  const char *alias;
  const char *help;
};

int GetPars(int const argc,char *const *argv,Parameter *pars,
            const char **help, char ** &Argv,PArgsModes const mode);
int GetArgs(int const argc,char *const *argv,Parameter *pars,
            const char **help, char ** &Argv,PArgsModes const mode);
int string_index(const char **ptr,const char *name);

#endif
