#ifndef EQUIGRAPH_BI_SNAPSHOT_H
#define EQUIGRAPH_BI_SNAPSHOT_H
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>

const int MAX_P = 100;
const int MAX_L = 9; // 5*2 -1

class pair_12
{ public:
  int i1_[MAX_L]; // Number of vertices of type 1
  int N_[MAX_L];  // Face: Number of faces of that type
  int k_;         // Face: number of face types.
  
  pair_12(): k_(0) {}

  void reset() { k_=0; }
  
  void add(int i, int N) { i1_[k_] = i; N_[k_++] = N; }
  int size() { return(k_); }

  std::string str(int k)
  { std::stringstream ss;
    ss<<"$"<<N_[k]<<"_{"<<i1_[k]<<","<<i1_[k]<<"}$";
    return(ss.str());
  }
  
  std::string str_n(int k, int val, int s)
  { std::stringstream ss;
    ss<<"$"<<val<<"_{"<<s<<";"<<i1_[k]<<","<<i1_[k]<<"}$";
    return(ss.str());
  }
  
  std::string str_n_bf(int k, int val, int s)
  { std::stringstream ss;
    ss<<"$"<<val<<"_{{\\bf "<<s<<"};"<<i1_[k]<<","<<i1_[k]<<"}$";
    return(ss.str());
  }

  std::string str_par(int k)
  { std::stringstream ss;
    ss<< (k==0 ? "; " : ", ");
    ss<<N_[k]<<" "<<i1_[k]<<" "<<i1_[k];
    return(ss.str());
  }
  
  int find_index_of(int i1)
  { for (int k=0; k < size(); k++)
    { if ((i1==i1_[k]) ) return(k);
    }
    return(-1);
  }

  std::string str_n_par(int k, pair_12 &fl, std::string sep)
  { std::stringstream ss;
    ss<< sep+" ";
    ss<<N_[k]<<" "<<fl.find_index_of(i1_[k]);
    return(ss.str());
  }
 
  int find_faces(int i1)
  { for(int i=0; i < k_; i++)
    { if (i1_[i] == i1)
      { return(N_[i]);
      }
    }
    return(0);
  }
};

class n12
{ public:
  int N_[MAX_P+1]; // number of face of type i,i
  int max_p_;
  
  n12(int max_p) : max_p_(max_p)
  { for(int i=0; i<=MAX_P; i++)
    { N_[i] = 0;
    }
  }
  
  inline void set(int i, int val) { N_[i] = val;}
  inline int p(int i) { return(i<<1);}


  void show()
  { for(int i1=0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
      { std::cerr<<" N_("<<i1<<","<<i1<<")="<<N_[i1];
      }
    }
    std::cerr<<"\n";
  }

  void save(std::ofstream &ofs)
  { ofs << max_p_ << "\n";
    for(int i1=0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
      { ofs << i1 <<" "<< N_[i1] <<"\n";
      }
    }
  }
  
  // Largest polygon size
  int max_polygon()
  { int max = 0;
    for(int i1=0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
       { if ((i1<<1) > max)
	 { max = i1<<1;
	 }
       }
    }
    return(max);
  }
  
  int nface_type(int p, int &Nft1) // p : upper bound on polygon
  { int Nface_types = 0;
    Nft1 = 0;
    
    for(int i1=0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
      { Nface_types++;
	if(i1 > 0) Nft1++;
      }
    }
    return(Nface_types);
  }

  // Compute all the non zero i_1 * n(i_1,i_2)
  // Store restults in ai
  int ini1(int *ai)
  { int k = 0;
    for(int i1 = 0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
      { ai[k++] = i1*N_[i1];
      }
    }
    return(k);
  }
  
  // Compute V1 = sum(i) i n(i,i)/L1
  //         V2 = sum(i) i n(i,i)/L2
  // Store restults in ai
  void V(int L1, int L2, int &V1, int &V2)
  { int V= 0;
    for(int i1 = 0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
      { V += i1*N_[i1];
      }
    }
    V1 = V/L1;
    V2 = V/L2;
  }

  // Compute F = sum(i1,i2) n(i1,i2)
  int F()
  { int nF = 0;
    for(int i1 = 0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
      { nF += N_[i1];
      }
    }
    return(nF);
  }

  void mk_pair_list(pair_12 &l12)
  { for(int i1 = 0; i1 <= max_p_; i1++)
    { if(N_[i1] > 0)
      { l12.add(i1, N_[i1]);
      }
    }
  }
};

class trace_data {
public:
  int p_;
  int i1_;
  int nf_;

  trace_data(int p, int i1, int nf): p_(p), i1_(i1), nf_(nf) {};
  trace_data(std::ifstream &iof)
  { iof >> p_;
    iof >> i1_;
    iof >> nf_;
    if (iof.eof()) { p_ = -1;}  // avoid duplication of last line
  }

  void save(std::ofstream &ofs)
  { ofs<<p_<<" "<<i1_<<" "<<nf_<<"\n";
  }
  
  void show()
  { std::cout<<p_<<" "<<i1_<<" "<<nf_<<"\n";
  }

  
}; 
#endif
