#include <getargs.h>
#include <m_except.h>
#include <fstream>
#include <cstdio>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>
#include <cstdlib>
#include <ctime>
#include <sys/stat.h>
#include "equigraphs_bi_12_snapshot.h"
#include "graphs_prop.h"

using namespace std;

const char *VERSION = "equigraphs_bi: v1.0; 10/3/21; B. Piette";

struct pars {
  int P;
  int L1;
  int L2;
  int Fmax;
  char ImpStr[80];
  //  int Imp;
  int snapshot_interval;
  char restore[80];
} par;

Parameter Pars[] = {
 {"P",T_INT,&par.P,"10",0,0," Maximum hole face size"},
 {"L1",T_INT,&par.L1,"3",0,0," Number of edges per vertices of 1st type"},
 {"L2",T_INT,&par.L2,"4",0,0," Number of edges per vertices of 2nd type"},
 {"Fmax",T_INT,&par.Fmax,0,0,"F","Maximum no of faces"},
 // {"Imp",T_STRING,par.ImpStr,0,0,"I","Show some im possible graphs started"},
 {"snapshot_interval",T_INT,&par.snapshot_interval,"3600",0,"ssi",
  "Interval between snapshots in seconds"},
 {"restore",T_STRING,par.restore,"",0,"R","Snapshot restore file"},
 { 0,T_NONE,0,0,0,0,0},
};

const char * help[] = {
 "equigraphs_bi_na [-P N] [-L1 N] [-L2 N] [-Fmax N]",
 "  Generates all the equivalent graphs",
 "  P : maximum polygon size for the faces",
 "  L1 : Number of edges per vertex (3 or 4)",
 "  L2 : Number of edges per vertex (4 or 5)",
 "  Fmax : maximum number of faces", 
 // "  Imp : MASK shifts: show some impossible cages (-1 : all).", 
};

//const int MAX_P = 25;

bool test_compat(int s, n12 &nij, int L);
bool restore_snapshots();
void scan(int p, int nfu, n12 &nij, ofstream &ofs_p, int level,
	  int resume_level);
void check(n12 &nij, ofstream &ofs_p);

const int COL_N_MAX=4;
const int COL_V_MAX=7;
const int LINE_PER_PAGE=39;

const int MAX_GRAPH_PROP = 1000;

graph_prop list_graphs[MAX_GRAPH_PROP]; 
int graph_index = 0;
const char *good_graphs = "good_graphs.txt";
const char *imp_graphs = "imp_graphs.txt";
char Snapshot[2028];


const char *SYMB = "0123456789abcdefghijklmnopqrstuvwxyz"; 

vector <trace_data> Trace;
time_t last_snapshot_time = time(NULL);


string to_str(int i)
{ char b[100];
  sprintf(b,"%d",i);
  return(string(b));
}

/* Convert mit masks into a mask */
/*  - -> all bits set            */
int str2mask(char *s)
{ int m = 0, i = 0, c;

  if(s[0] == '-') { return (0xffff); }
  
  while((c = s[i++]))
  { if (c >= 'a') { c = 10+c-'a'; }
    else { c = c-'0'; }
    m += 1<<c;
  }
  return(m);
}

void read_graph_list(const char *fname, bool good)
{ ifstream ifs(fname);
  string line;
  int n = 1;
  
  while(std::getline(ifs, line))
  { //std::cerr<<"index "<<graph_index<<"\n";
    //std::cerr<<line<<"\n";
    n = list_graphs[graph_index].read(line.c_str(), good);
    //std::cerr<<"index="<<graph_index<<"\n";
    //list_graphs[graph_index].show();
    graph_index += n;
  }
}

void show_graph_list()
{ int k=0;
  //std::cerr<<"index="<<graph_index<<"\n";
  for (k=0; k < graph_index; k++)
  { //std::cerr<<"k="<<k<<"\n";
    list_graphs[k].show();
  }
}

/***************************************/
/* Search for the graph in list_graphs */
/* Return :  0 : not found             */
/*           1 : good graph            */
/*           -1 : impossible graph     */
/***************************************/
int find_graph(pair_12 &l12)
{ 
  for(int k=0; k < graph_index; k++)
  { bool found=false;
    if((list_graphs[k].L1_ == par.L1)&& (list_graphs[k].L2_ == par.L2)&&
       (list_graphs[k].nft_ == l12.size()))
    { found = true;
      for (int i=0; i < l12.size(); i++)
      { if((list_graphs[k].N_[i] != l12.N_[i])||
	   (list_graphs[k].i1_[i] != l12.i1_[i]))
	{ found = false;
	}
      }
    }
    if(found)
    { return(list_graphs[k].good_ ? 1 : -1);
    }
  }
  return(0);
}

std::string ReplaceString(std::string subject, const std::string& search,
                          const std::string& replace)
{ size_t pos = 0;
  while ((pos = subject.find(search, pos)) != std::string::npos)
  { subject.replace(pos, search.length(), replace);
    pos += replace.length();
  }
  return subject;
}

int main(int argc, char **argv)
{ //int Argc;
  char **Argv=0;
  string fname, fname_p;
  ofstream ofs;
  ofstream ofs_p;

  try
  { GetArgs(argc,argv,Pars,help,Argv,PA_GETARGS_STD);
  }
  catch(string s_err)
  { cerr << "equigraphs : "<< s_err<<"\n";
    exit(1);
  }

  if (par.L1 > par.L2)
  { cerr<<" Invalid value of L1 "<<par.L1<<" and L2: "<<par.L2
	<<" : L1 must be <smaller than L2\n";
    exit(1);
  }

  sprintf(Snapshot,"snapshot_Fmax%d_L%d_L%d.txt",par.Fmax,par.L1,par.L2);
  
  //std::cerr<<"par.ImpStr"<<"\n";
  //std::cerr<<"Imp:"<<std::hex<<par.Imp<<"\n";
  //std::cerr<<"Imp 13P0:"<<std::hex<<IMP_13P0_2322_2422_240Q<<"\n";

  string s_imp;
  //if (par.Imp) { s_imp = "_imp"+string(par.ImpStr); }

  fname_p = "equigraphs_bi_12_P"+to_str(par.P)+"_L"+to_str(par.L1)+"_L"+to_str(par.L2)+"_Fmax"+to_str(par.Fmax)+s_imp+".par";
  ofs_p.open(fname_p.c_str(), ios::out | ios::app);

  read_graph_list(good_graphs, true);
  read_graph_list(imp_graphs, false);
  //show_graph_list();
  
  n12 nij(par.P+1);

  int resume_level = -1;
  if (par.restore[0])
  { if (restore_snapshots()) // restore snapshots
    { resume_level = 0; // worked
    }
  }
  //cout<<"resume_level = "<<resume_level<<"\n";
  
  scan(4, 0, nij, ofs_p, 0, resume_level);
}

void make_snapshot()
{ ofstream ofs;
  ofs.open(Snapshot, ios::out);

 for(vector<trace_data>::iterator it = Trace.begin(); it != Trace.end(); ++it)
 { it->save(ofs);
 }
}

/* Return True if the file is empty or does not exist */
bool empty_file(char *filename)
{
    struct stat stat_buf;
    int rc = stat(filename, &stat_buf);
    return (rc < 0) || (stat_buf.st_size == 0) ;
}

// Return True if snapshot file non empty
bool restore_snapshots()
{ if (empty_file(Snapshot)) { return false; }
  
  ifstream ifs;
  ifs.open(Snapshot, ios::in);
  while(!ifs.eof())
  { trace_data td(ifs);
    td.show();
    if (td.p_ >= 0)   // avoid duplication of last line
    { Trace.push_back(td);
    }
  }
  return(true);
}

/////////////////////////////////////////////////////////
// Scan all possible values of all the ni recursively
// Then test compatibility conditions
// p : polygon type (3,4 ... P)
// i1 : number of edges of type 1 (i2 = p = i1)
// nfu : number of faces used (must be <= Fmax)
// nij : list of pairs i j with their number
// ofs_p : pointer to output stream for par file
// resume_level : resume level from Trace (-1 for none)
/////////////////////////////////////////////////////////
void scan(int p, int nfu, n12 &nij, ofstream &ofs_p, int level,
	  int resume_level)
{ int nf, i1, i2, Nface_types, Nface_type1, Nft1, Nft;
  int nf_max = par.Fmax-nfu; 
  i1 = i2 = p>>1;
  trace_data td(p,i1,0);
  bool tracing = true;  
  if (resume_level >=  (int) Trace.size())
  { resume_level =-1;  //resume completed
  }

  //cout<<"scan\n";
  
  if (resume_level >= 0) // restore trace 
  { td = Trace[resume_level++];
    p = td.p_;
    i2 = i1 = td.i1_;
    tracing= false;
    //cout<<"Restore p="<<p<<" i1="<<i1<<" nf="<<td.nf_<<" resume_level="<<resume_level<<" size="<<Trace.size() <<"\n"<<std::flush;
  }
  
  //cerr<<"scan(p="<<p<<",i1="<<i1<<",i2="<<i2<<",nfu="<<nfu<<" level="<<level<<")\n";
  //L = max(par.L1,par.L2);
  
  /* Count the number of non zero ni[i] */
  /* Nfts -> No of face with node of type s  */
  Nface_types = nij.nface_type(p, Nface_type1);

  //cerr<<"n="<<n<<"\n";
  for(nf = td.nf_; nf <= nf_max; nf++) // Scan all numbers of p-gon faces
  { //cerr<<" scan: nf="<<nf<<" p="<<p<<" i1="<<i1<<" i2="<<i2<<"\n";

    if(tracing)
    { Trace.push_back(trace_data(p, i1, nf));
     
      time_t t = time(NULL);
      if ((t-last_snapshot_time) > par.snapshot_interval)
      { last_snapshot_time = t;
        make_snapshot();
	std::cout<<"SNAPSHOT\n";
      }
    }
    
    nij.set(i1, nf);
    Nft = Nface_types;
    Nft1 = Nface_type1;
    if(nf > 0)
    { Nft++;
      if(i1 > 0) Nft1++;
    }
   
    //cerr<<"Tested\n";
    if(p > par.P)
    { check(nij, ofs_p);
        //cerr<<"check return= "<<cn<<" \n";
    }
    else if ((Nft1 <= par.L1) && (Nft1 <= par.L2))
    { //cerr<<"p="<<p<<" i1="<<i1<<"\n";
      scan(p+2, nfu+nf, nij, ofs_p, level+1, resume_level);
    }
    resume_level = -1;
    tracing = true;
    
    //cerr<<"set nij= "<<i1<<","<<i2<<" 0\n";
    nij.set(i1, 0);
    Trace.pop_back();
  }
}

/* Perform the graph check and output the table line */
void check(n12 &nij, ofstream &ofs_p)
{ int val =0, v1, v2, v1tot, v2tot;
  int V1=0, V2=0; // No of vertices of type 1 and 2.
  int ini1;
  pair_12 l12; // faces 
  string Type;
    
  //cerr<<"check\n"; nij.show();
  
  nij.mk_pair_list(l12);

  val = 0;
  for(int k = 0; k < l12.size(); k++)
  { val += l12.N_[k]*(par.L1*par.L2+l12.i1_[k]*(par.L1+par.L2-par.L1*par.L2));
  }
  //cerr<<"val="<<val<<"\n";
  if (val != 2*par.L1*par.L2) return;

  nij.V(par.L1, par.L2, V1, V2);

  if (V1==0 || V2==0 || (nij.max_polygon() > par.P)) return;
  if (V1*par.L1 != V2*par.L2) return; 
  
  if ((Type == "") )
  { int g = find_graph(l12);
    if(g!=0)
    { Type = g==1 ? "GOOD" : "IMPOSSIBLE";
    }
  }
  
  pair_12 lv1; // vertices type 1: face # and type: v1 i1 i2 
  pair_12 lv2; // vertices type 2: face # and type: v2 i1 i2
  stringstream ssp, ssp2;
  v1tot = v2tot = 0;
  
  // scan the n(i,j)
  for(int k = 0; k < l12.size(); k++)
  { ini1 = l12.N_[k]*l12.i1_[k];
    v1 = ini1/V1;
    v2 = ini1/V2;
    v1tot += v1;
    v2tot += v2;
    
    if((v1*V1 != ini1) || (v2*V2 != ini1))
    { return;
    }
    
    if ((v1*V1==ini1) && (v2*V2==ini1))
    { lv1.add(l12.i1_[k], v1);
      lv2.add(l12.i1_[k], v2);
      ssp<<l12.str_par(k);
    }
    else return;
  }

  
  if(v1tot != par.L1 || v2tot != par.L2) return;

  std::string sep=";";
  for(int k = 0; k < lv1.size(); k++)
  { v1 = lv1.N_[k];
    if(v1 != 0)
    { ssp2<<lv1.str_n_par(k, l12, sep);
      sep = ",";
    }
  }
  sep = ";";
  for(int k = 0; k < lv2.size(); k++)
  { v2 = lv2.N_[k];
    if(v2 != 0)
    { ssp2<<lv2.str_n_par(k, l12, sep);
      sep = ",";
    }
  }

  // Valences Faces ; Nodes V1; nodes V2; N1 N2  
  // V1 V2 
  ofs_p<<par.L1<<" "<<par.L2;
  //; N0 t00 t01, N1 t10 t11
  ofs_p<<ssp.str();
  // n00 F0, n01 F1, ...;  n10 F1, n11 F1,  ...; 
  ofs_p<<ssp2.str();
  // nL1 nL2
  ofs_p<<"; "<<V1<<" "<<V2<<" # "<<nij.F()<<"\n"<<std::flush;
		      
}
