
//run("Make Binary", "method=Default background=Light");
endCount = roiManager("count");

for (i = 0; i < endCount; i++) {

roiManager("select",i);
run("Enlarge...", "enlarge=20 pixel");

run("Clear Results");  // First, clear the results table
  
// loop through each slice in the stack. Start at n=1 (the first slice), 
// keep going while n <= nSlices (nSlices is the total number of slices in the stack)
// and increment n by one after each loop (n++)
for (n=1; n<=nSlices; n++) {  
	setSlice(n);  // set the stack's current slice to n
	run("Measure");   // Run the "Measure" function in ImageJ
}

// Create a variable that we will use to store the area measured in each slice
totalArea = 0;
// Loop through each result from 0 (the first result on the table) to nResult (the total number of results on the table)
for (n=0; n < nResults; n++){
	totalArea += getResult("Area",n);   // Add the area of the current result to the total
}

// Get the calibration information from ImageJ and store into width, height, depth, and unit variables. 
// We will only be using depth and unit
 
getVoxelSize(width, height, depth, unit);

// Calculate the volume by multiplying the sum of area of each slice by the depth
volume = totalArea*depth;

// Print the result of the volume calculation to the log
// print(Point[i]+"\t"+volume + " " + unit + "^3");
   
 title1 = "Ttitle"; 
title2 = "["+title1+"]"; 
f=title2; 

if(i==0){
run("New... ", "name="+title2+" type=Table"); 
print(f,"\\Headings:Cell\tVolume"); }

//then add a line of data output to that table by: 
print(f,i+"\t"+volume); 

}