%%Isolated nuclei

%%Load the relevant parameters

clear all
close all
warning off

%check for parpool workers, if a pool is here, then don't create one
delete(gcp('nocreate')); % If no pool, do not create new one.
parpool(6);

%relevant parameters
cutOffValue = 4 ; % Value of cutoff, 1/4 of the width, 1/10 etc...
px = 0.987; %m/px 
height_channel= 3.2; %m
fps = 1000;
%maxTrackTime = 3000;
minTrackTime = 50 ;

crop_width = 120;
crop_height = 60;

%last structure needed and Ntrack to increment the cell #
summary=struct;
trackNumber = 0;

%%Load the files (if image sequence)
start_path = 'F:\'; 
topLevelFolder = uigetdir(start_path);
if topLevelFolder == 0
    return;
end
fprintf('The top level folder is "%s".\n', topLevelFolder);

% Specify the file pattern.
% Get ALL files using the pattern *.*
% Note the special file pattern.  It has /**/ in it if you want to get files in subfolders of the top level folder.
% filePattern = sprintf('%s/**/*.m; %s/**/*.xml', topLevelFolder, topLevelFolder);

filePattern1 = sprintf('%s/**/*.xml', topLevelFolder);
allTrackInfo = dir(filePattern1);

filePattern2 = sprintf('%s/**/*.tif', topLevelFolder);
allMovieInfo = dir(filePattern2);

% Throw out any folders.  We want files only, not folders.
isFolderTrack = [allTrackInfo.isdir]; % Logical list of what item is a folder or not.
isFolderMovie = [allMovieInfo.isdir];
% Now set those folder entries to null, essentially deleting/removing them from the list.
allTrackInfo(isFolderTrack) = [];
allMovieInfo(isFolderMovie) = [];
% Get a cell array of strings.  We don't really use it.  I'm just showing you how to get it in case you want it.
listOfFolderTrack = unique({allTrackInfo.folder});
numberOfFoldersTrack = length(listOfFolderTrack);

listOfFolderMovies = unique({allMovieInfo.folder});
numberOfFoldersMovie = length(listOfFolderMovies);
%     fprintf('The total number of folders to look in is %d.\n', numberOfFolders);

% Get a cell array of base filename strings.  We don't really use it.
%I'm just showing you how to get it in case you want it.
listOfFileNamesTracks = {allTrackInfo.name};
%listOfFileNamesMovies = {allMovieInfo.name};

totalNumberOfTracks = length(listOfFileNamesTracks);
%totalNumberOfMovies = length(listOfFileNamesMovies);
fprintf('The total number of files in those %d folders is %d.\n', ...
    numberOfFoldersTrack, totalNumberOfTracks);

% Classify the filenames by movie (1 cell = 1 movie)
allMoviesToUse = cellfun(@(x)dir(sprintf('%s/*.tif',x)), listOfFolderMovies,'UniformOutput',false);


%%Segmentation part
%warning off
if totalNumberOfTracks >= 1 % Verify that we have a track, else, return an error message
    for k = 1 :totalNumberOfTracks % Loop over all # of tracks/movies
        % Go through all those files.
        
        
        %     parfor j = 1:size(allMovies{i},1)
        %         filename = fullfile(allMovies{i}(j).folder, allMovies{i}(j).name);
        %          I = Tiff(filename,'r');
        %          Stack(:,:,j) = read(I);
        %          close(I);
        %     end
        
        % Loads the tracks files
        TrackFolder = allTrackInfo(k).folder;
        thisTrackFileName = allTrackInfo(k).name;
        TrackfullFileName = fullfile(TrackFolder, thisTrackFileName);
        clipZ = true; % Remove Z coordinates, if you know you can.
        Tracks = importTrackMateTracks(TrackfullFileName,clipZ);
        
        
        % Load the first image of k-me movie and initialize the segmentation array
%         warning off
%         firstImgMovieFolder = allMoviesToUse{k}(1).folder;
%         firstImgMovieFilename = allMoviesToUse{k}(1).name;
%         firstImgMovieFullFilename= fullfile(firstImgMovieFolder, firstImgMovieFilename);
%         
%         firstImg = Tiff(firstImgMovieFullFilename, 'r');
%         reader = read(firstImg);
%         
%         Stack = zeros(size(reader,1),size(reader,2),size(allMoviesToUse{k},1),'uint8');
%         close(firstImg)
%         clear reader
%         
%         parfor d = 1:size(Stack,3) %create a stack of all ze images
%             warning off
%             xImgMovieFolder = allMoviesToUse{k}(d).folder;
%             xImgMovieFilename = allMoviesToUse{k}(d).name;
%             xImgMovieFullFilename= fullfile(xImgMovieFolder, xImgMovieFilename);
%             
%             xImg = Tiff(xImgMovieFullFilename, 'r');
%             Stack(:,:,d) = read(xImg);
%             close(xImg);
%         end
        
        % read and split the folder of the movie name
        thisMovieFolder = split(allMoviesToUse{k}(1).folder,"\");
      
        
        
        for i=1:numel(Tracks) % at ime track inside movie nK
            x_init = Tracks{i}(1,2);
            x_final = Tracks{i}(end,2);
            
            delta = abs(x_final-x_init);
            if delta<100 || size(Tracks{i},1)<= minTrackTime % skip movies too long or too small
                continue
            end
            tic;
            warning off
            % initialize the arrays we need
            timeStop = size(Tracks{i},1);
            
            frame = zeros(timeStop,1);
            time = zeros(timeStop,1);
            intensity = zeros(timeStop,1);
            intensity_volume = zeros(timeStop,1);
            area = zeros(timeStop,1);
            volume_micron = zeros(timeStop,1);
            e = zeros(timeStop,1);
            e_norm = zeros(timeStop,1);
            h = zeros(timeStop,1);
            h_norm = zeros(timeStop,1);
            
            MajorAxis = zeros(timeStop,1);
            MinorAxis = zeros(timeStop,1);
            Circularity = zeros(timeStop,1);
            %Perimeter = zeros(timeStop,1);
            
            posX = zeros(timeStop,1);
            posY = zeros(timeStop,1);
            velocity= zeros(timeStop-1,1);
            Vx=zeros(timeStop-1,1);
            Vy=zeros(timeStop-1,1);
            
            fprintf('%s :',cell2mat(thisMovieFolder(end)));
            parfor j=1:size(Tracks{i},1) %at One time point T
                warning off
                timeIndex = Tracks{i}(j,1)+1 ;
                
                
                % retrieve at time T the image to be analyzed
                thisMovieFilename = fullfile(allMoviesToUse{k}(timeIndex).folder, allMoviesToUse{k}(timeIndex).name);
                I = Tiff(thisMovieFilename,'r');
                Img = read(I);
                close(I);

                %Img = Stack(:,:,timeIndex);
                % Centroids and relevant parameters to calculate the mask
                x_center = Tracks{i}(j,2);
                y_center = Tracks{i}(j,3);
                
                height= size(Img,1);
                width=size(Img,2);
                
                % prevent us from taking the first value sticking to the
                % edge of the image
                Track_CutOff = width ./cutOffValue;
                
                if x_center<=Track_CutOff
                    continue;
                end
                frame(j) = timeIndex;
                
                x_min = round(max(x_center - 6,0))+1;
                x_max = round(min(x_center + 6,width-1))+1;
                y_min = round(max(y_center - 6,0))+1;
                y_max = round(min(y_center + 6,height-1))+1;
                
                % here we will crop around the image
                cropX_min = round(max(x_center - 60,0))+1;
                cropY_min = round(max(y_center - 30,0))+1;
                
                
                %Create a mask
                mask = zeros(height,width);
                mask(y_min:y_max,x_min:x_max) = 1;
                
                %Crop around the image just so that we can calculate faster
                %with active contours
                ImgCrop = imcrop(Img,[cropX_min cropY_min crop_width crop_height]);
                maskCrop = imcrop(mask,[cropX_min cropY_min crop_width crop_height]);
                
                seg = region_seg(ImgCrop, maskCrop,200); %-- Run segmentation
       
                % Region props
                labelBlob = bwlabel(seg);
                props = regionprops(labelBlob,ImgCrop, 'PixelValues','Area','BoundingBox',...
                    'MajorAxisLength','MinorAxisLength');
                if isempty(props)
                    continue
                end
                Max_Area = 0;
                IdxMax = 0;
                
                for CptS = 1:numel(props)
                    if props(CptS).Area>Max_Area
                        Max_Area = props(CptS).Area;  % Max Area
                        IdxMax = CptS; %id of the box from Max Area
                    end
                end
                    
                thisBlobsValues = props(IdxMax).PixelValues; % retrieve the pixel value at each pixel
                intensity(j) = sum(thisBlobsValues); % total intensity of the blob
                
                e(j) =            props(IdxMax).BoundingBox(3);
                h(j) =            props(IdxMax).BoundingBox(4);
                area(j)=          props(IdxMax).Area;
                MajorAxis(j) =    props(IdxMax).MajorAxisLength;
                MinorAxis(j) =    props(IdxMax).MinorAxisLength;
                Circularity(j) =  MajorAxis(j)./MinorAxis(j);
                %Perimeter(j) =    props(IdxMax).Perimeter;
                
                posX(j) =        x_center;
                posY(j) =        y_center;
            end % end of parallel loop
            % Faire une courbe moyenne intensit & volume
   % Clock to see how much time it takes to calculate 1 track
            
            Tend = toc;
            
            trackNumber = trackNumber +1; % increment to get ntrack right
            
            fprintf('Track %i done in %4.3f seconds.\n',trackNumber,Tend);
            
            %search for the first frame where we have the full nucleus
            firstFrame = find(frame,1);

            
            for ix = firstFrame:size(e)
                e_norm(ix) = (e(ix)-e(firstFrame))/e(firstFrame);
                time(ix) = (frame(ix)-frame(firstFrame))./(fps); %relative time
                h_norm(ix) = (h(ix)-h(firstFrame))/h(firstFrame);
                volume_micron(ix) = area(ix)*px*px*height_channel;
                intensity_volume(ix) = intensity(ix)./volume_micron(ix)...
                .*volume_micron(firstFrame)./intensity(firstFrame); % I(t)/V(t)*V(t=50)/I(t=50)
            end
            
            
            for il = firstFrame:size(Vx)
                Vx(il) = px*( posX(il+1) - posX(il))/ (time(il+1)-time(il));
                Vy(il) = px*( posY(il+1) - posY(il))/ (time(il+1)-time(il));
                velocity(il) = sqrt( Vx(il)^2 + Vy(il)^2);
            end
            
            %mySumName = split(TrackFolder,"\");
            numbering = sprintf('%0*.f',6,trackNumber);
            summary.(strcat('Track_',num2str(numbering))).movie = thisMovieFolder(end);%strcat(thisMovieFolder(end-1),thisMovieFolder(end));
            summary.(strcat('Track_',num2str(numbering))).frame = frame(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).time = time(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).e = e(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).e_norm = e_norm(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).h = h(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).h_norm = h_norm(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).area_px = area(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).volume = volume_micron(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).intensity_total = intensity(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).intensity_volume = intensity_volume(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).MajorAxis_px = MajorAxis(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).MinorAxis_px = MinorAxis(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).AspectRatio = Circularity(firstFrame:end);
            %summary.(strcat('Track_',num2str(numbering))).Perimeter = Perimeter;
            summary.(strcat('Track_',num2str(numbering))).Xcenter= posX(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).Ycenter = posY(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).Vx = Vx(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).Vy = Vy(firstFrame:end);
            summary.(strcat('Track_',num2str(numbering))).removedTracksuppto = delta;
            summary.(strcat('Track_',num2str(numbering))).removedTrackinfto = minTrackTime;


        end
        %clear Stack %segStack
    end % end of loop around all the availables  #tracks
else
    fprintf('     Folder %s has no files in it.\n', topLevelFolder); % error if can't find the track files
end

     SaveMe = ([topLevelFolder, '\summary_' char(thisMovieFolder(end-2)) '_'...
         char(thisMovieFolder(end-1)) '.mat']);
    save(SaveMe,'summary');
    
    notifyMe;
