%% Calculate lenght of protrusion
%% Relevant parameters
%%
clear all
close all
clc

%% Parameters dependant of the 
px = 0.483 ; %m/px for cells (depends on 
%px = 0.987; %m/px for nuclei
fps = 500; % change here for each sub-folder
height= 6; %m


%% Load the files
%%
% Ask user to confirm the folder, or change it.
% uiwait(msgbox('Pick a starting folder on the next window that will come up.'));
start_path = 'E:\'; % Folder of the hardDisk
topLevelFolder = uigetdir(start_path);
if topLevelFolder == 0
    return;
end
fprintf('The top level folder is "%s".\n', topLevelFolder);

% Specify the file pattern.
% Get ALL files using the pattern *.*
% Note the special file pattern.  It has /**/ in it if you want
% to get files in subfolders of the top level folder.
% filePattern = sprintf('%s/**/*.m; %s/**/*.xml', topLevelFolder,...
% topLevelFolder);

fileSeg = sprintf('%s/**/*seg.tif', topLevelFolder);
allSegInfo = dir(fileSeg);

% Throw out any folders.  We want files only, not folders.
isFolderSeg = [allSegInfo.isdir]; %

allSegInfo(isFolderSeg) = [];

% Get a cell array of strings.  We don't really use it.
% I'm just showing you how to get it in case you want it.
listOfFolder_Seg = unique({allSegInfo.folder});
numberOfFolders_Seg = length(listOfFolder_Seg);

% Get a cell array of base filename strings.  We don't really use it.
%I'm just showing you how to get it in case you want it.

listOfFileNames_Seg = {allSegInfo.name};
totalNumberOfFiles_Seg = length(listOfFileNames_Seg);
fprintf('The total number of files in those %d folders is %d.\n', ...
    numberOfFolders_Seg, totalNumberOfFiles_Seg);

% Process all files in those folders.
totalNumberOfFiles_Seg = length(allSegInfo);

%% Loop to calculate the masks
%%
% Now we have a list of all files, matching the pattern, in the top level
% folder and its subfolders.

if totalNumberOfFiles_Seg >= 1
    
    masks = struct;
    
    for k = 1 : totalNumberOfFiles_Seg % we only want if segmented
        % Go through all those files.
        
        thisFolder = allSegInfo(k).folder;
        
        % In the corresponding folder find the MED image
        fileMed = sprintf('%s/**/MED*.tif', thisFolder);
        allMedInfo = dir(fileMed);
        
        % Full file names of both Segmented stack and median image
        thisBaseFileName_Seg = allSegInfo(k).name;
        thisBaseFileName_Med = allMedInfo.name;
        
        fullFileName_Seg = fullfile(thisFolder, thisBaseFileName_Seg);
        fullFileName_Med = fullfile(thisFolder, thisBaseFileName_Med);
        
        %Open the images
        % Stack = ReadTiffStack(fullFileName_Seg);
        Med_Im = imread(fullFileName_Med);
        
        %Create the 2 masks
        
        imshow(Med_Im,'InitialMagnification',300);
        set(gcf,'name', [char(thisBaseFileName_Seg(1:end-8)) '/'...
            char(allSegInfo(end).name(1:end-8))], 'numbertitle','off')%('random')%]
        
        roi = drawpoint('StripeColor','y');
        
        % fprintf(strcat(fullFileName_Med(end-11:end),fullFileName_Seg(end-11:end)));
        
        Mask1 = zeros(size(Med_Im,1),size(Med_Im,2));
        Mask2 = zeros(size(Med_Im,1),size(Med_Im,2));
        
        Mask1(:,ceil(roi.Position(1)):size(Med_Im,2)) = 1;
        Mask2(:,1:ceil(roi.Position(1))) = 1;
        
        masks.([thisBaseFileName_Seg(1:end-8)]).mask_inside  = Mask1;
        masks.([thisBaseFileName_Seg(1:end-8)]).mask_outside = Mask2;
    end
else
    fprintf('     Folder %s has no files in it.\n', thisFolder);
end

close all;
%% Loop to calculate the parameters
%%
in_out_summary = struct;

if totalNumberOfFiles_Seg >= 1
    for k = 1 : totalNumberOfFiles_Seg % we only want if segmented
        
        % Go through all those files.
        thisFolder = allSegInfo(k).folder;
        thisBaseFileName_Seg = allSegInfo(k).name;
        fullFileName_Seg = fullfile(thisFolder, thisBaseFileName_Seg);
        
        %Open the images
        Stack = ReadTiffStack(fullFileName_Seg);
        
        startAt = 1;
        stopAt = size(Stack,3);
        
        % Progress bar
        textprogressbar([thisBaseFileName_Seg(1:end-8),' : ']);
        
        L_in=zeros(stopAt,1); %lenght
        L_out=zeros(stopAt,1);
        A_in = zeros(stopAt,1); %area inside channel
        A_out = zeros(stopAt,1); %area outside channel
        V_in = zeros(stopAt,1); %Volume inside
        V_out = zeros(stopAt,1); %volume outside
        %         Pe_in = zeros(stopAt,1); %Perimeter inside
        %         Pe_out = zeros(stopAt,1); %Perimeter outside
        %         R_c = zeros(stopAt,1); %rayon de courbure
        time=zeros(stopAt,1);
        frame=zeros(stopAt,1);
        
        
        for i = startAt:stopAt %for 1 movie, for each timepoints
            
            BW_in = double(Stack(:,:,i)).*masks.([thisBaseFileName_Seg(1:end-8)]).mask_inside;
            BW_out = double(Stack(:,:,i)).*masks.([thisBaseFileName_Seg(1:end-8)]).mask_outside;
            
            % BW = bwareaopen(BW,BWOpen);
            %     imshow(BW);
            % %     hold on;
            
            
            %Measure properties of image regions, find the biggest object
            
            S_in = regionprops(BW_in,'Area','PixelIdxList','BoundingBox','Centroid','Perimeter');
            Max_Area_in = 0;
            IdxMax_in = 0;
            
            S_out = regionprops(BW_out,'Area','PixelIdxList','BoundingBox','Centroid',...
                'Orientation', 'MajorAxisLength', 'MinorAxisLength','Perimeter');
            Max_Area_out = 0;
            IdxMax_out = 0;
            
            for CptS = 1:numel(S_in)
                if S_in(CptS).Area>Max_Area_in
                    Max_Area_in = S_in(CptS).Area;  % Max Area
                    IdxMax_in = CptS; %id of the box from Max Area
                end
            end
            
            for CptS = 1:numel(S_out)
                if S_out(CptS).Area>Max_Area_out
                    Max_Area_out = S_out(CptS).Area;  % Max Area
                    IdxMax_out = CptS; %id of the box from Max Area
                end
            end
            
            % Properties of the cell inside the channel
            % If the frame is empty put all the properties to zero
            if numel(S_in)>0
                bb_in = S_in(IdxMax_in).BoundingBox;
                
                A_in(i) = S_in(IdxMax_in).Area*px*px;
                V_in(i) = A_in(i)*px;
                L_in(i) = bb_in(3)*px;
                %                 Pe_in(i) = S_in(IdxMax_in).Perimeter*px;
                frame(i) = i;
                time(i)= i.*(1/fps);
                
            else
                A_in(i) = 0;
                L_in(i) = 0;
                V_in(i) = 0;
                %                 Pe_in(i) = 0;
                frame(i) = i;
                time(i)= i.*(1/fps);
            end
            
            % Properties of the cell outside the channel
            % If the frame is empty put all the properties to zero
            if numel(S_out)>0
                bb_out = S_out(IdxMax_out).BoundingBox;
                
                A_out(i) = S_out(IdxMax_out).Area*px*px;
                V_out(i) = A_out(i)*height;
                L_out(i) = bb_out(3)*px;
                %                 Pe_out(i)= S_out(IdxMax_out).Perimeter*px;
                %                 R_c(i)= S_out(IdxMax_out).MajorAxisLength*px;
                frame(i) = i;
                time(i)= i.*(1/fps);
                
                % check RC /!\ NOT READY YET
                %                 phi = linspace(0,2*pi,50);
                %                 cosphi = cos(phi);
                %                 sinphi = sin(phi);
                %
                %                 xCenter = S_out(IdxMax_out).Centroid(1);
                %                 yCenter = S_out(IdxMax_out).Centroid(2);
                %
                %
                %                 a = S_out(IdxMax_out).MajorAxisLength/2;
                %                 b = S_out(IdxMax_out).MinorAxisLength/2;
                %
                %                 theta = pi*S_out(IdxMax_out).Orientation/180;
                %                 R = [ cos(theta)   sin(theta)
                %                     -sin(theta)   cos(theta)];
                %
                %                 xy = [a*cosphi; b*sinphi];
                %                 xy = R*xy;
                %
                %                 x = xy(1,:) + xCenter;
                %                 y = xy(2,:) + yCenter;
                %
                %                 plot(x,y,'r','LineWidth',2);
                %
                
            else
                A_out(i) = 0;
                L_out(i) = 0;
                V_out(i)=0;
                %                 Pe_out(i)=0;
                %                 R_c(i)=0;
                frame(i) = i;
                time(i)= i.*(1/fps);
            end
            
            textprogressbar((i*100)/stopAt);
            %disp([num2str(i) '/' num2str(stopAt)]);
        end
        
        textprogressbar(' done');
        
        mySumName = split(thisFolder,"\");
        %in_out_summary.(char(mySumName(end))).A_in = A_in;
        %in_out_summary.(char(mySumName(end))).A_out = A_out;
        in_out_summary.(char(mySumName(end))).V = V_in+V_out;
        %         in_out_summary.(char(mySumName(end))).V_in = V_in;
        %         in_out_summary.(char(mySumName(end))).V_out = V_out;
        in_out_summary.(char(mySumName(end))).L_in = L_in;
        in_out_summary.(char(mySumName(end))).L_out = L_out;
        in_out_summary.(char(mySumName(end))).L = L_in+L_out;
        %in_out_summary.(char(mySumName(end))).Pe_in = Pe_in;
        %in_out_summary.(char(mySumName(end))).Pe_out = Pe_out;
        %in_out_summary.(char(mySumName(end))).R_c = R_c;
        in_out_summary.(char(mySumName(end))).frame = frame;
        in_out_summary.(char(mySumName(end))).time = time;
        
    end
else
    fprintf('     Folder %s has no files in it.\n', thisFolder);
end


SaveMe = ([topLevelFolder, '\in_out_summary_' char(mySumName(end-2)) '_'...
    char(mySumName(end-1)) '.mat']);
save(SaveMe,'in_out_summary');