# Notes


## Data:

> We compiled a lexical database comprising roughly 1200 cognates for Swadesh 100-
> word-list terms in 30 extant and 5 archaic Mayan languages. Word form and cognacy
> judgements were made on the basis of multiple sources (Deinhart, 1989; Kaufman, 2003;
> Boot, 2002; Hernandez, 1929; de Coto, 1983) and checked to ensure the accuracy and
> reliability of the data.

> For analysis, data were coded in a binary matrix representing the presence (1) or
> absence (0) of cognate sets in each language, with missing data also coded (?).
> Ch'olti' was excluded from the analyses due to poor sampling (86% missing data).

## Methods:

| Model                                | Score    | Program         | Comment            |
|--------------------------------------|----------|-----------------|--------------------|
| restriction site model               |          | MrBayes (3.1.1) |                    |
| dating                               |          | r8s 1.7         |                    |
| Stochastic Dollo                     |          | Traitlab        |                    |
| Phylogeography ASR                   |          | MacClade        |                    |
| Consensus Network                    |          | SplitsTree      |                    |
|                                      |          |                 |                    |



## Analysis:

> Both analyses were run for 1.3 million generations sampling every 1,000 trees. A
> ‘burn-in’ period of 300,000 trees for each run was used to avoid sampling trees
> before the run had reached convergence.
