/*
TBA: 

mental health: sempre gv_health
objective health measures: maxgrip or bmi
manager/white/blu collar
ho037
*/
qui {
	* Table Options 
	#delimit;
	local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
							label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
	local varlabelling varlabel(
							_cons 							"Intercept"
							age 							"Age"
							agec2 							"Age$^2$"
							agec3 							"Age$^3$"
							low_education                  "Low educ." 
							couple                         "Couple" 
							children                       "Children" 
							bad_health                     "Bad health" 
							big5_extra                     "Extraversion" 
							big5_agree                     "Agreeableness" 
							big5_consc                     "Conscientiousness" 
							big5_neuro                     "Neuroticism" 
							big5_open                      "Openness" 
							bad_numeracy                   "Low numeracy" 
							recall                         "Recall" 
							fluency                        "Fluency" 
							partime                        "Part-time" 
							selfemployed                   "Self-employed" 
							jobpc                          "Use PC" 
							public                         "Public sector" 
							area1                          "French-German" 
							area2                          "North " 
							area4                          "East " 
							sector1 "Agriculture    "
							sector2 "Mining    "
							sector3 "Manufacturing    "
							sector4 "Utilities    "
							sector5 "Construction    "
							sector6 "Wholesale and retail trade "
							sector7 "Hotels and restaurants  "
							sector8 "Transport, storage and communication "
							sector9 "Financial intermediation   "
							sector10 "Real estate, renting and business"
							sector11 "Public administration and defence; comp"
							sector12 "Education    "
							sector13 "Health and social work "
							sector14 "Other community, social and personal"
							Prediction_1					"Pr(M)"
							Prediction_2					"Pr(W)"
							Difference						"Pr(M)-Pr(W)"
                              
					);
	local tableopt1 "replace style(tex) c(b(star fmt(4)) se(par fmt(4)))
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("n" "k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";

	local tableopt2 "replace style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4}) 
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("n" "k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";
	#delimit cr
				    
	cap log close
	

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"partime selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"swability public"; 
	local ability			"jobpc";
	#delimit cr
	local eligible	empl_0c==1 
	foreach Y in u_1c dec_hoursw_1c inc_hoursw_1c wfh {
		reg `Y' 		`mincer' `family' `health' `big5' `cognitive' `job_u_1c' `ability' `sector' `country_d'	female if `eligible' `peso' 
		replace `Y'=. if e(sample)==0
	}

	
	/*************************************
	Some unemployment spell during Covid
	*************************************/
	cap log close
	log using "${results}/numero_uomini.tex",replace text
	count if female==0
	noi di %9.0fc r(N)
	log close
	log using "${results}/numero_donne.tex",replace text
	count if female==1
	noi di %9.0fc r(N)
	log close
	
	
	* Test per tavola
	local basic 		"u_1c dec_hoursw_1c inc_hoursw_1c wfh `mincer' `family' `health' `big5' `cognitive' `job_u_1c' `ability' `sector'"
	cap mat drop descrittive
	foreach skb of local basic {
		ttest `skb',by(female)
		mat descrittive=nullmat(descrittive) \ r(mu_1),r(mu_2),r(mu_1)-r(mu_2),r(p) \ r(sd_1),r(sd_2),r(se),.
	}
	clear
	svmat descrittive
	gen var=""
	local nrow=1
	foreach skb of local basic {
		replace var="`skb'" in `nrow'
		local nrow=`nrow' + 2
	}
	format descrittive? %9.3f
	gen stelle=irecode(descrittive4,.01,.05,.1)
	replace stelle=999 if stelle==.
	label define stelle 0 "***" 1 "*" 2 "**" 3 "" 999 ""
	label value stelle stelle
	tostring descrittive? ,replace force use
	replace descrittive1 = "("+ descrittive1  + ")" if mod(_n,2)==0
	replace descrittive2 = "("+ descrittive2  + ")" if mod(_n,2)==0
	replace descrittive3 = "("+ descrittive3  + ")" if mod(_n,2)==0
	ren descrittive1 men
	ren descrittive2 women
	ren descrittive3 diff
	order var men women dif stelle
	drop descrittive4
replace var="Job interruption" if var=="u_1c" 
replace var="Increased hours" if var=="inc_hoursw_1c" 
replace var="Decreased hours" if var=="dec_hoursw_1c"
replace var="Worked remotely" if var=="wfh" 
replace var="Age" if var=="age"
replace var="Age$^2$" if var=="agec2"
replace var="Age$^3$" if var=="agec3"
replace var="Low educ." if var=="low_education"
replace var="Couple" if var=="couple"
replace var="Children" if var=="children"
replace var="Bad health" if var=="bad_health"
replace var="Extraversion" if var=="big5_extra"
replace var="Agreeableness" if var=="big5_agree"
replace var="Conscientiousness" if var=="big5_consc"
replace var="Neuroticism" if var=="big5_neuro"
replace var="Openness" if var=="big5_open"
replace var="Low numeracy" if var=="bad_numeracy"
replace var="Recall" if var=="recall"
replace var="Fluency" if var=="fluency"
replace var="Part-time" if var=="partime"
replace var="Self-employed" if var=="selfemployed"
replace var="Use PC" if var=="jobpc"
replace var="Public sector" if var=="public"
replace var="Potentially remote" if var=="swability"
replace var="Central" if var=="area1"
replace var="North " if var=="area2"
replace var="East " if var=="area4"
replace var="Agriculture    " if var=="sector1"
replace var="Mining    " if var=="sector2"
replace var="Manufacturing    " if var=="sector3"
replace var="Utilities    " if var=="sector4"
replace var="Construction    " if var=="sector5"
replace var="Wholesale and retail trade " if var=="sector6"
replace var="Hotels and restaurants  " if var=="sector7"
replace var="Transport, storage and communication " if var=="sector8"
replace var="Financial intermediation   " if var=="sector9"
replace var="Real estate, renting and business" if var=="sector10"
replace var="Public administration and defence; comp" if var=="sector11"
replace var="Education    " if var=="sector12"
replace var="Health and social work " if var=="sector13"
replace var="Other community, social and personal" if var=="sector14"
gen fine ="\\"
gen v2=_n
recode v2 (43=35.1) (44=36.1) (35=39.1) (36=40.1) (39=43.1) (40=44.1)
sort v2
drop v2
outsheet using "${results}/descrittive.tex",replace delimit(&) nonames noquote


}

qui {
				    
/**************************************
descrittive settori
**************************************/
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2
* https://www.my-personaltrainer.it/bmi.htm
gen low_weight=bmi<18.5														if bmi<.
gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
gen high_weight=inrange(bmi,25,29.99)										if bmi<.
gen obese_weight=inrange(bmi,30,100)										if bmi<.

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)

collapse (mean) sector*,by(female)
drop sector
reshape long sector,i(female) j(index)
reshape wide sector,j(female) i(index)
#delimit ;
label define index
1 "Agriculture     "
2 "Mining     "
3 "Manufacturing     "
4 "Utilities     "
5 "Construction     "
6 "Wholesale and retail trade  "
7 "Hotels and restaurants   "
8 "Transport, storage and communication  "
9 "Financial intermediation    "
10 "Real estate, renting and business "
11 "Public administration and defence; comp "
12 "Education     "
13 "Health and social work  "
14 "Other community, social and personal ", modify
;
#delimit cr;
label value index index
replace sector0=sector0*100
replace sector1=sector1*100
format sector? %9.1f
gen fine ="\cr"
outsheet using "${results}/descrittive_settori.tex",replace delimit(&) nonames noquote


}

qui{
/**************************************
descrittive paesi
**************************************/
use "${data}\standard_covid" if interview_both==1, replace
gen uno=1
collapse (sum) uno,by(country)
format uno %9.0f
gen fine ="\cr"
outsheet using "${results}/descrittive_paesi.tex",replace delimit(&) nonames noquote
}

