qui{
cap log close
log using "${results}/descrittive_attrition_banca", t replace
use "${data}\standard",replace
merge 1:1 mergeid using "${data}\covid", replace update 
drop if country==11
recode _merge (2=2 "Refreshment sample") (3=0 "No") (1=1 "Yes"),gen(attrition)
tab attrition female if attrition!=2,col nof
keep if attrition!=2
noi di in red "Questi sono i numeri dell'attrition"
tab attrition,gen(dummy)
/*Total*/
preserve
collapse (mean) dummy*
format * %9.3f
gen female=3
label define female 0 Male 1 Female 3 Total
label values female female
order female
save attrition,replace
restore

/*Gender*/
preserve
collapse (mean) dummy*,by(female)
label define female 0 Male 1 Female 3 Total
label values female female
format * %9.3f
append using attrition
gen fine="\cr"
outsheet female dummy1 dummy2 fine using "${results}/descriptives_attrition.tex" , replace delimit(&) nonames noquote
restore





gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2
* https://www.my-personaltrainer.it/bmi.htm
gen low_weight=bmi<18.5														if bmi<.
gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
gen high_weight=inrange(bmi,25,29.99)										if bmi<.
gen obese_weight=inrange(bmi,30,100)										if bmi<.
gen age2=age^2
qui tab macroreg, gen(area)

#delimit;
// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
local mincer			"age age2 low_education";  
local country_d			"i.macroreg";
local family			"couple children";
*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
local health 			"bad_health";
local cognitive			"bad_numeracy recall fluency";
local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
local job_u_1c			"partime selfemployed";
*local job_u_spell_1c	"public selfemployed"; 
*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
*local sector 			"swability public"; 
local ability			"jobpc";
#delimit cr
local basic 		"`mincer' `family' `big5' `cognitive' `country_d'"

noi di "L'attrition NON è sistematica"
reg attrition `basic' , robust
est store attrition_tot
reg attrition `basic' if female==0
est store attrition_male
reg attrition `basic' if female==1
est store attrition_female

* Table Options 
#delimit;
local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
						label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
local varlabelling varlabel(
						_cons 							"Intercept"
						age 							"Age"
						age2 							"Age$^2$"
						agec 							"Age"
						agec2 							"Age$^2$"
						agec3 							"Age$^3$"
						low_education                  "Low educ." 
						couple                         "Couple" 
						children                       "Children" 
						bad_health                     "Bad health" 
						big5_extra                     "Extraversion" 
						big5_agree                     "Agreeableness" 
						big5_consc                     "Conscientiousness" 
						big5_neuro                     "Neuroticism" 
						big5_open                      "Openness" 
						bad_numeracy                   "Low numeracy" 
						recall                         "Recall" 
						fluency                        "Fluency" 
						partime                        "Part-time" 
						selfemployed                   "Self-employed" 
						jobpc                          "Use PC" 
						public                         "Public sector" 
						swability						"Potentially remote"
						unsafe							"Unsafe"
						area1                          "Central" 
						area2                          "North " 
						area4                          "East " 
						sector1 "Agriculture    "
						sector2 "Mining    "
						sector3 "Manufacturing    "
						sector4 "Utilities    "
						sector5 "Construction    "
						sector6 "Wholesale and retail trade "
						sector7 "Hotels and restaurants  "
						sector8 "Transport, storage and communication "
						sector9 "Financial intermediation   "
						sector10 "Real estate, renting and business"
						sector11 "Public administration and defence; comp"
						sector12 "Education    "
						sector13 "Health and social work "
						sector14 "Other community, social and personal"
						Prediction_1					"Pr(M)"
						Prediction_2					"Pr(W)"
						Difference						"Pr(M)-Pr(W)"
                             
				);
local tableopt1 "replace style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(?.macroreg)
				starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
				`varlabelling'";

local tableopt2 "replace style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4}) 
				starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
				`varlabelling'";
#delimit cr
noi di "L'attrition NON è sistematica, ed è simile tra uomini e donne"
noi est tab attrition_tot attrition_female attrition_male ,star
noi estout  attrition_tot attrition_female attrition_male using "${results}/regressione_attrition.tex", `tableopt1' collabel(none) mlabel(none)

/***************************************
test equality of coefs across gender
***************************************/
reg attrition i.female#c.(`basic')
foreach slf in `mincer' `family' `big5' `cognitive' {
	local header_num=`header_num' +1 
	local header `header' `header_num' `slf'
	qui test [1.female#c.`slf']=[0.female#c.`slf']
	mat testing=nullmat(testing) \  `header_num',r(p)
}
clear
svmat testing
label define testing1 `header'
label value testing1 testing1
noi di "L'attrition è simile tra uomini e donne (test statistici)"
noi di "H0: la covariata ha lo stesso effetto sui due sessi"
noi l
gen head=""
replace head="Age" if testing1==1
replace head="Age$^2$" if testing1==2
replace head="Low edu." if testing1==3
replace head="Couple" if testing1==4
replace head="Children" if testing1==5
replace head="Extraversion" if testing1==6
replace head="Agreeableness" if testing1==7
replace head="Conscientiusness" if testing1==8
replace head="Neuroticism" if testing1==9
replace head="Openness" if testing1==10
replace head="Bad numeracy" if testing1==11
replace head="Recall" if testing1==12
replace head="Fuency" if testing1==13
gen fine="\cr"
format testing2 %9.3f
outsheet head testing2 fine using  "${results}/test_uomo_donna_resgressione_attrition.tex",replace noquote nonames delimit("&")
mat drop testing


log close
}
