/*
TBA: 

mental health: sempre gv_health
objective health measures: maxgrip or bmi
manager/white/blu collar
ho037
*/
qui {
	* Table Options 
	#delimit;
	local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
							label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
	local varlabelling varlabel(
							_cons 							"Intercept"
							agec 							"Age"
							agec2 							"Age$^2$"
							agec3 							"Age$^3$"
							low_education                  "Low educ." 
							couple                         "Couple" 
							children                       "Children" 
							bad_health                     "Bad health" 
							big5_extra                     "Extraversion" 
							big5_agree                     "Agreeableness" 
							big5_consc                     "Conscientiousness" 
							big5_neuro                     "Neuroticism" 
							big5_open                      "Openness" 
							bad_numeracy                   "Low numeracy" 
							recall                         "Recall" 
							fluency                        "Fluency" 
							partime                        "Part-time" 
							selfemployed                   "Self-employed" 
							jobpc                          "Use PC" 
							public                         "Public sector" 
							swability						"Potentially remote"
							unsafe							"Unsafe"
							area1                          "Central" 
							area2                          "North " 
							area4                          "East " 
							sector1 "Agriculture    "
							sector2 "Mining    "
							sector3 "Manufacturing    "
							sector4 "Utilities    "
							sector5 "Construction    "
							sector6 "Wholesale and retail trade "
							sector7 "Hotels and restaurants  "
							sector8 "Transport, storage and communication "
							sector9 "Financial intermediation   "
							sector10 "Real estate, renting and business"
							sector11 "Public administration and defence; comp"
							sector12 "Education    "
							sector13 "Health and social work "
							sector14 "Other community, social and personal"
							Prediction_1					"Pr(M)"
							Prediction_2					"Pr(W)"
							Difference						"Pr(M)-Pr(W)"
							group_1							"Pr(M)"
							group_2							"Pr(W)"
							difference						"Pr(M)-Pr(W)"
							explained						"Endowments"
							unexplained						"Coefficients"
                              
					);
	local tableopt1 "replace style(tex) c(b(star fmt(4)) se(par fmt(4)))
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("Sample size" "%k") f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";

	local tableopt2 "replace style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4})
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("Sample size" "%k") f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";
	#delimit cr
				    
	cap log close
	log using "${results}/estimates_no_age", t replace
	

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
	local country_d			"area1 area2 area4";
	local mincer			"low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"partime selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"swability public"; 
	local ability			"jobpc";
	#delimit cr

	
	/*************************************
	Some unemployment spell during Covid
	*************************************/
	local Y u_1c
	local eligible	empl_0c==1 

	* Pooled model by gender
	local basic 		"`mincer' `family' `health' `big5' `cognitive' `job_u_1c' `ability' `sector'"
	noi di _n "Data dropped due to item nonresponse (Pooled areas)" 
	forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'_noage
		reg `Y' 		agec agec2  `basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}


	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob_noage
	oaxaca `Y' 		agec agec2  `basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob
	}
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack keep(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age_short.tex", `tableopt1' unstack keep(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)

/*************************************
Reduced Hours during Covid
*************************************/
qui{
local Y dec_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'_noage
		reg `Y' 		agec agec2  `basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}


	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob_noage
	oaxaca `Y' 		agec agec2  `basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob
	}
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack keep(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age_short.tex", `tableopt1' unstack keep(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)


/*************************************
Increased Hours during Covid
*************************************/
qui{
local Y inc_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'_noage
		reg `Y' 		agec agec2  `basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}


	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob_noage
	oaxaca `Y' 		agec agec2  `basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob
	}
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack keep(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age_short.tex", `tableopt1' unstack keep(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)

/*************************************
Working from home during Covid
*************************************/
qui{
local Y wfh
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
	reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
	estimates store `Y'_pool_`ss'
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'_noage
		reg `Y' 		agec agec2  `basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}


	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob_noage
	oaxaca `Y' 		agec agec2  `basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_ob
	}
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage , `tableopt1' unstack keep(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age.tex", `tableopt1' unstack drop(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
	estout  `Y'_pool_0 `Y'_pool_0_noage `Y'_pool_1 `Y'_pool_1_noage `Y'_pool_ob `Y'_pool_ob_noage using "${results}/`Y'_no_age_short.tex", `tableopt1' unstack keep(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)

	
	
/*************************************
All together
*************************************/
#delimit;
estout 	u_1c_pool_ob u_1c_pool_ob_noage 
		inc_hoursw_1c_pool_ob inc_hoursw_1c_pool_ob_noage  
		dec_hoursw_1c_pool_ob dec_hoursw_1c_pool_ob_noage 
		wfh_pool_ob wfh_pool_ob_noage
		using "${results}/oaxaca_blinder_age_no_age_short.tex", 
		`tableopt1' unstack keep(group_? difference explained unexplained)  mlabels(,none) collabel(,none) eqlabel(,none)
;
#delimit cr;
log close



exit
esempio di SURE per b1-b0 (taella)
reg dec_hoursw_1c bad_health age int_year if female==0
est store a
reg dec_hoursw_1c bad_health age int_year if female==1
est store b
suest a b
test _b[a_mean:bad_health]=_b[b_mean:bad_health]
