	log using "${results}/figures_on_contagion_cognitive", t replace nomsg
	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
*	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"partime selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"wfh public"; 
	local ability			"jobpc";
	#delimit cr

	merge 1:1 mergeid using "${dataw8}_ca", nogen keep(3) 		///
	keepusing(cac005_1)
	gen respondent_covid=cac005_1==1 
	replace respondent_covid=. if ((cac005_1==-2) | (cac005_1==-1)) | cac005_1==.
	collapse (mean) `cognitive' `big5' `sector',by(country)
	ren country country_num
save 	"${data}\institutional\share",replace

import excel "${data}\institutional\population_overall.xlsx", sheet("Sheet 1") cellrange(A13:C45) clear
destring B,gen(population_overall) force
drop B C
save "${data}\institutional\population_overall",replace

import excel "${data}\institutional\population_percentage_5064.xlsx", sheet("Sheet 1") cellrange(A13:C45) clear
destring B,gen(population_percentage_5064) force
drop B C
merge 1:1 A using "${data}\institutional\population_overall",nogen keep(3)
ren  A country
gen population_5064=population_overall*population_percentage_5064/100
erase "${data}\institutional\population_overall.dta"
save "${data}\institutional\population",replace

import delimited "${data}\institutional\WHO-COVID-19-global-data.csv", clear 
ren *date_reported data
keep if data=="2020-06-30"
merge 1:1 country using "${data}\institutional\population", keep(3) nogen
drop new* who_region
gen share_cases=cumulative_cases / population_overall
gen share_deaths=cumulative_deaths / population_overall
collapse (mean) share_*,by(country country_code)
 gen country_num=.
 replace  country_num=11 if country_code=="AT"
 replace  country_num=12 if country_code=="DE"
 replace  country_num=13 if country_code=="SE"
 replace  country_num=14 if country_code=="NL"
 replace  country_num=15 if country_code=="ES"
 replace  country_num=16 if country_code=="IT"
 replace  country_num=17 if country_code=="FR"
 replace  country_num=18 if country_code=="DK"
 replace  country_num=19 if country_code=="GR"
 replace  country_num=20 if country_code=="CH"
 replace  country_num=23 if country_code=="BE"
 replace  country_num=25 if country_code=="IL"
 replace  country_num=28 if country_code=="CZ"
 replace  country_num=29 if country_code=="PL"
 replace  country_num=30 if country_code=="IE"
 replace  country_num=31 if country_code=="LU"
 replace  country_num=32 if country_code=="HU"
 replace  country_num=33 if country_code=="PT"
 replace  country_num=34 if country_code=="SI"
 replace  country_num=35 if country_code=="EE"
 replace  country_num=47 if country_code=="HR"
 replace  country_num=48 if country_code=="LT"
 replace  country_num=51 if country_code=="BG"
 replace  country_num=53 if country_code=="CY"
 replace  country_num=55 if country_code=="FI"
 replace  country_num=57 if country_code=="LV"
 replace  country_num=59 if country_code=="MT"
 replace  country_num=61 if country_code=="RO"
 replace  country_num=63 if country_code=="SK"
 drop if country_num==.
merge 1:1 country_num using "${data}\institutional\share"

reg share_cases bad_numeracy recall fluency big5_extra big5_agree big5_consc big5_neuro big5_open
est store cases
reg share_death bad_numeracy recall fluency big5_extra big5_agree big5_consc big5_neuro big5_open
est store death
est tab  cases death
erase "${data}\institutional\share.dta"
erase "${data}\institutional\population.dta"
log close
