qui {
	* Table Options 
				    
	cap log close
	log using "${results}/p_values_fluency_crystallized", t replace
	
	

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
*	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"public selfemployed partime";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"wfh "; 
	local ability			"jobpc";
	#delimit cr

	merge 1:1 mergeid using "${dataw8}_ca", nogen keep(3) 		///
	keepusing(cac005_1)
	gen respondent_covid=cac005_1==1 
	replace respondent_covid=. if ((cac005_1==-2) | (cac005_1==-1)) | cac005_1==.

	/*************************************
	Respondent works
	*************************************/
	local Y empl_0c
	local eligible	country!=.

	* Pooled model by gender
	local basic 		"`mincer' `family' `health' `big5' `cognitive' "
	forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}
	suest `Y'_pool_0 `Y'_pool_1
	foreach ss in bad_numeracy recall fluency {
		noi di "***********************************"
		noi di "***********************************"
		noi di "***********************************"
		noi di "H0: `ss' equal across gender"
		noi test [empl_0c_pool_1_mean]_b[`ss']=[empl_0c_pool_0_mean]_b[`ss']
	}
}
qui log close

