insheet using "${results}/estimates_banca_nonlinear_sector.tex",clear delimit("&") 
drop v11
gen indice=_n
replace v1=v1[_n-1] if v1==""
replace v2=v2[_n-1] if v2==""
egen outcome=group(v1)
rename v2 component
sort v1 component indice
by  v1 component :gen stat=_n
drop indice v1
reshape wide v3 v4 v5 v6 v7 v8 v9 v10,i(component stat) j(outcome) 
drop if component=="Obs."
reshape wide v*,i(stat) j(component) string 

tempfile tmp
preserve
keep stat v3*xplained v4*xplained
gen modello=1
save `tmp',replace
restore
preserve
keep stat v5*xplained v6*xplained
rename (v5*xplained v6*xplained) (v3*xplained v4*xplained)
gen modello=2
append using `tmp'
save `tmp',replace
restore
preserve
keep stat v7*xplained v8*xplained
rename (v7*xplained v8*xplained) (v3*xplained v4*xplained)
gen modello=3
append using `tmp'
save `tmp',replace
restore
preserve
keep stat v9*xplained v10*xplained
rename (v9*xplained v10*xplained) (v3*xplained v4*xplained)
gen modello=4
append using `tmp'
save `tmp',replace
restore

use `tmp',clear
sort modello stat
by modello: replace modello=. if _n==2
label define modello 1 "Probit & aggregate" 2 " & detail" 3 "Logit & aggregate" 4 " & detail"
label value modello modello
drop stat
format v3* %9.4f
gen fine="\\"
order modello v31Explained v41Explained v31Unexplained v41Unexplained v32Explained v42Explained v32Unexplained v42Unexplained v33Explained v43Explained v33Unexplained v43Unexplained v34Explained v44Explained v34Unexplained v44Unexplained
outsheet using "${results}/estimates_banca_nonlinear_sector_trasposta.tex",replace delimit("&") nonames noquote
