global repsboot=20
set seed 24032023
/*
TBA: 

mental health: sempre gv_health
objective health measures: maxgrip or bmi
manager/white/blu collar
*/
qui {
	* Table Options 
	#delimit;
	
	local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
							label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
	local varlabelling varlabel(
							_cons 							"Intercept"
							agec 							"Age"
							agec2 							"Age$^2$"
							agec3 							"Age$^3$"
							low_education                  "Low educ." 
							couple                         "Couple" 
							children                       "Children" 
							bad_health                     "Bad health" 
							big5_extra                     "Extraversion" 
							big5_agree                     "Agreeableness" 
							big5_consc                     "Conscientiousness" 
							big5_neuro                     "Neuroticism" 
							big5_open                      "Openness" 
							bad_numeracy                   "Low numeracy" 
							recall                         "Recall" 
							fluency                        "Fluency" 
							partime                        "Part-time" 
							selfemployed                   "Self-employed" 
							jobpc                          "Use PC" 
							public                         "Public sector" 
							swability						"Potentially remote"
							area1                          "Central" 
							area2                          "North " 
							area4                          "East " 
							sector1 "Agriculture    "
							sector2 "Mining    "
							sector3 "Manufacturing    "
							sector4 "Utilities    "
							sector5 "Construction    "
							sector6 "Wholesale and retail trade "
							sector7 "Hotels and restaurants  "
							sector8 "Transport, storage and communication "
							sector9 "Financial intermediation   "
							sector10 "Real estate, renting and business"
							sector11 "Public administration and defence; comp"
							sector12 "Education    "
							sector13 "Health and social work "
							sector14 "Other community, social and personal"
							Prediction_1					"Pr(M)"
							Prediction_2					"Pr(W)"
							Difference						"Pr(M)-Pr(W)"
                              
					);
	local tableopt1 "style(tex) c(b(star fmt(4)) se(par fmt(4)))   
					starlevel(* .1 ** .05 *** .01) stardetach    varwidth(30) 
					collab(, none) mlabel(,none)
					`varlabelling'";

	local tableopt2 "style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4})  
					starlevel(* .1 ** .05 *** .01) stardetach     varwidth(30) 
					collab(, none) mlabel(,none)
					`varlabelling'";

	#delimit cr
				    

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local job_u_1c			"public selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	*local sector 			"partime swability "; 
	local ability			"jobpc";
	#delimit cr
}
	
	/*************************************
	Analysis
	*************************************/
cap erase "${results}/estimates_banca_nonlinear_sector.tex"
foreach Y in u_1c dec_hoursw_1c inc_hoursw_1c wfh {
	noi di "**********************************************"
	noi di "`Y'"
	noi di "**********************************************"
	qui{
		local eligible	empl_0c==1 
	
		* Pooled model by gender
		local basic 		"`mincer' `family' `health' `big5' `cognitive' `job_u_1c' `ability'"
		local sec1			public selfemployed partime swability
		local sec2			partime selfemployed sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 public sector14
		/**********************************************
		"`sec1'"
		**********************************************/
		forvalues reps=1 / $repsboot {
			preserve
			bsample
			fairlie `Y' 		`basic' `country_d' `sec1' if `eligible' `peso',by(female) reference(1) probit
			mat se_probit=nullmat(se_probit) \ e(diff),e(expl),(e(diff)-e(expl))
			fairlie `Y' 		`basic' `country_d' `sec1' if `eligible' `peso',by(female) reference(1)
			mat se_logit=nullmat(se_logit) \ e(diff),e(expl),(e(diff)-e(expl))
			restore
		}
		preserve
		foreach est in probit logit {
			clear 
			svmat se_`est'
			sum se_`est'1
			local se_diff_`est'=r(sd)
			sum se_`est'2
			local se_expl_`est'=r(sd)
			sum se_`est'3
			local se_unexpl_`est'=r(sd)
			mat drop se_`est'
		}
		restore
		fairlie `Y' 		`basic' `country_d' `sec1' if `eligible' `peso',by(female) reference(1) probit //weight(1 0) => usiamo i beta da female=0
		estadd scalar unexpl=(e(diff)-e(expl))
		estadd scalar se_diff=`se_diff_probit'
		estadd scalar se_expl=`se_expl_probit'
		estadd scalar se_unexpl=`se_unexpl_probit'
		estimates store `Y'_pr_oaxaca1
	
		fairlie `Y' 		`basic' `country_d' `sec1' if `eligible' `peso',by(female) reference(1) 		//weight(1 0) => usiamo i beta da female=0
		estadd scalar unexpl=(e(diff)-e(expl))
		estadd scalar se_diff=`se_diff_logit'
		estadd scalar se_expl=`se_expl_logit'
		estadd scalar se_unexpl=`se_unexpl_logit'
		estimates store `Y'_lg_oaxaca1
		/**********************************************
		"`sec2'"
		**********************************************/
		forvalues reps=1 / $repsboot {
			preserve
			bsample
			fairlie `Y' 		`basic' `country_d' `sec2' if `eligible' `peso',by(female) reference(1) probit
			mat se_probit=nullmat(se_probit) \ e(diff),e(expl),(e(diff)-e(expl))
			fairlie `Y' 		`basic' `country_d' `sec2' if `eligible' `peso',by(female) reference(1)
			mat se_logit=nullmat(se_logit) \ e(diff),e(expl),(e(diff)-e(expl))
			restore
		}
		preserve
		foreach est in probit logit {
			clear 
			svmat se_`est'
			sum se_`est'1
			local se_diff_`est'=r(sd)
			sum se_`est'2
			local se_expl_`est'=r(sd)
			sum se_`est'3
			local se_unexpl_`est'=r(sd)
			mat drop se_`est'
		}
		restore
		fairlie `Y' 		`basic' `country_d' `sec2' if `eligible' `peso',by(female) reference(1) probit //weight(1 0) => usiamo i beta da female=0
		estadd scalar unexpl=(e(diff)-e(expl))
		estadd scalar se_diff=`se_diff_probit'
		estadd scalar se_expl=`se_expl_probit'
		estadd scalar se_unexpl=`se_unexpl_probit'
		estimates store `Y'_pr_oaxaca2
	
		fairlie `Y' 		`basic' `country_d' `sec2' if `eligible' `peso',by(female) reference(1) 		//weight(1 0) => usiamo i beta da female=0
		estadd scalar unexpl=(e(diff)-e(expl))
		estadd scalar se_diff=`se_diff_logit'
		estadd scalar se_expl=`se_expl_logit'
		estadd scalar se_unexpl=`se_unexpl_logit'
		estimates store `Y'_lg_oaxaca2
		
	}
	noi estout  `Y'_pr_oaxaca1  `Y'_pr_oaxaca2 `Y'_lg_oaxaca1  `Y'_lg_oaxaca2 using "${results}/estimates_banca_nonlinear_sector.tex", `tableopt1' `nl_stat_report' drop(`basic' `country_d') append
}
insheet using "${results}/estimates_banca_nonlinear_sector.tex",clear delimit("&") 
label define star 0 " " 1 "*" 2 "**" 3  "***",modify
gen indice=_n
gen keeping=1 if v1=="Explained"
replace keeping=keeping[_n-1]+1 if keeping==.
keep if inrange(keeping,1,5)
foreach vv in v2 v4 v6 v8 {
	gen `vv'_entry=`vv'
	destring `vv',replace force
	gen `vv'_star=`vv'[_n]/`vv'[_n+1] if v1=="Explained"|v1=="Unexplained"
	replace `vv'_star=abs(`vv'_star)
	replace `vv'_star=irecode(`vv'_star,abs(invnormal(.1/2)),abs(invnormal(.05/2)),abs(invnormal(.01/2)))
	label value `vv'_star star
	drop `vv'
}
drop v3 v5 v7 indice keeping
gen name=""
replace name="Job interruption" in 1
replace name="\hline Increased hours" in 6
replace name="\hline Decreased hours" in 11
replace name="\hline Worked remotely" in 16
order v9,last
order name,first
outsheet using "${results}/estimates_banca_nonlinear_sector.tex",replace delimit("&") nonames noquote
