global repsboot=20
/*
TBA: 

mental health: sempre gv_health
objective health measures: maxgrip or bmi
manager/white/blu collar
*/
qui {
	* Table Options 
	#delimit;
	
	local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
							label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
	local varlabelling varlabel(
							_cons 							"Intercept"
							agec 							"Age"
							agec2 							"Age$^2$"
							agec3 							"Age$^3$"
							low_education                  "Low educ." 
							couple                         "Couple" 
							children                       "Children" 
							bad_health                     "Bad health" 
							big5_extra                     "Extraversion" 
							big5_agree                     "Agreeableness" 
							big5_consc                     "Conscientiousness" 
							big5_neuro                     "Neuroticism" 
							big5_open                      "Openness" 
							bad_numeracy                   "Low numeracy" 
							recall                         "Recall" 
							fluency                        "Fluency" 
							partime                        "Part-time" 
							selfemployed                   "Self-employed" 
							jobpc                          "Use PC" 
							public                         "Public sector" 
							swability						"Potentially remote"
							area1                          "Central" 
							area2                          "North " 
							area4                          "East " 
							sector1 "Agriculture    "
							sector2 "Mining    "
							sector3 "Manufacturing    "
							sector4 "Utilities    "
							sector5 "Construction    "
							sector6 "Wholesale and retail trade "
							sector7 "Hotels and restaurants  "
							sector8 "Transport, storage and communication "
							sector9 "Financial intermediation   "
							sector10 "Real estate, renting and business"
							sector11 "Public administration and defence; comp"
							sector12 "Education    "
							sector13 "Health and social work "
							sector14 "Other community, social and personal"
							Prediction_1					"Pr(M)"
							Prediction_2					"Pr(W)"
							Difference						"Pr(M)-Pr(W)"
                              
					);
	local tableopt1 "style(tex) c(b(star fmt(4)) se(par fmt(4)))   
					starlevel(* .1 ** .05 *** .01) stardetach    varwidth(30) 
					replace collab(, none) mlabel(,none)
					`varlabelling'";

	local tableopt2 "style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4})  
					starlevel(* .1 ** .05 *** .01) stardetach     varwidth(30) 
					replace collab(, none) mlabel(,none)
					`varlabelling'";

	#delimit cr
				    
	cap log close
	log using "${results}/estimates_nonlinear", t replace
	

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"public selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"partime swability "; 
	local ability			"jobpc";
	#delimit cr
}
	
	/*************************************
	Some unemployment spell during Covid
	*************************************/
qui{
	local Y u_1c
	local eligible	empl_0c==1 

	* Pooled model by gender
	local basic 		"`mincer' `family' `health' `big5' `cognitive' `job_u_1c' `sector' `ability'"
	noi di _n "Data dropped due to item nonresponse (Pooled areas)" 
	forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
		
		probit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_pr_`ss'
		
		logit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_lg_`ss'

*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}
	noi estout  `Y'_pool_0 `Y'_pr_0 `Y'_lg_0 `Y'_pool_1 `Y'_pr_1 `Y'_lg_1 using "${results}/`Y'_nonlinear.tex", `tableopt1'  drop(_cons) 
	/********************************
	B1-B0
	********************************/
/*
	suest `Y'_pool_0 `Y'_pool_1
	foreach ofh in `basic' `country_d' {
		test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
		mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p)
	}
	preserve
	clear
	svmat delt_coefs
	gen stella=irecode(delt_coefs2,.01,.05,.1)
	label define stella 0 "***" 1 "**" 2 "*" 3 "" 
	label value stella stella
	drop delt_coefs2
	mat drop delt_coefs
	noi l // vedi
	* outsheet .....
	restore
*/
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca

	forvalues reps=1 / $repsboot {
		preserve
		bsample
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit
		mat se_probit=nullmat(se_probit) \ e(diff),e(expl),(e(diff)-e(expl))
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 
		mat se_logit=nullmat(se_logit) \ e(diff),e(expl),(e(diff)-e(expl))
		restore
	}
	preserve
	foreach est in probit logit {
		clear 
		svmat se_`est'
		sum se_`est'1
		local se_diff_`est'=r(sd)
		sum se_`est'2
		local se_expl_`est'=r(sd)
		sum se_`est'3
		local se_unexpl_`est'=r(sd)
		mat drop se_`est'
	}
	restore
	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit //weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_probit'
	estadd scalar se_expl=`se_expl_probit'
	estadd scalar se_unexpl=`se_unexpl_probit'
	estimates store `Y'_pr_oaxaca

	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 		//weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_logit'
	estadd scalar se_expl=`se_expl_logit'
	estadd scalar se_unexpl=`se_unexpl_logit'
	estimates store `Y'_lg_oaxaca
	*		estimates save "${EST}/`Y'_pool_`ss'", replace
	
	}
	noi estout  `Y'_pool_oaxaca `Y'_pr_oaxaca `Y'_lg_oaxaca using "${results}/`Y'_nonlinear_deco.tex", `tableopt1' `nl_stat_report' drop(`basic' `country_d')
	include "${dofiles}/4_1_estimates_banca_nonlinear_table"
	outsheet v1 v21 v2 v3 v4 v5 v6 v7 using "${results}/`Y'_nonlinear_deco_table.tex",replace delimit(&) nonames noquote
/*************************************
Reduced Hours during Covid
*************************************/
qui{
local Y dec_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
		
		probit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_pr_`ss'
		
		logit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_lg_`ss'

*		estimates save "${EST}/`Y'_pool_`ss'", replace
}
	noi estout  `Y'_pool_0 `Y'_pr_0 `Y'_lg_0 `Y'_pool_1 `Y'_pr_1 `Y'_lg_1 using "${results}/`Y'_nonlinear.tex", `tableopt1' drop(_cons)  

/********************************
B1-B0
********************************/
/*
suest `Y'_pool_0 `Y'_pool_1
foreach ofh in `basic' `country_d' {
	test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
	mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p)
}
preserve
clear
svmat delt_coefs
gen stella=irecode(delt_coefs2,.01,.05,.1)
label define stella 0 "***" 1 "**" 2 "*" 3 "" 
label value stella stella
drop delt_coefs2
mat drop delt_coefs
noi l // vedi
* outsheet .....
restore
*/
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca

	forvalues reps=1 / $repsboot {
		preserve
		bsample
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit
		mat se_probit=nullmat(se_probit) \ e(diff),e(expl),(e(diff)-e(expl))
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 
		mat se_logit=nullmat(se_logit) \ e(diff),e(expl),(e(diff)-e(expl))
		restore
	}
	preserve
	foreach est in probit logit {
		clear 
		svmat se_`est'
		sum se_`est'1
		local se_diff_`est'=r(sd)
		sum se_`est'2
		local se_expl_`est'=r(sd)
		sum se_`est'3
		local se_unexpl_`est'=r(sd)
		mat drop se_`est'
	}
	restore
	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit //weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_probit'
	estadd scalar se_expl=`se_expl_probit'
	estadd scalar se_unexpl=`se_unexpl_probit'
	estimates store `Y'_pr_oaxaca

	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 		//weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_logit'
	estadd scalar se_expl=`se_expl_logit'
	estadd scalar se_unexpl=`se_unexpl_logit'
	estimates store `Y'_lg_oaxaca
	*		estimates save "${EST}/`Y'_pool_`ss'", replace
	
}
noi estout  `Y'_pool_oaxaca `Y'_pr_oaxaca `Y'_lg_oaxaca using "${results}/`Y'_nonlinear_deco.tex", `tableopt1' `nl_stat_report' drop(`basic' `country_d')
include "${dofiles}/4_1_estimates_banca_nonlinear_table"
outsheet v1 v21 v2 v3 v4 v5 v6 v7 using "${results}/`Y'_nonlinear_deco_table.tex",replace delimit(&) nonames noquote

/*************************************
Increased Hours during Covid
*************************************/
qui{
local Y inc_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
		
		probit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_pr_`ss'
		
		logit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_lg_`ss'

*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}
	noi estout  `Y'_pool_0 `Y'_pr_0 `Y'_lg_0 `Y'_pool_1 `Y'_pr_1 `Y'_lg_1 using "${results}/`Y'_nonlinear.tex", `tableopt1' drop(_cons)   

	/********************************
	B1-B0
	********************************/
/*
	suest `Y'_pool_0 `Y'_pool_1
	foreach ofh in `basic' `country_d' {
		test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
		mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p)
	}
	preserve
	clear
	svmat delt_coefs
	gen stella=irecode(delt_coefs2,.01,.05,.1)
	label define stella 0 "***" 1 "**" 2 "*" 3 "" 
	label value stella stella
	drop delt_coefs2
	mat drop delt_coefs
	noi l // vedi
	* outsheet .....
	restore
*/
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca

	forvalues reps=1 / $repsboot {
		preserve
		bsample
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit
		mat se_probit=nullmat(se_probit) \ e(diff),e(expl),(e(diff)-e(expl))
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 
		mat se_logit=nullmat(se_logit) \ e(diff),e(expl),(e(diff)-e(expl))
		restore
	}
	preserve
	foreach est in probit logit {
		clear 
		svmat se_`est'
		sum se_`est'1
		local se_diff_`est'=r(sd)
		sum se_`est'2
		local se_expl_`est'=r(sd)
		sum se_`est'3
		local se_unexpl_`est'=r(sd)
		mat drop se_`est'
	}
	restore
	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit //weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_probit'
	estadd scalar se_expl=`se_expl_probit'
	estadd scalar se_unexpl=`se_unexpl_probit'
	estimates store `Y'_pr_oaxaca

	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 		//weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_logit'
	estadd scalar se_expl=`se_expl_logit'
	estadd scalar se_unexpl=`se_unexpl_logit'
	estimates store `Y'_lg_oaxaca
	*		estimates save "${EST}/`Y'_pool_`ss'", replace
	
	}
noi estout  `Y'_pool_oaxaca `Y'_pr_oaxaca `Y'_lg_oaxaca using "${results}/`Y'_nonlinear_deco.tex", `tableopt1' `nl_stat_report' drop(`basic' `country_d')
include "${dofiles}/4_1_estimates_banca_nonlinear_table"
outsheet v1 v21 v2 v3 v4 v5 v6 v7 using "${results}/`Y'_nonlinear_deco_table.tex",replace delimit(&) nonames noquote

/*************************************
Working from home during Covid
*************************************/
qui{
local Y wfh
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
		
		probit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_pr_`ss'
		
		logit `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		margin ,post dydx(`basic' `country_d') atmeans
		estimates store `Y'_lg_`ss'

*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}
	noi estout  `Y'_pool_0 `Y'_pr_0 `Y'_lg_0 `Y'_pool_1 `Y'_pr_1 `Y'_lg_1 using "${results}/`Y'_nonlinear.tex", `tableopt1' drop(_cons)     
	/********************************
	B1-B0
	********************************/
/*
	suest `Y'_pool_0 `Y'_pool_1
	foreach ofh in `basic' `country_d' {
		test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
		mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p)
	}
	preserve
	clear
	svmat delt_coefs
	gen stella=irecode(delt_coefs2,.01,.05,.1)
	label define stella 0 "***" 1 "**" 2 "*" 3 "" 
	label value stella stella
	drop delt_coefs2
	mat drop delt_coefs
	noi l // vedi
	* outsheet .....
	restore
*/
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca

	forvalues reps=1 / $repsboot {
		preserve
		bsample
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit
		mat se_probit=nullmat(se_probit) \ e(diff),e(expl),(e(diff)-e(expl))
		fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 
		mat se_logit=nullmat(se_logit) \ e(diff),e(expl),(e(diff)-e(expl))
		restore
	}
	preserve
	foreach est in probit logit {
		clear 
		svmat se_`est'
		sum se_`est'1
		local se_diff_`est'=r(sd)
		sum se_`est'2
		local se_expl_`est'=r(sd)
		sum se_`est'3
		local se_unexpl_`est'=r(sd)
		mat drop se_`est'
	}
	restore
	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) probit //weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_probit'
	estadd scalar se_expl=`se_expl_probit'
	estadd scalar se_unexpl=`se_unexpl_probit'
	estimates store `Y'_pr_oaxaca

	fairlie `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) reference(1) 		//weight(1 0) => usiamo i beta da female=0
	estadd scalar unexpl=(e(diff)-e(expl))
	estadd scalar se_diff=`se_diff_logit'
	estadd scalar se_expl=`se_expl_logit'
	estadd scalar se_unexpl=`se_unexpl_logit'
	estimates store `Y'_lg_oaxaca
	*		estimates save "${EST}/`Y'_pool_`ss'", replace
	
	}
noi estout  `Y'_pool_oaxaca `Y'_pr_oaxaca `Y'_lg_oaxaca using "${results}/`Y'_nonlinear_deco.tex", `tableopt1' `nl_stat_report' drop(`basic' `country_d')
include "${dofiles}/4_1_estimates_banca_nonlinear_table"
outsheet v1 v21 v2 v3 v4 v5 v6 v7 using "${results}/`Y'_nonlinear_deco_table.tex",replace delimit(&) nonames noquote

log close




exit
