/*
TBA: 

mental health: sempre gv_health
objective health measures: maxgrip or bmi
manager/white/blu collar
ho037
*/
qui {
	* Table Options 
	#delimit;
	local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
							label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
	local varlabelling varlabel(
							_cons 							"Intercept"
							agec 							"Age"
							agec2 							"Age$^2$"
							agec3 							"Age$^3$"
							low_education                  "Low educ." 
							couple                         "Couple" 
							children                       "Children" 
							bad_health                     "Bad health" 
							big5_extra                     "Extraversion" 
							big5_agree                     "Agreeableness" 
							big5_consc                     "Conscientiousness" 
							big5_neuro                     "Neuroticism" 
							big5_open                      "Openness" 
							bad_numeracy                   "Low numeracy" 
							recall                         "Recall" 
							fluency                        "Fluency" 
							partime                        "Part-time" 
							selfemployed                   "Self-employed" 
							jobpc                          "Use PC" 
							public                         "Public sector" 
							swability						"Potentially remote"
							unsafe							"Unsafe"
							area1                          "Central" 
							area2                          "North " 
							area4                          "East " 
							sector1 "Agriculture    "
							sector2 "Mining    "
							sector3 "Manufacturing    "
							sector4 "Utilities    "
							sector5 "Construction    "
							sector6 "Wholesale and retail trade "
							sector7 "Hotels and restaurants  "
							sector8 "Transport, storage and communication "
							sector9 "Financial intermediation   "
							sector10 "Real estate, renting and business"
							sector11 "Public administration and defence; comp"
							sector12 "Education    "
							sector13 "Health and social work "
							sector14 "Other community, social and personal"
							Prediction_1					"Pr(M)"
							Prediction_2					"Pr(W)"
							Difference						"Pr(M)-Pr(W)"
                              
					);
	local tableopt1 "replace style(tex) c(b(star fmt(4)) se(par fmt(4)))
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";

	local tableopt2 "replace style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4}) 
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";
	#delimit cr
				    
	cap log close
	log using "${results}/estimates_aggregate_decomposition", t replace
	

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"partime selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"swability public"; 
	local ability			"jobpc";
	#delimit cr

	// For detailed decomposition
	local deco_demo_indiv 	Individual_demographics:	agec agec2 low_education
	local deco_demo_family 	Family_demographics:		couple children
	local deco_health		Health:						bad_health
	local deco_big5			Non_cognitive_ability:		big5_extra big5_agree big5_consc big5_neuro big5_open 
	local deco_cognitive	Cognitive_ability:			bad_numeracy recall fluency
	local deco_job_type		Type_of_job:				`job_u_1c' public 
	local deco_job_charac	Job_characteristics:		swability jobpc
	local deco_country_d	Geographic:					area1 area2 area4

	
	* Pooled model by gender
	local basic 			"`mincer' `family' `health' `big5' `cognitive' `job_u_1c' `ability' `sector'"
	local wout_abilities	"`mincer' `family' `health' `job_u_1c' `ability' `sector'"
	local detils_cov				`deco_demo_indiv',`deco_demo_family',`deco_health',`deco_big5',`deco_cognitive',`deco_job_type',`deco_job_charac',`deco_country_d'
	local detils_cov_wout_abilities	`deco_demo_indiv',`deco_demo_family',`deco_health',`deco_job_type',`deco_job_charac',`deco_country_d'
	// Alternative decomposition
*	local detils_cov	mincer:`mincer', family:`family', health:`health', big5:`big5', cognitive:`cognitive', ability:`ability', sector:`sector', area:`country_d'

	/*************************************
	Some unemployment spell during Covid
	*************************************/
	local Y u_1c
	local eligible	empl_0c==1 
	cap mat drop tmp
	cap mat drop tmp1
	oaxaca `Y' 		`wout_abilities' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_wout_abilities')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_oaxaca_wout
	mat tmp1=r(table)
	mat tmp1=((tmp1[1,4],tmp1[3,4])\(tmp1[2,4],.)),((tmp1[1,5],tmp1[3,5])\(tmp1[2,5],.))
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca
	mat tmp=r(table)
	mat tmp=((tmp[1,4],tmp[3,4])\(tmp[2,4],.)),((tmp[1,5],tmp[3,5])\(tmp[2,5],.))
	mat tmp=tmp1,tmp
	clear
	svmat tmp
	gen Aggregate="Total" in 1
	format tmp? %9.4f
	forvalues sdoj=2(2)8 {
				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),abs(invnormal((.1/2))),abs(invnormal((.05/2))),abs(invnormal((.01/2))))
*				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),.01,.05,.1)
	}
	label define star 0 "" 1 "*" 2 "**" 3 "***"
	label value star_tmp? star
	order Aggregate tmp1 star_tmp2 tmp3 star_tmp4 tmp5 star_tmp6 tmp7 star_tmp8
	tostring star_tmp8 tmp?, use replace force
	replace star_tmp8="" if star_tmp8=="0"
	replace star_tmp8="*" if star_tmp8=="1"
	replace star_tmp8="**" if star_tmp8=="2"
	replace star_tmp8="***" if star_tmp8=="3"
	forvalues sdoj=1(2)7 {
				replace tmp`sdoj'="("+tmp`sdoj'+")" in 2
	}
	replace star_tmp8=star_tmp8+"\\" 
	replace star_tmp8="\\" in 2
	drop tmp2 tmp4 tmp6 tmp8
	outsheet using  "${results}/`Y'_aggregate_decomposition1.tex",delimit("&") replace nonames noquote
	insheet using  "${results}/`Y'_aggregate_decomposition1.tex",clear
	save tmp,replace

	}
	estout  `Y'_oaxaca_wout `Y'_pool_oaxaca using "${results}/`Y'_aggregate_decomposition.tex", `tableopt1' unstack drop(group_? difference explained unexplained)
	insheet using "${results}/`Y'_aggregate_decomposition.tex",clear
	append using tmp
	replace v1=regexr(v1,"\\","")
	replace v1=regexr(v1,"\\","\cr")
	replace v1=regexr(v1,"\_"," ")
	replace v1=regexr(v1,"\_"," ")
	drop if inlist(_n,1,2,3)
	outsheet using  "${results}/`Y'_aggregate_decomposition.tex",replace noquote nonames
	erase "${results}/`Y'_aggregate_decomposition1.tex"

/*************************************
Reduced Hours during Covid
*************************************/
qui{
local Y dec_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

	* Pooled model by gender
	cap mat drop tmp
	cap mat drop tmp1
	oaxaca `Y' 		`wout_abilities' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_wout_abilities')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_oaxaca_wout
	mat tmp1=r(table)
	mat tmp1=((tmp1[1,4],tmp1[3,4])\(tmp1[2,4],.)),((tmp1[1,5],tmp1[3,5])\(tmp1[2,5],.))
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov' )  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca
	mat tmp=r(table)
	mat tmp=((tmp[1,4],tmp[3,4])\(tmp[2,4],.)),((tmp[1,5],tmp[3,5])\(tmp[2,5],.))
	mat tmp=tmp1,tmp
	clear
	svmat tmp
	gen Aggregate="Total" in 1
	format tmp? %9.4f
	forvalues sdoj=2(2)8 {
				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),abs(invnormal((.1/2))),abs(invnormal((.05/2))),abs(invnormal((.01/2))))
*				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),.01,.05,.1)
	}
	label define star 0 "" 1 "*" 2 "**" 3 "***"
	label value star_tmp? star
	order Aggregate tmp1 star_tmp2 tmp3 star_tmp4 tmp5 star_tmp6 tmp7 star_tmp8
	tostring star_tmp8 tmp?, use replace force
	replace star_tmp8="" if star_tmp8=="0"
	replace star_tmp8="*" if star_tmp8=="1"
	replace star_tmp8="**" if star_tmp8=="2"
	replace star_tmp8="***" if star_tmp8=="3"
	forvalues sdoj=1(2)7 {
				replace tmp`sdoj'="("+tmp`sdoj'+")" in 2
	}
	replace star_tmp8=star_tmp8+"\\" 
	replace star_tmp8="\\" in 2
	drop tmp2 tmp4 tmp6 tmp8
	outsheet using  "${results}/`Y'_aggregate_decomposition1.tex",delimit("&") replace nonames noquote
	insheet using  "${results}/`Y'_aggregate_decomposition1.tex",clear
	save tmp,replace

	}
	estout  `Y'_oaxaca_wout `Y'_pool_oaxaca using "${results}/`Y'_aggregate_decomposition.tex", `tableopt1' unstack drop(group_? difference explained unexplained)
	insheet using "${results}/`Y'_aggregate_decomposition.tex",clear
	append using tmp
	replace v1=regexr(v1,"\\","")
	replace v1=regexr(v1,"\\","\cr")
	replace v1=regexr(v1,"\_"," ")
	replace v1=regexr(v1,"\_"," ")
	drop if inlist(_n,1,2,3)
	outsheet using  "${results}/`Y'_aggregate_decomposition.tex",replace noquote nonames
	erase "${results}/`Y'_aggregate_decomposition1.tex"


/*************************************
Increased Hours during Covid
*************************************/
qui{
local Y inc_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

	* Pooled model by gender
	cap mat drop tmp
	cap mat drop tmp1
	oaxaca `Y' 		`wout_abilities' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_wout_abilities' )  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_oaxaca_wout
	mat tmp1=r(table)
	mat tmp1=((tmp1[1,4],tmp1[3,4])\(tmp1[2,4],.)),((tmp1[1,5],tmp1[3,5])\(tmp1[2,5],.))
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca
	mat tmp=r(table)
	mat tmp=((tmp[1,4],tmp[3,4])\(tmp[2,4],.)),((tmp[1,5],tmp[3,5])\(tmp[2,5],.))
	mat tmp=tmp1,tmp
	clear
	svmat tmp
	gen Aggregate="Total" in 1
	format tmp? %9.4f
	forvalues sdoj=2(2)8 {
				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),abs(invnormal((.1/2))),abs(invnormal((.05/2))),abs(invnormal((.01/2))))
*				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),.01,.05,.1)
	}
	label define star 0 "" 1 "*" 2 "**" 3 "***"
	label value star_tmp? star
	order Aggregate tmp1 star_tmp2 tmp3 star_tmp4 tmp5 star_tmp6 tmp7 star_tmp8
	tostring star_tmp8 tmp?, use replace force
	replace star_tmp8="" if star_tmp8=="0"
	replace star_tmp8="*" if star_tmp8=="1"
	replace star_tmp8="**" if star_tmp8=="2"
	replace star_tmp8="***" if star_tmp8=="3"
	forvalues sdoj=1(2)7 {
				replace tmp`sdoj'="("+tmp`sdoj'+")" in 2
	}
	replace star_tmp8=star_tmp8+"\\" 
	replace star_tmp8="\\" in 2
	drop tmp2 tmp4 tmp6 tmp8
	outsheet using  "${results}/`Y'_aggregate_decomposition1.tex",delimit("&") replace nonames noquote
	insheet using  "${results}/`Y'_aggregate_decomposition1.tex",clear
	save tmp,replace

	}
	estout  `Y'_oaxaca_wout `Y'_pool_oaxaca using "${results}/`Y'_aggregate_decomposition.tex", `tableopt1' unstack drop(group_? difference explained unexplained)
	insheet using "${results}/`Y'_aggregate_decomposition.tex",clear
	append using tmp
	replace v1=regexr(v1,"\\","")
	replace v1=regexr(v1,"\\","\cr")
	replace v1=regexr(v1,"\_"," ")
	replace v1=regexr(v1,"\_"," ")
	drop if inlist(_n,1,2,3)
	outsheet using  "${results}/`Y'_aggregate_decomposition.tex",replace noquote nonames
	erase "${results}/`Y'_aggregate_decomposition1.tex"

/*************************************
Working from home during Covid
*************************************/
qui{
local Y wfh
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

	* Pooled model by gender
	cap mat drop tmp
	cap mat drop tmp1
	oaxaca `Y' 		`wout_abilities' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_wout_abilities' )  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_oaxaca_wout
	mat tmp1=r(table)
	mat tmp1=((tmp1[1,4],tmp1[3,4])\(tmp1[2,4],.)),((tmp1[1,5],tmp1[3,5])\(tmp1[2,5],.))
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov' )  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca
	mat tmp=r(table)
	mat tmp=((tmp[1,4],tmp[3,4])\(tmp[2,4],.)),((tmp[1,5],tmp[3,5])\(tmp[2,5],.))
	mat tmp=tmp1,tmp
	clear
	svmat tmp
	gen Aggregate="Total" in 1
	format tmp? %9.4f
	forvalues sdoj=2(2)8 {
				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),abs(invnormal((.1/2))),abs(invnormal((.05/2))),abs(invnormal((.01/2))))
*				gen star_tmp`sdoj'=irecode(abs(tmp`sdoj'),.01,.05,.1)
	}
	label define star 0 "" 1 "*" 2 "**" 3 "***"
	label value star_tmp? star
	order Aggregate tmp1 star_tmp2 tmp3 star_tmp4 tmp5 star_tmp6 tmp7 star_tmp8
	tostring star_tmp8 tmp?, use replace force
	replace star_tmp8="" if star_tmp8=="0"
	replace star_tmp8="*" if star_tmp8=="1"
	replace star_tmp8="**" if star_tmp8=="2"
	replace star_tmp8="***" if star_tmp8=="3"
	forvalues sdoj=1(2)7 {
				replace tmp`sdoj'="("+tmp`sdoj'+")" in 2
	}
	replace star_tmp8=star_tmp8+"\\" 
	replace star_tmp8="\\" in 2
	drop tmp2 tmp4 tmp6 tmp8
	outsheet using  "${results}/`Y'_aggregate_decomposition1.tex",delimit("&") replace nonames noquote
	insheet using  "${results}/`Y'_aggregate_decomposition1.tex",clear
	save tmp,replace

	}
	estout  `Y'_oaxaca_wout `Y'_pool_oaxaca using "${results}/`Y'_aggregate_decomposition.tex", `tableopt1' unstack drop(group_? difference explained unexplained)
	insheet using "${results}/`Y'_aggregate_decomposition.tex",clear
	append using tmp
	replace v1=regexr(v1,"\\","")
	replace v1=regexr(v1,"\\","\cr")
	replace v1=regexr(v1,"\_"," ")
	replace v1=regexr(v1,"\_"," ")
	drop if inlist(_n,1,2,3)
	outsheet using  "${results}/`Y'_aggregate_decomposition.tex",replace noquote nonames
	erase "${results}/`Y'_aggregate_decomposition1.tex"
log close
cap erase tmp.csv
cap erase tmp1.csv
cap erase tmp.dta

/******************************************************
Tabella Unica (4 outcomes), distnta per endowments & coefficients
	Outcome 1	Outcome 2	Outcome 3	Outcome 4
	Without abilities	With abilities	Without abilities	With abilities	Without abilities	With abilities	Without abilities	With abilities
******************************************************/
foreach Y in u_1c dec_hoursw_1c inc_hoursw_1c wfh {
	insheet using "${results}/`Y'_aggregate_decomposition.tex",clear delimit("&")
	gen indice=_n
	rename v2 v2`Y'
	rename v3 v3`Y'
	rename v6 v6`Y'
	rename v7 v7`Y'
	keep v1 v2 v3 v6 v7 indice
	save "${results}/`Y'_aggregate_decomposition",replace
}
use "${results}/u_1c_aggregate_decomposition",replace
foreach Y in  dec_hoursw_1c inc_hoursw_1c wfh {
	merge 1:1  v1 indice using "${results}/`Y'_aggregate_decomposition", nogen
}
sort indice
drop indice
gen fine="\\"
drop in 17/18
outsheet using  "${results}/aggregate_decomposition_endowments.tex",replace noquote nonames delimit("&")


foreach Y in u_1c dec_hoursw_1c inc_hoursw_1c wfh {
	insheet using "${results}/`Y'_aggregate_decomposition.tex",clear delimit("&")
	gen indice=_n
	rename v4 v4`Y'
	rename v5 v5`Y'
	rename v8 v8`Y'
	rename v9 v9`Y'
	replace v9`Y'=regexr(v9`Y',"\\cr","")
	keep v1 v4 v5 v8 v9 indice
	save "${results}/`Y'_aggregate_decomposition",replace
}
use "${results}/u_1c_aggregate_decomposition",replace
foreach Y in  dec_hoursw_1c inc_hoursw_1c wfh {
	merge 1:1  v1 indice using "${results}/`Y'_aggregate_decomposition", nogen
}
sort indice
drop indice
gen fine="\\"
outsheet using  "${results}/aggregate_decomposition_coefficients.tex",replace noquote nonames delimit("&")
