/*
TBA: 

mental health: sempre gv_health
objective health measures: maxgrip or bmi
manager/white/blu collar
ho037
*/
qui {
	* Table Options 
	#delimit;
	local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
							label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
	local varlabelling varlabel(
							_cons 							"Intercept"
							agec 							"Age"
							agec2 							"Age$^2$"
							agec3 							"Age$^3$"
							low_education                  "Low educ." 
							couple                         "Couple" 
							children                       "Children" 
							bad_health                     "Bad health" 
							big5_extra                     "Extraversion" 
							big5_agree                     "Agreeableness" 
							big5_consc                     "Conscientiousness" 
							big5_neuro                     "Neuroticism" 
							big5_open                      "Openness" 
							bad_numeracy                   "Low numeracy" 
							recall                         "Recall" 
							fluency                        "Fluency" 
							partime                        "Part-time" 
							selfemployed                   "Self-employed" 
							jobpc                          "Use PC" 
							public                         "Public sector" 
							swability						"Potentially remote"
							unsafe							"Unsafe"
							area1                          "Central" 
							area2                          "North " 
							area4                          "East " 
							sector1 "Agriculture    "
							sector2 "Mining    "
							sector3 "Manufacturing    "
							sector4 "Utilities    "
							sector5 "Construction    "
							sector6 "Wholesale and retail trade "
							sector7 "Hotels and restaurants  "
							sector8 "Transport, storage and communication "
							sector9 "Financial intermediation   "
							sector10 "Real estate, renting and business"
							sector11 "Public administration and defence; comp"
							sector12 "Education    "
							sector13 "Health and social work "
							sector14 "Other community, social and personal"
							Prediction_1					"Pr(M)"
							Prediction_2					"Pr(W)"
							Difference						"Pr(M)-Pr(W)"
                              
					);
	local tableopt1 "replace style(tex) c(b(star fmt(4)) se(par fmt(4)))
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";

	local tableopt2 "replace style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4}) 
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";
	#delimit cr
				    
	cap log close
	log using "${results}/estimates", t replace
	

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"partime selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"swability public"; 
	local ability			"jobpc";
	#delimit cr

	
	/*************************************
	Some unemployment spell during Covid
	*************************************/
	local Y u_1c
	local eligible	empl_0c==1 

	* Pooled model by gender
	local basic 		"`mincer' `family' `health' `big5' `cognitive' `job_u_1c' `ability' `sector'"
	noi di _n "Data dropped due to item nonresponse (Pooled areas)" 
	forvalues ss=0(1)1 {
		reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
		estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
	}
	noi estout  `Y'_pool_0 `Y'_pool_1, `tableopt1'

	/********************************
	B1-B0
	********************************/
	suest `Y'_pool_0 `Y'_pool_1
	foreach ofh in `basic' `country_d' _cons {
		test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
		mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p) \ abs(_b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh']) /r(chi2)^.5 , .
	}
	preserve
	clear
	svmat delt_coefs
	gen stella=irecode(delt_coefs2,.01,.05,.1)
	label define stella 0 "***" 1 "**" 2 "*" 3 "" 
	label value stella stella
	drop delt_coefs2
	mat drop delt_coefs
	noi l // vedi
	outsheet using tmp.csv,replace delimit(&) 
	insheet using tmp.csv,delimit(&) clear
	gen indice=_n
	save tmp,replace
	restore

	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_pool_oaxaca
	}
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp.csv, `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp1.csv, `tableopt1' unstack keep(group_? difference explained unexplained)
	do "${dofiles}/4_1_estimates_banca_table"
	outsheet using "${results}/`Y'.tex",replace delimit(&) nonames noquote
	insheet using "${results}/`Y'.tex",clear
	replace v1=regexr(v1,"&\\"," \")
	gen v2=_n
	recode v2 (37=29.1) (38=30.1) (29=33.1) (30=34.1) (33=37.1) (34=38.1)
	sort v2
	drop v2
	outsheet using "${results}/`Y'.tex",replace  nonames noquote
/*************************************
Reduced Hours during Covid
*************************************/
qui{
local Y dec_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
	reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
	estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
}

/********************************
B1-B0
********************************/
suest `Y'_pool_0 `Y'_pool_1
foreach ofh in `basic' `country_d' _cons {
	test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
	mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p) \ abs(_b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh']) /r(chi2)^.5 , .
}
preserve
clear
svmat delt_coefs
gen stella=irecode(delt_coefs2,.01,.05,.1)
label define stella 0 "***" 1 "**" 2 "*" 3 "" 
label value stella stella
drop delt_coefs2
mat drop delt_coefs
	noi l // vedi
	outsheet using tmp.csv,replace delimit(&) 
	insheet using tmp.csv,delimit(&) clear
	gen indice=_n
	save tmp,replace
	restore

oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
estimates store `Y'_pool_oaxaca
*		estimates save "${EST}/`Y'_pool_`ss'", replace
}
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp.csv, `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp1.csv, `tableopt1' unstack keep(group_? difference explained unexplained)
	do "${dofiles}/4_1_estimates_banca_table"
	outsheet using "${results}/`Y'.tex",replace delimit(&) nonames noquote
	insheet using "${results}/`Y'.tex",clear
	replace v1=regexr(v1,"&\\"," \")
	gen v2=_n
	recode v2 (37=29.1) (38=30.1) (29=33.1) (30=34.1) (33=37.1) (34=38.1)
	sort v2
	drop v2
	outsheet using "${results}/`Y'.tex",replace  nonames noquote


/*************************************
Increased Hours during Covid
*************************************/
qui{
local Y inc_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
	reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
	estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
}

	/********************************
	B1-B0
	********************************/
	suest `Y'_pool_0 `Y'_pool_1
	foreach ofh in `basic' `country_d' _cons {
		test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
		mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p) \ abs(_b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh']) /r(chi2)^.5 , .
	}
	preserve
	clear
	svmat delt_coefs
	gen stella=irecode(delt_coefs2,.01,.05,.1)
	label define stella 0 "***" 1 "**" 2 "*" 3 "" 
	label value stella stella
	drop delt_coefs2
	mat drop delt_coefs
	noi l // vedi
	outsheet using tmp.csv,replace delimit(&) 
	insheet using tmp.csv,delimit(&) clear
	gen indice=_n
	save tmp,replace
	restore

oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
estimates store `Y'_pool_oaxaca
*		estimates save "${EST}/`Y'_pool_`ss'", replace
}
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp.csv, `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp1.csv, `tableopt1' unstack keep(group_? difference explained unexplained)
	do "${dofiles}/4_1_estimates_banca_table"
	outsheet using "${results}/`Y'.tex",replace delimit(&) nonames noquote
	insheet using "${results}/`Y'.tex",clear
	replace v1=regexr(v1,"&\\"," \")
	gen v2=_n
	recode v2 (37=29.1) (38=30.1) (29=33.1) (30=34.1) (33=37.1) (34=38.1)
	sort v2
	drop v2
	outsheet using "${results}/`Y'.tex",replace  nonames noquote

/*************************************
Working from home during Covid
*************************************/
qui{
local Y wfh
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

forvalues ss=0(1)1 {
	reg `Y' 		`basic' `country_d'	if `eligible' & female==`ss' `peso'
	estimates store `Y'_pool_`ss'
*		estimates save "${EST}/`Y'_pool_`ss'", replace
}
	/********************************
	B1-B0
	********************************/
	suest `Y'_pool_0 `Y'_pool_1
	foreach ofh in `basic' `country_d' _cons {
		test _b[`Y'_pool_0_mean:`ofh']=_b[`Y'_pool_1_mean:`ofh']
		mat delt_coefs=nullmat(delt_coefs) \ _b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh'] , r(p) \ abs(_b[`Y'_pool_0_mean:`ofh']-_b[`Y'_pool_1_mean:`ofh']) /r(chi2)^.5 , .
	}
	preserve
	clear
	svmat delt_coefs
	gen stella=irecode(delt_coefs2,.01,.05,.1)
	label define stella 0 "***" 1 "**" 2 "*" 3 "" 
	label value stella stella
	drop delt_coefs2
	mat drop delt_coefs
	noi l // vedi
	outsheet using tmp.csv,replace delimit(&) 
	insheet using tmp.csv,delimit(&) clear
	gen indice=_n
	save tmp,replace
	restore

oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso',by(female) weight(1 0) det //weight(1 0) => usiamo i beta da female=0
estimates store `Y'_pool_oaxaca
*		estimates save "${EST}/`Y'_pool_`ss'", replace
}
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp.csv, `tableopt1' unstack drop(group_? difference explained unexplained)
	estout  `Y'_pool_0 `Y'_pool_1 `Y'_pool_oaxaca using tmp1.csv, `tableopt1' unstack keep(group_? difference explained unexplained)
	do "${dofiles}/4_1_estimates_banca_table"
	outsheet using "${results}/`Y'.tex",replace delimit(&) nonames noquote
	insheet using "${results}/`Y'.tex",clear
	replace v1=regexr(v1,"&\\"," \")
	gen v2=_n
	recode v2 (37=29.1) (38=30.1) (29=33.1) (30=34.1) (33=37.1) (34=38.1)
	sort v2
	drop v2
	outsheet using "${results}/`Y'.tex",replace  nonames noquote
log close
cap erase tmp.csv
cap erase tmp1.csv
cap erase tmp.dta



exit
esempio di SURE per b1-b0 (taella)
reg dec_hoursw_1c bad_health age int_year if female==0
est store a
reg dec_hoursw_1c bad_health age int_year if female==1
est store b
suest a b
test _b[a_mean:bad_health]=_b[b_mean:bad_health]
