/*
TBA: 

mental health: sempre gv_health
objective health measures: maxgrip or bmi
manager/white/blu collar
ho037
*/
qui {
	* Table Options 
	#delimit;
	local nl_stat_report stat(diff se_diff pr_1 pr_0 expl se_expl unexpl se_unexpl N, 
							label("Pr(M)-Pr(W)" " " "Pr(M)" "Pr(W)" "Explained" " " "Unexplained" " " "Obs.") fmt(%9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.4f %9.0f));
	local varlabelling varlabel(
							_cons 							"Intercept"
							agec 							"Age"
							agec2 							"Age$^2$"
							agec3 							"Age$^3$"
							low_education                  "Low educ." 
							couple                         "Couple" 
							children                       "Children" 
							bad_health                     "Bad health" 
							big5_extra                     "Extraversion" 
							big5_agree                     "Agreeableness" 
							big5_consc                     "Conscientiousness" 
							big5_neuro                     "Neuroticism" 
							big5_open                      "Openness" 
							bad_numeracy                   "Low numeracy" 
							recall                         "Recall" 
							fluency                        "Fluency" 
							partime                        "Part-time" 
							selfemployed                   "Self-employed" 
							jobpc                          "Use PC" 
							public                         "Public sector" 
							swability						"Potentially remote"
							unsafe							"Unsafe"
							area1                          "Central" 
							area2                          "North " 
							area4                          "East " 
							sector1 "Agriculture    "
							sector2 "Mining    "
							sector3 "Manufacturing    "
							sector4 "Utilities    "
							sector5 "Construction    "
							sector6 "Wholesale and retail trade "
							sector7 "Hotels and restaurants  "
							sector8 "Transport, storage and communication "
							sector9 "Financial intermediation   "
							sector10 "Real estate, renting and business"
							sector11 "Public administration and defence; comp"
							sector12 "Education    "
							sector13 "Health and social work "
							sector14 "Other community, social and personal"
							group_1					"%Pr(M)"
							group_2					"%Pr(W)"
							difference				"Total"
							explained				"Endowments"
							unexplained				"Coefficients"
							Prediction_1					"Pr(M)"
							Prediction_2					"Pr(W)"
							Difference						"Pr(M)-Pr(W)"
                              
					);
	local tableopt1 "replace style(tex) c(b(star fmt(4)) se(par fmt(4)))
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";

	local tableopt2 "replace style(tex) c(b(star fmt(4)) se(par fmt(4))) drop(${country_mr1} ${country_mr2} ${country_mr3} ${country_mr4}) 
					starlevel(* .1 ** .05 *** .01) stardetach stat(N k,  labels("%Sample size" "%k" ) f(%9.0f %9.0f)) varwidth(30) 
					`varlabelling'";
	#delimit cr
				    
	cap log close
	log using "${results}/estimates_aggregate_decomposition_referee", t replace
	

	use "${data}\standard_covid" if interview_both==1, replace
	gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
	gen fair_health=sphus_0c==3 				if sphus_0c!=.

	gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

	gen bad_reading=(reading==4|reading==5)										if reading<.
	gen bad_writing=(writing==4|writing==5)										if writing<.
	gen bad_memory=(memory==4|memory==5)										if memory<.
	gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
	gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
	gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
	gen bad_orient=(orienti<=4)													if orienti<. 
	gen fluency2=fluency^2
	* https://www.my-personaltrainer.it/bmi.htm
	gen low_weight=bmi<18.5														if bmi<.
	gen normal_weight=inrange(bmi,18.5,24.99)									if bmi<.
	gen high_weight=inrange(bmi,25,29.99)										if bmi<.
	gen obese_weight=inrange(bmi,30,100)										if bmi<.

	gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
	qui tab macroreg, gen(area)
	gen swability=sector9+sector10+sector11+sector12+sector13+sector14
	gen unsafe=sector6+sector7+sector12+sector13

	#delimit;
	// local peso			"[pw=cciw_w8_main_ca]";
*	local country_d			"DE SE NL ES FR DK GR CH BE CZ PL LU HU SI EE HR LT BG CY FI LV MT RO SK";
	local country_d			"area1 area2 area4";
	local mincer			"agec agec2 low_education";  
	local family			"couple children";
	*abbiamo visto anche	"children2 sons sons_0_18 sons_19_24 sons_25p daughters_0_18 daughters_19_24 daughters_25p";
	local health 			"bad_health";
#delimit;
local health_new 			"
job_limited mobility
health_fatigue health_limited
health_depression
";
	local cognitive			"bad_numeracy recall fluency";
	local big5				"big5_extra big5_agree big5_consc big5_neuro big5_open";
	*local job_u_1c			"tenurec tenurec2 tenurec3 partime public selfemployed";
	local job_u_1c			"partime selfemployed";
	*local job_u_spell_1c	"public selfemployed"; 
	*local job_ore			"tenurec tenurec2 tenurec3 partime public selfemployed";
	*local sector 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 sector11 sector12 sector13 sector14"; 
	local sector 			"swability public"; 
	local sector1 			"sector1 sector2 sector4 sector5 sector6 sector7 sector8 sector9 sector10 public sector14"; 
	local ability			"jobpc";
	#delimit cr

	// For detailed decomposition
	local deco_demo_indiv 	Individual_demographics:	agec agec2 low_education
	local deco_demo_family 	Family_demographics:		couple children
	local deco_health		Health:						bad_health
	local deco_health_new	Health:						`health_new'
	local deco_big5			Non_cognitive_ability:		big5_extra big5_agree big5_consc big5_neuro big5_open 
	local deco_cognitive	Cognitive_ability:			bad_numeracy recall fluency
	local deco_job_type		Type_of_job:				`job_u_1c' public 
	local deco_job_charac	Job_characteristics:		swability jobpc `ability'
	local deco_job_charac_new	Job_characteristics:		`sector1' `ability'
	local deco_country_d	Geographic:					area1 area2 area4

	
	* Pooled model by gender
	local basic 				"`mincer' `family' `health' 	`big5' `cognitive' 	`job_u_1c' `ability' `sector'"
	local no_cog 				"`mincer' `family' `health' 						`job_u_1c' `ability' `sector'"
	local new_health 			"`mincer' `family' `health_new' `big5' `cognitive' 	`job_u_1c' `ability' `sector'"
	local new_sector 			"`mincer' `family' `health'		`big5' `cognitive' 	`job_u_1c' `ability' `sector1'"
	local detils_cov			`deco_demo_indiv',`deco_demo_family',`deco_big5',`deco_cognitive',`deco_job_type',`deco_country_d',`deco_job_charac',`deco_health'
	local detils_nocog			`deco_demo_indiv',`deco_demo_family',`deco_big5',`deco_job_type',`deco_country_d',`deco_job_charac',`deco_health'
	local detils_cov_health		`deco_demo_indiv',`deco_demo_family',`deco_big5',`deco_cognitive',`deco_job_type',`deco_country_d',`deco_job_charac',`deco_health_new'
	local detils_cov_sectors	`deco_demo_indiv',`deco_demo_family',`deco_big5',`deco_cognitive',`deco_job_type',`deco_country_d',`deco_job_charac_new',`deco_health'
	// Alternative decomposition
*	local detils_cov	mincer:`mincer', family:`family', health:`health', big5:`big5', cognitive:`cognitive', ability:`ability', sector:`sector', area:`country_d'

	/*************************************
	Some unemployment spell during Covid
	*************************************/
gen cronic=health_chronic>0 if health_chronic>=0
gen limit=health_daily_limit_number>0 if health_daily_limit_number>=0
foreach hhsd of local health_new {
	replace `hhsd'=. if `hhsd'<0	
}
	local Y u_1c
	local eligible	empl_0c==1 
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_basic
	oaxaca `Y' 		`no_cog' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_nocog')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_nocog
	oaxaca `Y' 		`new_sector' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_sectors')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_sector
	oaxaca `Y' 		`new_health' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_health')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_health
	estout  `Y'_basic `Y'_nocog `Y'_sector `Y'_health using "${results}/`Y'_aggregate_decomposition_referee.tex", `tableopt1' collabel(none) mlabel(none)
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear
	noi l
	/*To latex*/
	// effects
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	keep in  8/11
	gen tmp=_n
	replace tmp=tmp-2 if tmp>=3
	tempfile total
	preserve
	keep if inrange(_n,3,4)
	ren v* v1*
	save `total'
	restore	
	keep if inrange(_n,1,2)
	merge 1:1 tmp using `total'
	drop v11 tmp _merge
	replace v1="Total" in 1
	save `total',replace
	// covariate
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	drop in 1/5
	gen tmp=_n-8
	sum tmp if regexm(v1,"unexplained")==1
	local contatore = r(mean)
	gen indice=tmp > `contatore'
	replace tmp = tmp - `contatore'-1 if tmp>=`contatore'
	tempfile tmp
	preserve
	keep if inrange(tmp,0,`contatore'+1) & indice==1
	ren v* v1*
	ren v11 v1
	sort tmp
	gen new_indice=_n
	save `tmp'
	restore
	keep if inrange(tmp,0,`contatore') & indice==0
	sort tmp
	gen new_indice=_n
	merge 1:1 v1 new_indice using `tmp'
	sort new_indice
	append using `total'

	replace v9=regexr(v9,"\\"," ")
	replace v9=regexr(v9,"\\"," ")	
	replace v19=regexr(v19,"\\"," ")
	replace v19=regexr(v19,"\\"," ")	
	drop tmp *indice* _merge
	gen fine="\\"
	replace v1=regexr(v1,"_"," ")
	replace v1=regexr(v1,"_"," ")
	outsheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",replace noquote nonames delimit("&")
	noi l
	}

/*************************************
Reduced Hours during Covid
*************************************/
qui{
local Y dec_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen cronic=health_chronic>0 if health_chronic>=0
gen limit=health_daily_limit_number>0 if health_daily_limit_number>=0
foreach hhsd of local health_new {
	replace `hhsd'=. if `hhsd'<0	
}
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

	* Pooled model by gender
	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_basic
	oaxaca `Y' 		`no_cog' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_nocog')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_nocog
	oaxaca `Y' 		`new_sector' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_sectors')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_sector
	oaxaca `Y' 		`new_health' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_health')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_health
	estout  `Y'_basic `Y'_nocog `Y'_sector `Y'_health using "${results}/`Y'_aggregate_decomposition_referee.tex", `tableopt1' collabel(none) mlabel(none)
	/*To latex*/
	// effects
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	keep in  8/11
	gen tmp=_n
	replace tmp=tmp-2 if tmp>=3
	tempfile total
	preserve
	keep if inrange(_n,3,4)
	ren v* v1*
	save `total'
	restore	
	keep if inrange(_n,1,2)
	merge 1:1 tmp using `total'
	drop v11 tmp _merge
	replace v1="Total" in 1
	save `total',replace
	// covariate
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	drop in 1/5
	gen tmp=_n-8
	sum tmp if regexm(v1,"unexplained")==1
	local contatore = r(mean)
	gen indice=tmp > `contatore'
	replace tmp = tmp - `contatore'-1 if tmp>=`contatore'
	tempfile tmp
	preserve
	keep if inrange(tmp,0,`contatore'+1) & indice==1
	ren v* v1*
	ren v11 v1
	sort tmp
	gen new_indice=_n
	save `tmp'
	restore
	keep if inrange(tmp,0,`contatore') & indice==0
	sort tmp
	gen new_indice=_n
	merge 1:1 v1 new_indice using `tmp'
	sort new_indice
	append using `total'

	replace v9=regexr(v9,"\\"," ")
	replace v9=regexr(v9,"\\"," ")	
	replace v19=regexr(v19,"\\"," ")
	replace v19=regexr(v19,"\\"," ")	
	drop tmp *indice* _merge
	gen fine="\\"
	replace v1=regexr(v1,"_"," ")
	replace v1=regexr(v1,"_"," ")
	outsheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",replace noquote nonames delimit("&")
	noi l


/*************************************
Increased Hours during Covid
*************************************/
qui{
local Y inc_hoursw_1c
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen cronic=health_chronic>0 if health_chronic>=0
gen limit=health_daily_limit_number>0 if health_daily_limit_number>=0
foreach hhsd of local health_new {
	replace `hhsd'=. if `hhsd'<0	
}
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_basic
	oaxaca `Y' 		`no_cog' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_nocog')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_nocog
	oaxaca `Y' 		`new_sector' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_sectors')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_sector
	oaxaca `Y' 		`new_health' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_health')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_health
	estout  `Y'_basic `Y'_nocog `Y'_sector `Y'_health using "${results}/`Y'_aggregate_decomposition_referee.tex", `tableopt1' collabel(none) mlabel(none)
	/*To latex*/
	// effects
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	keep in  8/11
	gen tmp=_n
	replace tmp=tmp-2 if tmp>=3
	tempfile total
	preserve
	keep if inrange(_n,3,4)
	ren v* v1*
	save `total'
	restore	
	keep if inrange(_n,1,2)
	merge 1:1 tmp using `total'
	drop v11 tmp _merge
	replace v1="Total" in 1
	save `total',replace
	// covariate
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	drop in 1/5
	gen tmp=_n-8
	sum tmp if regexm(v1,"unexplained")==1
	local contatore = r(mean)
	gen indice=tmp > `contatore'
	replace tmp = tmp - `contatore'-1 if tmp>=`contatore'
	tempfile tmp
	preserve
	keep if inrange(tmp,0,`contatore'+1) & indice==1
	ren v* v1*
	ren v11 v1
	sort tmp
	gen new_indice=_n
	save `tmp'
	restore
	keep if inrange(tmp,0,`contatore') & indice==0
	sort tmp
	gen new_indice=_n
	merge 1:1 v1 new_indice using `tmp'
	sort new_indice
	append using `total'

	replace v9=regexr(v9,"\\"," ")
	replace v9=regexr(v9,"\\"," ")	
	replace v19=regexr(v19,"\\"," ")
	replace v19=regexr(v19,"\\"," ")	
	drop tmp *indice* _merge
	gen fine="\\"
	replace v1=regexr(v1,"_"," ")
	replace v1=regexr(v1,"_"," ")
	outsheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",replace noquote nonames delimit("&")
	noi l

/*************************************
Working from home during Covid
*************************************/
qui{
local Y wfh
local eligible	empl_0c==1 
use "${data}\standard_covid" if interview_both==1, replace
gen cronic=health_chronic>0 if health_chronic>=0
gen limit=health_daily_limit_number>0 if health_daily_limit_number>=0
foreach hhsd of local health_new {
	replace `hhsd'=. if `hhsd'<0	
}
gen bad_health=sphus_0c==4|sphus_0c==5 		if sphus_0c!=.
gen fair_health=sphus_0c==3 				if sphus_0c!=.

gen child_0_25=sons_0_18+sons_19_24+daughters_0_18+daughters_19_24

gen bad_reading=(reading==4|reading==5)										if reading<.
gen bad_writing=(writing==4|writing==5)										if writing<.
gen bad_memory=(memory==4|memory==5)										if memory<.
gen bad_numeracy1=(numeracy==1|numeracy==2|numeracy==3)						if numeracy<.
gen bad_numeracy2=(numeracy2==0|numeracy2==1|numeracy2==2|numeracy2==3|numeracy2==4)		if numeracy2<.
gen bad_numeracy=(bad_numeracy1==1|bad_numeracy2==1)						if numeracy<. & numeracy2<.
gen bad_orient=(orienti<=4)													if orienti<. 
gen fluency2=fluency^2

gen public1=(sector11==1|sector12==1|sector13==1)							if sector<.
qui tab macroreg, gen(area)
gen swability=sector9+sector10+sector11+sector12+sector13+sector14
gen unsafe=sector6+sector7+sector12+sector13

	oaxaca `Y' 		`basic' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_basic
	oaxaca `Y' 		`no_cog' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_nocog')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_nocog
	oaxaca `Y' 		`new_sector' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_sectors')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_sector
	oaxaca `Y' 		`new_health' `country_d'	if `eligible' `peso', by(female) weight(1 0) detail(`detils_cov_health')  //weight(1 0) => usiamo i beta da female=0
	estimates store `Y'_health
	estout  `Y'_basic `Y'_nocog `Y'_sector `Y'_health using "${results}/`Y'_aggregate_decomposition_referee.tex", `tableopt1' collabel(none) mlabel(none)
	/*To latex*/
	// effects
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	keep in  8/11
	gen tmp=_n
	replace tmp=tmp-2 if tmp>=3
	tempfile total
	preserve
	keep if inrange(_n,3,4)
	ren v* v1*
	save `total'
	restore	
	keep if inrange(_n,1,2)
	merge 1:1 tmp using `total'
	drop v11 tmp _merge
	replace v1="Total" in 1
	save `total',replace
	// covariate
	insheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",clear delimit("&")
	drop in 1/5
	gen tmp=_n-8
	sum tmp if regexm(v1,"unexplained")==1
	local contatore = r(mean)
	gen indice=tmp > `contatore'
	replace tmp = tmp - `contatore'-1 if tmp>=`contatore'
	tempfile tmp
	preserve
	keep if inrange(tmp,0,`contatore'+1) & indice==1
	ren v* v1*
	ren v11 v1
	sort tmp
	gen new_indice=_n
	save `tmp'
	restore
	keep if inrange(tmp,0,`contatore') & indice==0
	sort tmp
	gen new_indice=_n
	merge 1:1 v1 new_indice using `tmp'
	sort new_indice
	append using `total'

	replace v9=regexr(v9,"\\"," ")
	replace v9=regexr(v9,"\\"," ")	
	replace v19=regexr(v19,"\\"," ")
	replace v19=regexr(v19,"\\"," ")	
	drop tmp *indice* _merge
	gen fine="\\"
	replace v1=regexr(v1,"_"," ")
	replace v1=regexr(v1,"_"," ")
	outsheet using  "${results}/`Y'_aggregate_decomposition_referee.tex",replace noquote nonames delimit("&")
	noi l
log close
exit
