*-------------------------------------------------------------------------------------------------------------------------
* Merging questoinnaires (completo)
*-------------------------------------------------------------------------------------------------------------------------
use "${data}\standard_completo",replace
merge 1:1 mergeid using "${data}\covid_completo", replace update
gen interview_standard=(_merge==1|_merge==3)
gen interview_covid   =(_merge==2|_merge==3)
gen interview_both	  =(_merge==3)
drop _merge
sort mergeid
save "${data}\standard_covid_completo",replace
*-------------------------------------------------------------------------------------------------------------------------

*-------------------------------------------------------------------------------------------------------------------------
* Merging questoinnaires
*-------------------------------------------------------------------------------------------------------------------------
use "${data}\standard",replace
merge 1:1 mergeid using "${data}\covid", replace update
gen interview_standard=(_merge==1|_merge==3)
gen interview_covid   =(_merge==2|_merge==3)
gen interview_both	  =(_merge==3)
drop _merge
sort mergeid
save "${data}\standard_covid",replace
*-------------------------------------------------------------------------------------------------------------------------


*-------------------------------------------------------------------------------------------------------------------------
* Genera regressori del modello
*-------------------------------------------------------------------------------------------------------------------------
use "${data}\standard_covid", clear

* Variabili dipendenti
// Unemployment
replace u_1c=0 if u_spell_1==0
replace u_spell_1=0 if u_1c==0
replace empl_0c=0 if hoursw_0c==0
replace hoursw_0c=. if hoursw_0c==0 
gen marzo2020=4*(ym(int_year_ca,int_month_ca)-ym(2020,3))+2
gen flag=1 if u_spell_1 > marzo2020 & u_1c==1
replace u_1c=. if flag==1
replace u_spell_1=. if flag==1
drop flag
// # of hours
gen flag=1 if low_hoursw_1c >= hoursw_0c & hoursw_0c>0 & low_hoursw_1c>=0
replace low_hoursw_1c=. if flag==1
drop flag
gen flag=1 if hoursw_0c >= high_hoursw_1c & hoursw_0c>0 & high_hoursw_1c>=0
replace high_hoursw_1c=. if flag==1
drop flag
gen change_hours_1_c=dec_hoursw_1c==1 | inc_hoursw_1c==1 if (dec_hoursw_1c!=. & inc_hoursw_1c!=.)
label var change_hours_1_c "Number of hours has changed bc Covid"
replace high_hoursw_1c=. if (high_hoursw_1c)>84			// 84=12 * 7 = 12 h per each day of the week
replace low_hoursw_1c=. if  (low_hoursw_1c)>84
replace hoursw_0c=. if  (hoursw_0c)>84
gen 	delta_hours_1_c=(high_hoursw_1c-hoursw_0c) 	if inc_hoursw_1c==1 & dec_hoursw_1c==0
replace delta_hours_1_c=(low_hoursw_1c-hoursw_0c) 	if inc_hoursw_1c==0 & dec_hoursw_1c==1
replace delta_hours_1_c=(high_hoursw_1c-low_hoursw_1c) 	if inc_hoursw_1c==1 & dec_hoursw_1c==1
replace delta_hours_1_c=0 							if inc_hoursw_1c==0 & dec_hoursw_1c==0
label var delta_hours_1_c "Maximum change in working hours bc Covid" 
gen		hmax_1_c=hoursw_0c			if inc_hoursw_1c==0 & dec_hoursw_1c==0
replace hmax_1_c=high_hoursw_1c		if inc_hoursw_1c==1 & dec_hoursw_1c==0
replace hmax_1_c=hoursw_0c			if inc_hoursw_1c==0 & dec_hoursw_1c==1
replace hmax_1_c=high_hoursw_1c		if inc_hoursw_1c==1 & dec_hoursw_1c==1
label var hmax_1_c "Maximum number of hours during Covid" 
gen		hmin_1_c=hoursw_0c			if inc_hoursw_1c==0 & dec_hoursw_1c==0
replace hmin_1_c=hoursw_0c			if inc_hoursw_1c==1 & dec_hoursw_1c==0
replace hmin_1_c=low_hoursw_1c		if inc_hoursw_1c==0 & dec_hoursw_1c==1
replace hmin_1_c=low_hoursw_1c		if inc_hoursw_1c==1 & dec_hoursw_1c==1
label var hmin_1_c "Minimum number of hours during Covid" 


* Age polynomials
gen agec=age-55
gen agec2=(agec)^2
gen agec3=(agec)^3

gen tenurec=tenure-30
gen tenurec2=tenurec^2
gen tenurec3=tenurec^3

/* Average differential in employment by country and age
local Y "empself"
egen avg0=mean(`Y') if female==0, by(macroreg age)
egen avg1=mean(`Y') if female==1, by(macroreg age)
egen tmp0=mean(avg0),by(macroreg age)
egen tmp1=mean(avg1),by(macroreg age)
gen avg_`Y'=tmp1-tmp0
*/

gen wfh=(pwork==1|pwork==3)	if pwork==1|pwork==2|pwork==3
tab skillpc if skillpc!=.,gen(skillpc)
label var skillpc1 "Level: Expert"
label var skillpc6 "Level: Scarce"
tab sector if sector!=.,gen(sector)
label var sector1 "Agriculture, hunting, forestry, fishing  "
label var sector2 "                   Mining and quarrying  "
label var sector3 "                          Manufacturing  "
label var sector4 "      Electricity, gas and water supply  "
label var sector5 "                           Construction  "
label var sector6 "Wholesale and retail trade; repair of m  "
label var sector7 "                 Hotels and restaurants  "
label var sector8 "   Transport, storage and communication  "
label var sector9 "               Financial intermediation  "
label var sector10 "Real estate, renting and business activ  "
label var sector11 "Public administration and defence; comp  "
label var sector12 "                              Education  "
label var sector13 "                 Health and social work  "
label var sector14 "Other community, social and personal se  "


gen interview_spell=4*(ym(int_year_ca,int_month_ca)-ym(int_year,int_month))


lab define fem 0 "Men" 1 "Women"
lab val female fem
 
sort mergeid
save "${data}\standard_covid",replace
*-------------------------------------------------------------------------------------------------------------------------
